/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.client.render.entity;

import icbm.classic.content.entity.EntityExplosion;
import icbm.classic.content.explosive.blast.BlastRedmatter;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.glu.Sphere;

@SideOnly(value=Side.CLIENT)
public class RenderExplosion
extends Render<EntityExplosion> {
    public static final ResourceLocation TEXTURE_FILE = new ResourceLocation("icbmclassic", "textures/blackhole.png");
    public static ResourceLocation GREY_TEXTURE = new ResourceLocation("icbmclassic", "textures/grey.png");
    public static List<Color> randomColorsForBeams = new ArrayList<Color>();
    public Color colorIn = new Color(0xFFFFFF);
    public Color colorOut = new Color(0);

    public RenderExplosion(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(EntityExplosion entityExplosion, double x, double y, double z, float par8, float par9) {
        if (entityExplosion.getBlast() != null) {
            if (entityExplosion.getBlast() instanceof BlastRedmatter) {
                BlastRedmatter redmatter = (BlastRedmatter)entityExplosion.getBlast();
                float scale = redmatter.getScaleFactor();
                this.renderDisk(entityExplosion, redmatter, x, y, z, scale, par8, par9);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.renderSphere(entityExplosion, redmatter, x, y, z, scale, par8, par9);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.renderBeams(entityExplosion, redmatter, x, y, z, scale, par8, par9);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else if (entityExplosion.getBlast().getRenderModel() != null && entityExplosion.getBlast().getRenderResource() != null) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)((float)x), (float)((float)y + 1.0f), (float)((float)z));
                GlStateManager.func_179114_b((float)entityExplosion.field_70125_A, (float)0.0f, (float)0.0f, (float)1.0f);
                this.func_110776_a(entityExplosion.getBlast().getRenderResource());
                entityExplosion.getBlast().getRenderModel().func_78088_a(entityExplosion, (float)x, (float)y, (float)z, par8, par9, 0.0625f);
                GlStateManager.func_179121_F();
            }
        }
    }

    public void renderSphere(EntityExplosion entityExplosion, BlastRedmatter redmatter, double x, double y, double z, float scale, float par8, float par9) {
        float radius = Math.max(6.0f * scale, 0.1f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
        this.func_110776_a(GREY_TEXTURE);
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        new Sphere().draw(radius * 0.8f, 32, 32);
        GlStateManager.func_179121_F();
        float ticks = entityExplosion.field_70173_aa % 40;
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179140_f();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
        this.func_110776_a(GREY_TEXTURE);
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.2f, (float)0.8f);
        float scaleSize = 5.0E-4f;
        float fullSize = radius * 5.0E-4f * 20.0f;
        float scaleDelta = ticks > 20.0f ? fullSize - radius * 5.0E-4f * (ticks - 20.0f) : radius * 5.0E-4f * ticks;
        new Sphere().draw(radius + scaleDelta, 32, 32);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        RenderHelper.func_74519_b();
    }

    public void renderDisk(EntityExplosion entityExplosion, BlastRedmatter redmatter, double x, double y, double z, float scale, float par8, float par9) {
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        float size = 6.0f * scale * 3.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179140_f();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)(-entityExplosion.field_70173_aa), (float)0.0f, (float)1.0f, (float)0.0f);
        this.func_110776_a(TEXTURE_FILE);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(-size), 0.0, (double)(-size)).func_187315_a(0.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)(-size), 0.0, (double)size).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)size, 0.0, (double)size).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)size, 0.0, (double)(-size)).func_187315_a(1.0, 0.0).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(-size), 0.0, (double)(-size)).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)(-size), 0.0, (double)size).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)size, 0.0, (double)size).func_187315_a(0.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)size, 0.0, (double)(-size)).func_187315_a(0.0, 1.0).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        RenderHelper.func_74519_b();
    }

    public void renderBeams(EntityExplosion entityExplosion, BlastRedmatter redmatter, double x, double y, double z, float scale, float par8, float par9) {
        int totalAnimationTime = 4000;
        int rotationAnimationTime = 200;
        float animationPhaseTime = 2000.0f;
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        RenderHelper.func_74518_a();
        int ticks = entityExplosion.field_70173_aa % 4000;
        float rotationScale = (float)(entityExplosion.field_70173_aa % 200) / 200.0f;
        float timeScale = (float)ticks < 2000.0f ? (float)ticks / 2000.0f : 2.0f - (float)ticks / 2000.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
        GlStateManager.func_179090_x();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_179118_c();
        GlStateManager.func_179089_o();
        Random redmatterBeamRandom = new Random(432L);
        int beamCount = (int)((timeScale + timeScale * timeScale) / 2.0f * 60.0f);
        for (int beamIndex = 0; beamIndex < beamCount; ++beamIndex) {
            GlStateManager.func_179094_E();
            float beamLength = (redmatterBeamRandom.nextFloat() * 20.0f + 5.0f) * scale;
            float beamWidth = (redmatterBeamRandom.nextFloat() * 2.0f + 1.0f) * scale;
            GlStateManager.func_179114_b((float)(redmatterBeamRandom.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(redmatterBeamRandom.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(redmatterBeamRandom.nextFloat() * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(redmatterBeamRandom.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(redmatterBeamRandom.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(redmatterBeamRandom.nextFloat() * 360.0f + rotationScale * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            Color colorOut = this.colorOut;
            Color colorIn = this.colorIn;
            if (redmatter.coloredBeams) {
                if (beamIndex < randomColorsForBeams.size()) {
                    colorOut = randomColorsForBeams.get(beamIndex);
                } else {
                    colorOut = new Color(redmatterBeamRandom.nextFloat(), redmatterBeamRandom.nextFloat(), redmatterBeamRandom.nextFloat());
                    randomColorsForBeams.add(colorOut);
                }
            }
            bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_181662_b(0.0, 0.0, 0.0).func_181669_b(colorIn.getRed(), colorIn.getGreen(), colorIn.getBlue(), colorIn.getAlpha()).func_181675_d();
            bufferbuilder.func_181662_b(-0.866 * (double)beamWidth, (double)beamLength, (double)(-0.5f * beamWidth)).func_181669_b(colorOut.getRed(), colorOut.getGreen(), colorOut.getBlue(), colorOut.getAlpha()).func_181675_d();
            bufferbuilder.func_181662_b(0.866 * (double)beamWidth, (double)beamLength, (double)(-0.5f * beamWidth)).func_181669_b(colorOut.getRed(), colorOut.getGreen(), colorOut.getBlue(), colorOut.getAlpha()).func_181675_d();
            bufferbuilder.func_181662_b(0.0, (double)beamLength, (double)(1.0f * beamWidth)).func_181669_b(colorOut.getRed(), colorOut.getGreen(), colorOut.getBlue(), colorOut.getAlpha()).func_181675_d();
            bufferbuilder.func_181662_b(-0.866 * (double)beamWidth, (double)beamLength, (double)(-0.5f * beamWidth)).func_181669_b(colorOut.getRed(), colorOut.getGreen(), colorOut.getBlue(), colorOut.getAlpha()).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179129_p();
        GlStateManager.func_179084_k();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
    }

    @Nullable
    protected ResourceLocation getEntityTexture(EntityExplosion entity) {
        return entity.getBlast().getRenderResource();
    }
}

