/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.world.generator;

import cofh.cofhworld.data.numbers.ConstantProvider;
import cofh.cofhworld.data.numbers.INumberProvider;
import cofh.cofhworld.util.random.WeightedBlock;
import cofh.cofhworld.util.random.WeightedEnum;
import cofh.cofhworld.util.random.WeightedNBTTag;
import cofh.cofhworld.world.generator.WorldGen;
import java.util.List;
import java.util.Random;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;

public class WorldGenStructure
extends WorldGen {
    private final PlacementSettings placementSettings = new PlacementSettings();
    private final Template template;
    private final List<WeightedNBTTag> templates;
    private final List<WeightedBlock> ignoredBlocks;
    private List<WeightedEnum<Rotation>> rots;
    private List<WeightedEnum<Mirror>> mirrors;
    private INumberProvider integrity = new ConstantProvider(Float.valueOf(2.0f));

    public WorldGenStructure(List<WeightedNBTTag> templates, List<WeightedBlock> ignoredBlocks, boolean ignoreEntities) {
        if (templates.size() > 1) {
            this.templates = templates;
            this.template = null;
        } else {
            this.templates = null;
            this.template = new Template();
            this.template.func_186256_b(templates.get(0).getCompoundTag());
        }
        if (ignoredBlocks.size() > 1) {
            this.ignoredBlocks = ignoredBlocks;
        } else {
            this.ignoredBlocks = null;
            if (ignoredBlocks.size() > 0) {
                this.placementSettings.func_186225_a(ignoredBlocks.get((int)0).block);
            }
        }
        this.placementSettings.func_186222_a(ignoreEntities);
    }

    public WorldGenStructure setIntegrity(INumberProvider itg) {
        this.integrity = itg;
        return this;
    }

    public WorldGenStructure setDetails(List<WeightedEnum<Rotation>> rot, List<WeightedEnum<Mirror>> mir) {
        switch (rot.size()) {
            case 1: {
                this.placementSettings.func_186220_a((Rotation)rot.get((int)0).value);
            }
            case 0: {
                rot = null;
            }
        }
        this.rots = rot;
        switch (mir.size()) {
            case 1: {
                this.placementSettings.func_186214_a((Mirror)mir.get((int)0).value);
            }
            case 0: {
                mir = null;
            }
        }
        this.mirrors = mir;
        return this;
    }

    @Override
    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        Template template = this.template;
        if (this.templates != null) {
            template = new Template();
            template.func_186256_b(((WeightedNBTTag)WeightedRandom.func_76271_a((Random)random, this.templates)).getCompoundTag());
        }
        PlacementSettings settings = this.placementSettings.func_186217_a();
        settings.func_189950_a(random);
        if (this.rots != null) {
            settings.func_186220_a((Rotation)((WeightedEnum)WeightedRandom.func_76271_a((Random)random, this.rots)).value);
        }
        if (this.mirrors != null) {
            settings.func_186214_a((Mirror)((WeightedEnum)WeightedRandom.func_76271_a((Random)random, this.mirrors)).value);
        }
        if (this.ignoredBlocks != null) {
            settings.func_186225_a(((WeightedBlock)WeightedRandom.func_76271_a((Random)random, this.ignoredBlocks)).block);
        }
        BlockPos start = template.func_189961_a(pos, settings.func_186212_b(), settings.func_186215_c());
        settings.func_189946_a(this.integrity.floatValue(world, random, new INumberProvider.DataHolder(pos)));
        template.func_189962_a(world, start, settings, 20);
        return true;
    }
}

