/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.threng.util;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IItemDefinition;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.crafting.MECraftingInventory;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import io.github.phantamanta44.libnine.util.IDisplayableMatcher;
import io.github.phantamanta44.libnine.util.ImpossibilityRealizedException;
import io.github.phantamanta44.libnine.util.helper.ItemUtils;
import io.github.phantamanta44.libnine.util.helper.MirrorUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public class AppEngUtils {
    public static final IDisplayableMatcher<ItemStack> IS_UPGRADE_ACCEL = AppEngUtils.genItemPredicate(defs -> defs.materials().cardSpeed());
    private static final MirrorUtils.IField<Map<?, ?>> fTasks = MirrorUtils.reflectField(CraftingCPUCluster.class, (String)"tasks");
    private static final MirrorUtils.IField<MECraftingInventory> fInventory = MirrorUtils.reflectField(CraftingCPUCluster.class, (String)"inventory");
    private static final MirrorUtils.IField<IItemList<IAEItemStack>> fWaitingFor = MirrorUtils.reflectField(CraftingCPUCluster.class, (String)"waitingFor");
    private static final Field fValue;

    private static IDisplayableMatcher<ItemStack> genItemPredicate(Function<IDefinitions, IItemDefinition> item) {
        return item.apply(AEApi.instance().definitions()).maybeStack(1).map(ItemUtils::matchesWithWildcard).orElse(IDisplayableMatcher.of(() -> new ItemStack(Blocks.field_180401_cv), s -> false));
    }

    public static Set<CraftingTask> getTasks(CraftingCPUCluster cpu) {
        return ((Map)fTasks.get((Object)cpu)).entrySet().stream().map(t -> new CraftingTask(cpu, (Map.Entry<?, ?>)t)).collect(Collectors.toSet());
    }

    public static void importItems(IItemHandlerModifiable inventory, IMEMonitor<IAEItemStack> storage, IEnergyGrid energy, IActionSource actionSource) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            IAEItemStack remaining = (IAEItemStack)Platform.poweredInsert((IEnergySource)energy, storage, (IAEStack)((IAEStack)Objects.requireNonNull(AEItemStack.fromItemStack((ItemStack)stack))), (IActionSource)actionSource);
            inventory.setStackInSlot(i, remaining != null ? remaining.createItemStack() : ItemStack.field_190927_a);
        }
    }

    static {
        try {
            fValue = Class.forName("appeng.me.cluster.implementations.CraftingCPUCluster$TaskProgress").getDeclaredField("value");
            fValue.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            throw new ImpossibilityRealizedException((Throwable)e);
        }
    }

    public static class CraftingTask {
        private final CraftingCPUCluster cpu;
        private final Map.Entry<?, ?> entry;

        CraftingTask(CraftingCPUCluster cpu, Map.Entry<?, ?> entry) {
            this.cpu = cpu;
            this.entry = entry;
        }

        public ICraftingPatternDetails getPattern() {
            return (ICraftingPatternDetails)this.entry.getKey();
        }

        public long getInvocations() {
            try {
                return fValue.getLong(this.entry.getValue());
            }
            catch (IllegalAccessException e) {
                throw new ImpossibilityRealizedException((Throwable)e);
            }
        }

        public boolean tryExtractItems(IActionSource actionSource) {
            MECraftingInventory inv = (MECraftingInventory)fInventory.get((Object)this.cpu);
            ArrayList<IAEItemStack> extracted = new ArrayList<IAEItemStack>();
            for (IAEItemStack input : this.getPattern().getCondensedInputs()) {
                IAEItemStack stack = inv.extractItems(input, Actionable.MODULATE, actionSource);
                extracted.add(stack);
                if (stack != null && stack.getStackSize() == input.getStackSize()) continue;
                for (IAEItemStack extractedStack : extracted) {
                    inv.injectItems(extractedStack, Actionable.MODULATE, actionSource);
                }
                return false;
            }
            return true;
        }

        public void decrement() {
            try {
                fValue.setLong(this.entry.getValue(), this.getInvocations() - 1L);
                IItemList waitingFor = (IItemList)fWaitingFor.get((Object)this.cpu);
                for (IAEItemStack output : this.getPattern().getCondensedOutputs()) {
                    waitingFor.add((IAEStack)output.copy());
                }
            }
            catch (IllegalAccessException e) {
                throw new ImpossibilityRealizedException((Throwable)e);
            }
        }
    }
}

