/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.IConfigCardAccess;
import mekanism.api.TileNetworkList;
import mekanism.common.HashList;
import mekanism.common.Mekanism;
import mekanism.common.Upgrade;
import mekanism.common.base.IComparatorSupport;
import mekanism.common.base.ILogisticalTransporter;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.transporter.Finder;
import mekanism.common.content.transporter.InvStack;
import mekanism.common.content.transporter.StackSearcher;
import mekanism.common.content.transporter.TItemStackFilter;
import mekanism.common.content.transporter.TOreDictFilter;
import mekanism.common.content.transporter.TransitRequest;
import mekanism.common.content.transporter.TransporterFilter;
import mekanism.common.integration.computer.IComputerIntegration;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.tile.prefab.TileEntityEffectsBlock;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StackUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityLogisticalSorter
extends TileEntityEffectsBlock
implements IRedstoneControl,
IConfigCardAccess.ISpecialConfigData,
ISustainedData,
ISecurityTile,
IComputerIntegration,
IUpgradeTile,
IComparatorSupport {
    public HashList<TransporterFilter> filters = new HashList();
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    public EnumColor color;
    public boolean autoEject;
    public boolean roundRobin;
    public boolean singleItem;
    public int rrIndex = 0;
    public int delayTicks;
    public TileComponentUpgrade upgradeComponent;
    public TileComponentSecurity securityComponent = new TileComponentSecurity(this);
    public String[] methods = new String[]{"setDefaultColor", "setRoundRobin", "setAutoEject", "addFilter", "removeFilter", "addOreFilter", "removeOreFilter", "setSingleItem"};
    private int currentRedstoneLevel;

    public TileEntityLogisticalSorter() {
        super("machine.logisticalsorter", "LogisticalSorter", BlockStateMachine.MachineType.LOGISTICAL_SORTER.getStorage(), 3);
        this.inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
        this.doAutoSync = false;
        this.upgradeComponent = new TileComponentUpgrade(this, 1);
        this.upgradeComponent.clearSupportedTypes();
        this.upgradeComponent.setSupported(Upgrade.MUFFLING);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            int newRedstoneLevel;
            this.delayTicks = Math.max(0, this.delayTicks - 1);
            if (this.delayTicks == 6) {
                this.setActive(false);
            }
            if (MekanismUtils.canFunction(this) && this.delayTicks == 0) {
                TileEntity back = Coord4D.get(this).offset(this.facing.func_176734_d()).getTileEntity((IBlockAccess)this.field_145850_b);
                TileEntity front = Coord4D.get(this).offset(this.facing).getTileEntity((IBlockAccess)this.field_145850_b);
                if (back != null && front != null) {
                    TransitRequest request;
                    TransitRequest.TransitResponse response;
                    boolean sentItems = false;
                    int min = 0;
                    block0: for (TransporterFilter filter : this.filters) {
                        InvStack invStack;
                        StackSearcher search = new StackSearcher(back, this.facing.func_176734_d());
                        while (search.getSlotCount() >= 0 && (invStack = filter.getStackFromInventory(search, this.singleItem)) != null) {
                            TransitRequest request2;
                            TransitRequest.TransitResponse response2;
                            ItemStack itemStack = invStack.getStack();
                            if (!filter.canFilter(itemStack, !this.singleItem)) continue;
                            if (!this.singleItem && filter instanceof TItemStackFilter) {
                                TItemStackFilter itemFilter = (TItemStackFilter)filter;
                                if (itemFilter.sizeMode) {
                                    min = itemFilter.min;
                                }
                            }
                            if ((response2 = this.emitItemToTransporter(front, request2 = TransitRequest.getFromStack(itemStack), filter.color, min)).isEmpty()) continue;
                            invStack.use(response2.getSendingAmount());
                            back.func_70296_d();
                            this.setActive(true);
                            sentItems = true;
                            break block0;
                        }
                    }
                    if (!sentItems && this.autoEject && !(response = this.emitItemToTransporter(front, request = TransitRequest.buildInventoryMap(back, this.facing.func_176734_d(), this.singleItem ? 1 : 64, new StrictFilterFinder()), this.color, 0)).isEmpty()) {
                        response.getInvStack(back, this.facing).use(response.getSendingAmount());
                        back.func_70296_d();
                        this.setActive(true);
                    }
                }
                this.delayTicks = 10;
            }
            if (this.playersUsing.size() > 0) {
                for (EntityPlayer player : this.playersUsing) {
                    Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(this, this.getGenericPacket(new TileNetworkList())), (EntityPlayerMP)player);
                }
            }
            if ((newRedstoneLevel = this.getRedstoneLevel()) != this.currentRedstoneLevel) {
                this.field_145850_b.func_175666_e(this.field_174879_c, this.func_145838_q());
                this.currentRedstoneLevel = newRedstoneLevel;
            }
        }
    }

    public TransitRequest.TransitResponse emitItemToTransporter(TileEntity front, TransitRequest request, EnumColor filterColor, int min) {
        if (CapabilityUtils.hasCapability((ICapabilityProvider)front, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, this.facing.func_176734_d())) {
            ILogisticalTransporter transporter = CapabilityUtils.getCapability((ICapabilityProvider)front, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, this.facing.func_176734_d());
            if (this.roundRobin) {
                return TransporterUtils.insertRR(this, transporter, request, filterColor, true, min);
            }
            return TransporterUtils.insert(this, transporter, request, filterColor, true, min);
        }
        return InventoryUtils.putStackInInventory(front, request, this.facing, false);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        if (this.color != null) {
            nbtTags.func_74768_a("color", TransporterUtils.colors.indexOf((Object)this.color));
        }
        nbtTags.func_74757_a("autoEject", this.autoEject);
        nbtTags.func_74757_a("roundRobin", this.roundRobin);
        nbtTags.func_74757_a("singleItem", this.singleItem);
        nbtTags.func_74768_a("rrIndex", this.rrIndex);
        NBTTagList filterTags = new NBTTagList();
        for (TransporterFilter filter : this.filters) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            filter.write(tagCompound);
            filterTags.func_74742_a((NBTBase)tagCompound);
        }
        if (filterTags.func_74745_c() != 0) {
            nbtTags.func_74782_a("filters", (NBTBase)filterTags);
        }
        return nbtTags;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        if (nbtTags.func_74764_b("color")) {
            this.color = TransporterUtils.colors.get(nbtTags.func_74762_e("color"));
        }
        this.autoEject = nbtTags.func_74767_n("autoEject");
        this.roundRobin = nbtTags.func_74767_n("roundRobin");
        this.singleItem = nbtTags.func_74767_n("singleItem");
        this.rrIndex = nbtTags.func_74762_e("rrIndex");
        if (nbtTags.func_74764_b("filters")) {
            NBTTagList tagList = nbtTags.func_150295_c("filters", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                this.filters.add(TransporterFilter.readFromNBT(tagList.func_150305_b(i)));
            }
        }
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int type = dataStream.readInt();
            if (type == 0) {
                int clickType = dataStream.readInt();
                if (clickType == 0) {
                    this.color = TransporterUtils.increment(this.color);
                } else if (clickType == 1) {
                    this.color = TransporterUtils.decrement(this.color);
                } else if (clickType == 2) {
                    this.color = null;
                }
            } else if (type == 1) {
                this.autoEject = !this.autoEject;
            } else if (type == 2) {
                this.roundRobin = !this.roundRobin;
                this.rrIndex = 0;
            } else if (type == 3) {
                int filterIndex = dataStream.readInt();
                this.filters.swap(filterIndex, filterIndex - 1);
                for (EntityPlayer player : this.playersUsing) {
                    this.func_174889_b(player);
                }
            } else if (type == 4) {
                int filterIndex = dataStream.readInt();
                this.filters.swap(filterIndex, filterIndex + 1);
                for (EntityPlayer player : this.playersUsing) {
                    this.func_174889_b(player);
                }
            } else if (type == 5) {
                this.singleItem = !this.singleItem;
            }
            return;
        }
        boolean wasActive = this.isActive;
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            int type = dataStream.readInt();
            if (type == 0) {
                this.readState(dataStream);
                this.readFilters(dataStream);
            } else if (type == 1) {
                this.readState(dataStream);
            } else if (type == 2) {
                this.readFilters(dataStream);
            }
            if (wasActive != this.isActive) {
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
    }

    private void readState(ByteBuf dataStream) {
        this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
        int c = dataStream.readInt();
        this.color = c != -1 ? TransporterUtils.colors.get(c) : null;
        this.autoEject = dataStream.readBoolean();
        this.roundRobin = dataStream.readBoolean();
        this.singleItem = dataStream.readBoolean();
    }

    private void readFilters(ByteBuf dataStream) {
        this.filters.clear();
        int amount = dataStream.readInt();
        for (int i = 0; i < amount; ++i) {
            this.filters.add(TransporterFilter.readFromPacket(dataStream));
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(0);
        data.add(this.controlType.ordinal());
        if (this.color != null) {
            data.add(TransporterUtils.colors.indexOf((Object)this.color));
        } else {
            data.add(-1);
        }
        data.add(this.autoEject);
        data.add(this.roundRobin);
        data.add(this.singleItem);
        data.add(this.filters.size());
        for (TransporterFilter filter : this.filters) {
            filter.write(data);
        }
        return data;
    }

    public TileNetworkList getGenericPacket(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(1);
        data.add(this.controlType.ordinal());
        if (this.color != null) {
            data.add(TransporterUtils.colors.indexOf((Object)this.color));
        } else {
            data.add(-1);
        }
        data.add(this.autoEject);
        data.add(this.roundRobin);
        data.add(this.singleItem);
        return data;
    }

    public TileNetworkList getFilterPacket(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(2);
        data.add(this.filters.size());
        for (TransporterFilter filter : this.filters) {
            filter.write(data);
        }
        return data;
    }

    public boolean canSendHome(ItemStack stack) {
        TileEntity back = Coord4D.get(this).offset(this.facing.func_176734_d()).getTileEntity((IBlockAccess)this.field_145850_b);
        return InventoryUtils.canInsert(back, null, stack, this.facing.func_176734_d(), true);
    }

    public boolean hasInventory() {
        TileEntity tile = Coord4D.get(this).offset(this.facing.func_176734_d()).getTileEntity((IBlockAccess)this.field_145850_b);
        return TransporterUtils.isValidAcceptorOnSide(tile, this.facing.func_176734_d());
    }

    public TransitRequest.TransitResponse sendHome(ItemStack stack) {
        TileEntity back = Coord4D.get(this).offset(this.facing.func_176734_d()).getTileEntity((IBlockAccess)this.field_145850_b);
        return InventoryUtils.putStackInInventory(back, TransitRequest.getFromStack(stack), this.facing.func_176734_d(), true);
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        return false;
    }

    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        return false;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        if (side == this.facing || side == this.facing.func_176734_d()) {
            return new int[]{0};
        }
        return InventoryUtils.EMPTY;
    }

    @Override
    public void func_174889_b(@Nonnull EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K) {
            Mekanism.packetHandler.sendUpdatePacket(this);
        }
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
    }

    @Override
    public boolean canPulse() {
        return true;
    }

    @Override
    public boolean renderUpdate() {
        return true;
    }

    @Override
    public boolean lightUpdate() {
        return false;
    }

    @Override
    public boolean sideIsConsumer(EnumFacing side) {
        return false;
    }

    @Override
    public boolean canSetFacing(int facing) {
        return true;
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }

    @Override
    public NBTTagCompound getConfigurationData(NBTTagCompound nbtTags) {
        if (this.color != null) {
            nbtTags.func_74768_a("color", TransporterUtils.colors.indexOf((Object)this.color));
        }
        nbtTags.func_74757_a("autoEject", this.autoEject);
        nbtTags.func_74757_a("roundRobin", this.roundRobin);
        nbtTags.func_74757_a("singleItem", this.singleItem);
        nbtTags.func_74768_a("rrIndex", this.rrIndex);
        NBTTagList filterTags = new NBTTagList();
        for (TransporterFilter filter : this.filters) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            filter.write(tagCompound);
            filterTags.func_74742_a((NBTBase)tagCompound);
        }
        if (filterTags.func_74745_c() != 0) {
            nbtTags.func_74782_a("filters", (NBTBase)filterTags);
        }
        return nbtTags;
    }

    @Override
    public void setConfigurationData(NBTTagCompound nbtTags) {
        if (nbtTags.func_74764_b("color")) {
            this.color = TransporterUtils.colors.get(nbtTags.func_74762_e("color"));
        }
        this.autoEject = nbtTags.func_74767_n("autoEject");
        this.roundRobin = nbtTags.func_74767_n("roundRobin");
        this.singleItem = nbtTags.func_74767_n("singleItem");
        this.rrIndex = nbtTags.func_74762_e("rrIndex");
        if (nbtTags.func_74764_b("filters")) {
            NBTTagList tagList = nbtTags.func_150295_c("filters", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                this.filters.add(TransporterFilter.readFromNBT(tagList.func_150305_b(i)));
            }
        }
    }

    @Override
    public String getDataType() {
        return this.func_145838_q().func_149739_a() + "." + this.fullName + ".name";
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        ItemDataUtils.setBoolean(itemStack, "hasSorterConfig", true);
        if (this.color != null) {
            ItemDataUtils.setInt(itemStack, "color", TransporterUtils.colors.indexOf((Object)this.color));
        }
        ItemDataUtils.setBoolean(itemStack, "autoEject", this.autoEject);
        ItemDataUtils.setBoolean(itemStack, "roundRobin", this.roundRobin);
        ItemDataUtils.setBoolean(itemStack, "singleItem", this.singleItem);
        NBTTagList filterTags = new NBTTagList();
        for (TransporterFilter filter : this.filters) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            filter.write(tagCompound);
            filterTags.func_74742_a((NBTBase)tagCompound);
        }
        if (filterTags.func_74745_c() != 0) {
            ItemDataUtils.setList(itemStack, "filters", filterTags);
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        if (ItemDataUtils.hasData(itemStack, "hasSorterConfig")) {
            if (ItemDataUtils.hasData(itemStack, "color")) {
                this.color = TransporterUtils.colors.get(ItemDataUtils.getInt(itemStack, "color"));
            }
            this.autoEject = ItemDataUtils.getBoolean(itemStack, "autoEject");
            this.roundRobin = ItemDataUtils.getBoolean(itemStack, "roundRobin");
            this.singleItem = ItemDataUtils.getBoolean(itemStack, "singleItem");
            if (ItemDataUtils.hasData(itemStack, "filters")) {
                NBTTagList tagList = ItemDataUtils.getList(itemStack, "filters");
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    this.filters.add(TransporterFilter.readFromNBT(tagList.func_150305_b(i)));
                }
            }
        }
    }

    @Override
    public String[] getMethods() {
        return this.methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        if (arguments.length > 0) {
            if (method == 0) {
                if (!(arguments[0] instanceof String)) {
                    return new Object[]{"Invalid parameters."};
                }
                this.color = EnumColor.getFromDyeName((String)arguments[0]);
                if (this.color == null) {
                    return new Object[]{"Default color set to null"};
                }
                return new Object[]{"Default color set to " + this.color.dyeName};
            }
            if (method == 1) {
                if (!(arguments[0] instanceof Boolean)) {
                    return new Object[]{"Invalid parameters."};
                }
                this.roundRobin = (Boolean)arguments[0];
                return new Object[]{"Round-robin mode set to " + this.roundRobin};
            }
            if (method == 2) {
                if (!(arguments[0] instanceof Boolean)) {
                    return new Object[]{"Invalid parameters."};
                }
                this.autoEject = (Boolean)arguments[0];
                return new Object[]{"Auto-eject mode set to " + this.autoEject};
            }
            if (method == 3) {
                if (!(arguments.length == 6 && arguments[0] instanceof String && arguments[1] instanceof Double && arguments[2] instanceof String && arguments[3] instanceof Boolean && arguments[4] instanceof Double && arguments[5] instanceof Double)) {
                    return new Object[]{"Invalid parameters."};
                }
                TItemStackFilter filter = new TItemStackFilter();
                filter.itemType = new ItemStack(Item.func_111206_d((String)((String)arguments[0])), 1, ((Double)arguments[1]).intValue());
                filter.color = EnumColor.getFromDyeName((String)arguments[2]);
                filter.sizeMode = (Boolean)arguments[3];
                filter.min = ((Double)arguments[4]).intValue();
                filter.max = ((Double)arguments[5]).intValue();
                this.filters.add(filter);
                return new Object[]{"Added filter."};
            }
            if (method == 4) {
                if (arguments.length != 2 || !(arguments[0] instanceof String) || !(arguments[1] instanceof Double)) {
                    return new Object[]{"Invalid parameters."};
                }
                ItemStack stack = new ItemStack(Item.func_111206_d((String)((String)arguments[0])), 1, ((Double)arguments[1]).intValue());
                Iterator<TransporterFilter> iter = this.filters.iterator();
                while (iter.hasNext()) {
                    TransporterFilter filter = iter.next();
                    if (!(filter instanceof TItemStackFilter) || !StackUtils.equalsWildcard(((TItemStackFilter)filter).itemType, stack)) continue;
                    iter.remove();
                    return new Object[]{"Removed filter."};
                }
                return new Object[]{"Couldn't find filter."};
            }
            if (method == 5) {
                if (arguments.length != 2 || !(arguments[0] instanceof String) || !(arguments[1] instanceof String)) {
                    return new Object[]{"Invalid parameters."};
                }
                TOreDictFilter filter = new TOreDictFilter();
                filter.setOreDictName((String)arguments[0]);
                filter.color = EnumColor.getFromDyeName((String)arguments[1]);
                this.filters.add(filter);
                return new Object[]{"Added filter."};
            }
            if (method == 6) {
                if (arguments.length != 1 || !(arguments[0] instanceof String)) {
                    return new Object[]{"Invalid parameters."};
                }
                String ore = (String)arguments[0];
                Iterator<TransporterFilter> iter = this.filters.iterator();
                while (iter.hasNext()) {
                    TransporterFilter filter = iter.next();
                    if (!(filter instanceof TOreDictFilter) || !((TOreDictFilter)filter).getOreDictName().equals(ore)) continue;
                    iter.remove();
                    return new Object[]{"Removed filter."};
                }
                return new Object[]{"Couldn't find filter."};
            }
            if (method == 7) {
                if (!(arguments[0] instanceof Boolean)) {
                    return new Object[]{"Invalid parameters."};
                }
                this.singleItem = (Boolean)arguments[0];
                return new Object[]{"Single-item mode set to " + this.singleItem};
            }
        }
        for (EntityPlayer player : this.playersUsing) {
            Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(this, this.getGenericPacket(new TileNetworkList())), (EntityPlayerMP)player);
        }
        return null;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return false;
        }
        return capability == Capabilities.CONFIG_CARD_CAPABILITY || capability == Capabilities.SPECIAL_CONFIG_DATA_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return null;
        }
        if (capability == Capabilities.CONFIG_CARD_CAPABILITY || capability == Capabilities.SPECIAL_CONFIG_DATA_CAPABILITY) {
            return (T)this;
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return side != null && side != this.facing && side != this.facing.func_176734_d();
        }
        return super.isCapabilityDisabled(capability, side);
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public int getRedstoneLevel() {
        return this.isActive ? 15 : 0;
    }

    private class StrictFilterFinder
    extends Finder {
        private StrictFilterFinder() {
        }

        @Override
        public boolean modifies(ItemStack stack) {
            for (TransporterFilter filter : TileEntityLogisticalSorter.this.filters) {
                if (!filter.canFilter(stack, false) || filter.allowDefault) continue;
                return false;
            }
            return true;
        }
    }
}

