/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.config;

import ic2.core.network.buffers.InputBuffer;
import ic2.core.network.buffers.OutputBuffer;
import ic2.core.platform.config.IC2Config;
import ic2.core.platform.config.components.IConfigCallback;
import ic2.core.platform.config.components.IConfigChecker;
import java.util.Objects;

public class ConfigEntry {
    IC2Config.ConfigType type;
    String category;
    String comment;
    String configKey;
    String key;
    Number defaultNumber;
    String defaultText;
    boolean defaultFlag;
    IConfigChecker checker;
    IConfigCallback callback;
    boolean hiddenConfig;
    boolean worldRestart;
    boolean gameRestart;
    boolean serverSync;

    public ConfigEntry(IC2Config.ConfigType par1, String par2, String par3, String par4, String par5, String par6) {
        this.type = par1;
        this.category = par2;
        this.configKey = par3;
        this.comment = par4;
        this.key = par5;
        this.defaultText = par6;
    }

    public ConfigEntry(IC2Config.ConfigType par1, String par2, String par3, String par4, String par5, boolean par6) {
        this.type = par1;
        this.category = par2;
        this.configKey = par3;
        this.comment = par4;
        this.key = par5;
        this.defaultFlag = par6;
    }

    public ConfigEntry(IC2Config.ConfigType par1, String par2, String par3, String par4, String par5, Number par6) {
        this.type = par1;
        this.category = par2;
        this.configKey = par3;
        this.comment = par4;
        this.key = par5;
        this.defaultNumber = par6;
    }

    public ConfigEntry addLimiter(IConfigChecker par1) {
        if (this.checker == null) {
            this.checker = par1;
        }
        return this;
    }

    public ConfigEntry addCallback(IConfigCallback par1) {
        if (this.callback == null) {
            this.callback = par1;
        }
        return this;
    }

    public ConfigEntry setServerSync() {
        this.serverSync = true;
        return this;
    }

    public ConfigEntry setWorldRestart() {
        this.worldRestart = true;
        return this;
    }

    public ConfigEntry setGameRestart() {
        this.worldRestart = true;
        this.gameRestart = true;
        return this;
    }

    public ConfigEntry setHiddingConfig() {
        this.hiddenConfig = true;
        return this;
    }

    public IConfigChecker getConfigChecker() {
        return this.checker;
    }

    public IConfigCallback getCallback() {
        return this.callback;
    }

    public String getCategory() {
        return this.category;
    }

    public String getComment() {
        return this.comment;
    }

    public String getKey() {
        return this.key;
    }

    public String getConfigKey() {
        return this.configKey;
    }

    public IC2Config.ConfigType getType() {
        return this.type;
    }

    public Number getDefaultNumber() {
        return this.defaultNumber;
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public boolean getDefaultFlag() {
        return this.defaultFlag;
    }

    public boolean isHiddenConfig() {
        return this.hiddenConfig;
    }

    public boolean requireWorldRestart() {
        return this.worldRestart;
    }

    public boolean requireGameRestart() {
        return this.gameRestart;
    }

    public boolean isSynchronized() {
        return this.serverSync;
    }

    public void writeValue(OutputBuffer buffer, IC2Config config) {
        switch (this.type) {
            case Boolean: {
                buffer.writeBoolean(config.getFlag(this.getKey()));
                break;
            }
            case Float: {
                buffer.writeFloat(config.getFloat(this.getKey()));
                break;
            }
            case Integer: {
                buffer.writeInt(config.getInt(this.getKey()));
                break;
            }
            case String: {
                buffer.writeString(config.getText(this.getKey()));
            }
        }
    }

    public int readValue(InputBuffer buffer, IC2Config config) {
        String result;
        if (this.type == IC2Config.ConfigType.Boolean) {
            boolean result2 = buffer.readBoolean();
            if (result2 != config.getFlag(this.getKey())) {
                config.setValue(this.getKey(), result2);
                return this.requireGameRestart() ? 3 : (this.requireWorldRestart() ? 2 : 1);
            }
        } else if (this.type == IC2Config.ConfigType.Float) {
            float result3 = buffer.readFloat();
            if (!Objects.equals(Float.valueOf(result3), Float.valueOf(config.getFloat(this.getKey())))) {
                config.setValue(this.getKey(), result3);
                return this.requireGameRestart() ? 3 : (this.requireWorldRestart() ? 2 : 1);
            }
        } else if (this.type == IC2Config.ConfigType.Integer) {
            int result4 = buffer.readInt();
            if (!Objects.equals(result4, config.getInt(this.getKey()))) {
                config.setValue(this.getKey(), result4);
                return this.requireGameRestart() ? 3 : (this.requireWorldRestart() ? 2 : 1);
            }
        } else if (this.type == IC2Config.ConfigType.String && !Objects.equals(result = buffer.readString(), config.getText(this.getKey()))) {
            config.setValue(this.getKey(), result);
            return this.requireGameRestart() ? 3 : (this.requireWorldRestart() ? 2 : 1);
        }
        return 0;
    }
}

