/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network.packets.server;

import ic2.core.IC2;
import ic2.core.inventory.base.IHasGui;
import ic2.core.network.packets.IC2Packet;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class EntityGuiPacket
extends IC2Packet {
    public int entityID;
    public int dimID;
    public int windowID;

    public EntityGuiPacket() {
    }

    public EntityGuiPacket(Entity entity, World world, int window) {
        this.entityID = entity.func_145782_y();
        this.dimID = world.field_73011_w.getDimension();
        this.windowID = window;
    }

    @Override
    public void read(ByteBuf par1) {
        this.entityID = par1.readInt();
        this.dimID = par1.readInt();
        this.windowID = par1.readInt();
    }

    @Override
    public void write(ByteBuf par1) {
        par1.writeInt(this.entityID);
        par1.writeInt(this.dimID);
        par1.writeInt(this.windowID);
    }

    @Override
    public void handlePacket(EntityPlayer par1) {
        World world = IC2.platform.getWorld(this.dimID);
        if (world == null) {
            throw new RuntimeException("Packet Contains Incorrect data");
        }
        Entity entity = world.func_73045_a(this.entityID);
        if (entity == null || !(entity instanceof IHasGui)) {
            throw new RuntimeException("Packet Contains Incorrect data");
        }
        IC2.platform.launchGuiClient(par1, (IHasGui)entity);
        par1.field_71070_bA.field_75152_c = this.windowID;
    }
}

