/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.classic.audio.PositionSpec;
import ic2.core.IC2;
import ic2.core.block.misc.BlockExplosive;
import ic2.core.item.base.ItemIC2;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Sounds;
import ic2.core.platform.registry.Ic2States;
import ic2.core.platform.textures.obj.ICustomItemCameraTransform;
import ic2.core.util.misc.StackUtil;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDynamiteRemote
extends ItemIC2
implements ICustomItemCameraTransform {
    public ItemDynamiteRemote() {
        this.setUnlocalizedName(Ic2ItemLang.dynamiteRemote);
        this.setNoRepair();
        this.func_77625_d(1);
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0);
    }

    @Override
    public boolean hasCustomTransform(int meta) {
        return true;
    }

    @Override
    public ResourceLocation getCustomTransform(int meta) {
        return new ResourceLocation("minecraft:models/item/handheld");
    }

    @Override
    public int getTextureEntry(int meta) {
        return 20;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77952_i() > 0) {
            tooltip.add(Ic2InfoLang.remoteDynamiteLinks.getLocalizedFormatted(stack.func_77952_i()));
        }
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        int type;
        if (!IC2.platform.isSimulating()) {
            return EnumActionResult.PASS;
        }
        ItemStack stack = player.func_184586_b(hand);
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == Ic2States.dynamite.func_177230_c() && (type = ((Integer)state.func_177229_b((IProperty)BlockExplosive.types)).intValue()) > 1) {
            if (type > 2) {
                boolean remove = this.removeIndex(stack, world, pos);
                if (remove) {
                    world.func_175656_a(pos, state.func_177226_a((IProperty)BlockExplosive.types, (Comparable)Integer.valueOf(2)));
                    player.field_71070_bA.func_75142_b();
                    return EnumActionResult.SUCCESS;
                }
                IC2.platform.messagePlayer(player, Ic2InfoLang.remoteDynamiteLinkFailed);
                return EnumActionResult.FAIL;
            }
            this.addPos(stack, world, pos);
            world.func_175656_a(pos, state.func_177226_a((IProperty)BlockExplosive.types, (Comparable)Integer.valueOf(3)));
            player.field_71070_bA.func_75142_b();
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (stack.func_77952_i() == 0 || !IC2.platform.isSimulating()) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
        if (nbt.func_74767_n("Used")) {
            nbt.func_74757_a("Used", false);
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        IC2.audioManager.playOnce(playerIn, PositionSpec.Hand, Ic2Sounds.dynamiteSend, true, IC2.audioManager.getDefaultVolume());
        this.launchRemotes(stack, worldIn);
        playerIn.field_71070_bA.func_75142_b();
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public void addPos(ItemStack stack, World world, BlockPos pos) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
        NBTTagList list = nbt.func_150295_c("PosList", 11);
        list.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{world.field_73011_w.getDimension(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}));
        nbt.func_74782_a("PosList", (NBTBase)list);
        stack.func_77964_b(list.func_74745_c());
        nbt.func_74757_a("Used", true);
    }

    public boolean removeIndex(ItemStack stack, World world, BlockPos pos) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
        NBTTagList list = nbt.func_150295_c("PosList", 11);
        int id = world.field_73011_w.getDimension();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            int[] array = list.func_150306_c(i);
            if (array[0] != id || array[1] != pos.func_177958_n() || array[2] != pos.func_177956_o() || array[3] != pos.func_177952_p()) continue;
            list.func_74744_a(i);
            nbt.func_74782_a("PosList", (NBTBase)list);
            stack.func_77964_b(list.func_74745_c());
            return true;
        }
        return false;
    }

    public void launchRemotes(ItemStack stack, World world) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
        NBTTagList list = nbt.func_150295_c("PosList", 11);
        int dimID = world.field_73011_w.getDimension();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            BlockPos pos;
            int[] array = list.func_150306_c(i);
            if (array[0] != dimID || !world.func_175667_e(pos = new BlockPos(array[1], array[2], array[3]))) continue;
            IBlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() == Ic2States.dynamite.func_177230_c() && (Integer)state.func_177229_b((IProperty)BlockExplosive.types) == 3) {
                Explosion fakeExplosion = new Explosion(world, null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1.0f, false, false);
                state.func_177230_c().func_180652_a(world, pos, fakeExplosion);
                world.func_175698_g(pos);
            }
            list.func_74744_a(i--);
        }
        nbt.func_74782_a("PosList", (NBTBase)list);
        stack.func_77964_b(list.func_74745_c());
    }
}

