/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.reactor;

import ic2.api.classic.reactor.IReactorPlanner;
import ic2.api.classic.reactor.IReactorPlannerComponent;
import ic2.api.classic.reactor.ISteamReactor;
import ic2.api.reactor.IReactor;
import ic2.core.item.base.ItemIC2;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import java.util.Arrays;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.util.NonNullList;

public class ItemReactorFuelCell
extends ItemIC2
implements IReactorPlannerComponent {
    public ItemReactorFuelCell() {
        this.func_77627_a(false);
        this.func_77656_e(2500);
        this.setUnlocalizedName(Ic2ItemLang.fuelCell);
        this.func_77625_d(1);
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0);
    }

    @Override
    public String getSheet(int meta) {
        return "i0";
    }

    @Override
    public int getTextureEntry(int meta) {
        return 42;
    }

    @Override
    public void processChamber(ItemStack stack, IReactor reactor, int x, int y, boolean heatrun) {
    }

    @Override
    public boolean acceptUraniumPulse(ItemStack stack, IReactor reactor, ItemStack pulsingStack, int youX, int youY, int pulseX, int pulseY, boolean heatrun) {
        IReactorPlanner planner;
        if (reactor instanceof IReactorPlanner && (planner = (IReactorPlanner)reactor).isCollecting()) {
            planner.addReEnrichPulse();
        }
        if (reactor instanceof ISteamReactor) {
            if (heatrun) {
                int myLevel = stack.func_77952_i() - 1 - reactor.getHeat() / 1000;
                if (myLevel <= 0) {
                    reactor.setItemAt(youX, youY, Ic2Items.fuelCell.func_77946_l());
                } else {
                    stack.func_77964_b(myLevel);
                }
            }
            return true;
        }
        int myLevel = stack.func_77952_i() - 1 - reactor.getHeat() / 1000;
        if (myLevel <= 0) {
            reactor.setItemAt(youX, youY, Ic2Items.fuelCell.func_77946_l());
        } else {
            stack.func_77964_b(myLevel);
        }
        return true;
    }

    @Override
    public boolean canStoreHeat(ItemStack stack, IReactor reactor, int x, int y) {
        return false;
    }

    @Override
    public int getMaxHeat(ItemStack stack, IReactor reactor, int x, int y) {
        return 0;
    }

    @Override
    public int getCurrentHeat(ItemStack stack, IReactor reactor, int x, int y) {
        return 0;
    }

    @Override
    public int alterHeat(ItemStack stack, IReactor reactor, int x, int y, int heat) {
        return 0;
    }

    @Override
    public float influenceExplosion(ItemStack stack, IReactor reactor) {
        return 0.0f;
    }

    @Override
    public boolean canBePlacedIn(ItemStack stack, IReactor reactor) {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)new ItemStack((Item)this, 1, 2499));
    }

    @Override
    public ItemStack[] getSubParts() {
        return null;
    }

    @Override
    public boolean hasSubParts() {
        return false;
    }

    @Override
    public ItemStack getReactorPart() {
        return new ItemStack((Item)this, 1, 2499);
    }

    @Override
    public short getID(ItemStack stack) {
        return 52;
    }

    @Override
    public IReactorPlannerComponent.ReactorType getReactorInfo(ItemStack stack) {
        return IReactorPlannerComponent.ReactorType.Reactor;
    }

    @Override
    public IReactorPlannerComponent.ReactorComponentType getType(ItemStack stack) {
        return IReactorPlannerComponent.ReactorComponentType.IsotopeCell;
    }

    @Override
    public List<IReactorPlannerComponent.ReactorComponentStat> getExtraStats(ItemStack stack) {
        return null;
    }

    @Override
    public NBTPrimitive getReactorStat(IReactorPlannerComponent.ReactorComponentStat stat, ItemStack stack) {
        if (stat == IReactorPlannerComponent.ReactorComponentStat.MaxDurability) {
            return stat.createStat(this.func_77612_l());
        }
        return nulltag;
    }

    @Override
    public boolean isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat stat, ItemStack stack) {
        return false;
    }

    @Override
    public NBTPrimitive getReactorStat(IReactor reactor, int x, int y, ItemStack stack, IReactorPlannerComponent.ReactorComponentStat stat) {
        return nulltag;
    }
}

