/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tile;

import ic2.api.classic.energy.tile.IEnergySourceInfo;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.tile.machine.IEUStorage;
import ic2.api.classic.tile.machine.ISpeedMachine;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.core.block.base.tile.TileEntityMachine;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.comparators.ComparatorEUStorage;
import ic2.core.block.base.util.comparator.comparators.ComparatorSpeed;
import ic2.core.block.base.util.info.EmitterInfo;
import ic2.core.block.base.util.info.EnergyInfo;
import ic2.core.block.base.util.info.SourceTierInfo;
import ic2.core.block.base.util.info.SpeedInfo;
import ic2.core.block.base.util.info.misc.IEmitterTile;
import ic2.core.fluid.IC2Fluid;
import ic2.core.fluid.IC2Tank;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntityBasicSteamTurbine
extends TileEntityMachine
implements ITickable,
ISpeedMachine,
IEUStorage,
IEnergySourceInfo,
IEmitterTile,
IFluidHandler {
    @NetworkField(index=3)
    public FluidTank tank = new IC2Tank(1000);
    @NetworkField(index=3)
    public float speed = 0.0f;
    @NetworkField(index=3, compression=NetworkField.BitLevel.Bit16)
    public int energy = 0;
    boolean addedToEnet;

    public TileEntityBasicSteamTurbine() {
        super(0);
        this.addGuiFields("tank", "speed", "energy");
        this.addInfos(new EnergyInfo(this), new SpeedInfo(this), new EmitterInfo(this), new SourceTierInfo(this));
    }

    @Override
    protected void addComparators(ComparatorManager manager) {
        super.addComparators(manager);
        manager.addComparatorMode(new ComparatorSpeed(this));
        manager.addComparatorMode(new ComparatorEUStorage(this));
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.isSimulating() && !this.addedToEnet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (this.isSimulating() && this.addedToEnet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnet = false;
        }
        super.onUnloaded();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.speed = nbt.func_74760_g("Speed");
        this.energy = nbt.func_74762_e("Energy");
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74776_a("Speed", this.speed);
        nbt.func_74768_a("Energy", this.energy);
        this.tank.writeToNBT(this.getTag(nbt, "tank"));
        return nbt;
    }

    @Override
    public int getOutput() {
        return Math.min(40, this.energy);
    }

    @Override
    public float getSpeed() {
        return this.speed * 1000.0f;
    }

    @Override
    public float getMaxSpeed() {
        return 1000.0f;
    }

    @Override
    public int getStoredEU() {
        return this.energy;
    }

    @Override
    public int getMaxEU() {
        return 4000;
    }

    public void func_73660_a() {
        FluidStack drained;
        this.setActive(this.speed > 0.0f);
        if (this.energy >= 4000) {
            this.addChange(-0.005f);
            return;
        }
        float value = 64.0f * this.speed;
        if (value > 64.0f) {
            value = 64.0f;
        }
        if ((drained = this.drain(64.0f)) == null) {
            this.addChange(-0.002f);
        } else {
            this.addChange(this.limit((float)drained.amount - value, -0.005f, 0.005f));
        }
        float producing = 32.0f * this.speed;
        if (drained != null) {
            producing += (float)drained.amount / 8.0f;
        }
        if (producing >= 1.0f) {
            this.addEnergy((int)producing);
        }
        this.updateComparators();
    }

    private float limit(float base, float min, float max) {
        return MathHelper.func_76131_a((float)base, (float)min, (float)max);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this;
        }
        return super.getCapability(capability, facing);
    }

    public void addEnergy(int adding) {
        this.energy += adding;
        if (this.energy > 4000) {
            this.energy = 4000;
        }
        this.getNetwork().updateTileGuiField(this, "energy");
    }

    public void addChange(float effect) {
        this.speed += effect;
        if (this.speed < 0.0f) {
            this.speed = 0.0f;
        }
        if (this.speed > 1.0f) {
            this.speed = 1.0f;
        }
        this.getNetwork().updateTileGuiField(this, "speed");
    }

    public FluidStack drain(float amount) {
        FluidStack drained = this.tank.drainInternal((int)amount, true);
        this.getNetwork().updateTileGuiField(this, "tank");
        return drained;
    }

    @Override
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return true;
    }

    @Override
    public double getOfferedEnergy() {
        return Math.min(40, this.energy);
    }

    @Override
    public void drawEnergy(double amount) {
        this.energy = (int)((double)this.energy - amount);
    }

    @Override
    public int getSourceTier() {
        return 2;
    }

    @Override
    public int getMaxSendingEnergy() {
        return 40;
    }

    @Override
    public boolean canRemoveBlock(EntityPlayer player) {
        return true;
    }

    @Override
    public double getWrenchDropRate() {
        return 0.75;
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tank.getTankProperties();
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource.getFluid() == IC2Fluid.getFluid("steam")) {
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }
}

