/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop.crops;

import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import ic2.core.block.crop.crops.CropCardBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CropColorFlower
extends CropCardBase {
    String name;
    String disc;
    int sprite;
    int color;
    String[] attributes;

    public CropColorFlower(String id, String discovered, String[] attributes, int spriteID, int color) {
        super(new CropProperties(2, 1, 1, 0, 5, 1));
        this.name = id;
        this.disc = discovered;
        this.attributes = attributes;
        this.sprite = spriteID;
        this.color = color;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int state) {
        if (state == 4) {
            return this.getSprite("bc")[this.sprite];
        }
        return this.getSprite("bc")[11 + state];
    }

    @Override
    public String getId() {
        return this.name;
    }

    @Override
    public String getDiscoveredBy() {
        return this.disc;
    }

    @Override
    public int getMaxSize() {
        return 4;
    }

    @Override
    public String[] getAttributes() {
        return this.attributes;
    }

    @Override
    public boolean canGrow(ICropTile cropTile) {
        return cropTile.getCurrentSize() <= 3 && cropTile.getLightLevel() >= 12;
    }

    @Override
    public boolean canBeHarvested(ICropTile cropTile) {
        return cropTile.getCurrentSize() == 4;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        return new ItemStack(Items.field_151100_aR, 1, this.color);
    }

    @Override
    public int getSizeAfterHarvest(ICropTile cropTile) {
        return 3;
    }

    @Override
    public int getGrowthDuration(ICropTile cropTile) {
        if (cropTile.getCurrentSize() == 3) {
            return 600;
        }
        return 400;
    }

    @Override
    public int getOptimalHarvestSize(ICropTile cropTile) {
        return 4;
    }
}

