/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.base.tile;

import ic2.api.classic.audio.PositionSpec;
import ic2.api.classic.item.IMachineUpgradeItem;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.recipe.INullableRecipeInput;
import ic2.api.classic.recipe.machine.IMachineRecipeList;
import ic2.api.classic.recipe.machine.MachineOutput;
import ic2.api.classic.tile.IRecipeMachine;
import ic2.api.classic.tile.IStackOutput;
import ic2.api.classic.tile.machine.IProgressMachine;
import ic2.api.classic.tile.machine.ISpeedMachine;
import ic2.api.energy.EnergyNet;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.api.recipe.IRecipeInput;
import ic2.core.IC2;
import ic2.core.RotationList;
import ic2.core.audio.AudioSource;
import ic2.core.block.base.tile.TileEntityElecMachine;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.comparators.ComparatorProgress;
import ic2.core.block.base.util.info.EnergyUsageInfo;
import ic2.core.block.base.util.info.ProgressInfo;
import ic2.core.block.base.util.info.SpeedInfo;
import ic2.core.block.base.util.info.misc.IEnergyUser;
import ic2.core.block.base.util.output.IStackRegistry;
import ic2.core.block.base.util.output.MultiSlotOutput;
import ic2.core.block.machine.med.container.ContainerAdvMachine;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.ArrayFilter;
import ic2.core.inventory.filters.BasicItemFilter;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.filters.MachineFilter;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.inventory.transport.wrapper.RangedInventoryWrapper;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.registry.Ic2GuiComp;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.math.Box2D;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IOutputMachine;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class TileEntityAdvancedMachine
extends TileEntityElecMachine
implements ITickable,
ISpeedMachine,
IProgressMachine,
IRecipeMachine,
IOutputMachine,
INetworkTileEntityEventListener,
IHasGui,
IEnergyUser {
    private boolean firstPacket = true;
    @NetworkField(index=7)
    public int progress = 0;
    @NetworkField(index=8, compression=NetworkField.BitLevel.Bit16)
    public int speed = 0;
    public static final int maxSpeed = 10000;
    public int defaultEnergyConsume;
    public int defaultOperationLength;
    public int defaultMaxInput;
    public int defaultEnergyStorage;
    public int energyConsume;
    public int operationLength;
    @NetworkField(index=9)
    public float soundLevel = 1.0f;
    public Int2ObjectMap<IMachineRecipeList.RecipeEntry> lastRecipes = new Int2ObjectLinkedOpenHashMap();
    public Int2ObjectMap<IMachineRecipeList.RecipeEntry> activeRecipes = new Int2ObjectLinkedOpenHashMap();
    @NetworkField(index=10)
    public int recipeOperation;
    @NetworkField(index=11)
    public int recipeEnergy;
    @NetworkField(index=12)
    public boolean redstoneInverted;
    @NetworkField(index=13)
    public boolean redstoneSensitive;
    public boolean defaultSensitive;
    @NetworkField(index=14)
    public boolean isProcessing;
    public LinkedList<IStackOutput> results = new LinkedList();
    public AudioSource audioSource;
    public IntSet notCheckRecipe = new IntOpenHashSet();

    public TileEntityAdvancedMachine(int slots, int energyPerTick, int maxProgress) {
        this(slots, energyPerTick, maxProgress, 128);
    }

    public TileEntityAdvancedMachine(int slots, int energyPerTick, int maxProgress, int maxinput) {
        super(slots + 2, maxinput);
        this.setFuelSlot(0);
        this.energyConsume = energyPerTick;
        this.defaultEnergyConsume = energyPerTick;
        this.operationLength = maxProgress;
        this.defaultOperationLength = maxProgress;
        this.defaultMaxInput = this.maxInput;
        this.defaultEnergyStorage = 10000;
        this.defaultSensitive = true;
        this.addNetworkFields("soundLevel", "redstoneInverted", "redstoneSensitive", "isProcessing");
        this.addGuiFields("recipeOperation", "recipeEnergy", "progress", "speed");
        this.addInfos(new EnergyUsageInfo(this), new SpeedInfo(this), new ProgressInfo(this));
    }

    @Override
    protected void addSlots(InventoryHandler handler) {
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Both, 0);
        handler.registerDefaultSlotAccess(AccessRule.Import, 1);
        handler.registerDefaultSlotAccess(AccessRule.Export, this.getOutputSlots());
        handler.registerDefaultSlotsForSide(RotationList.DOWN, 0);
        handler.registerDefaultSlotsForSide(RotationList.DOWN.invert(), 1);
        handler.registerDefaultSlotsForSide(RotationList.UP.invert(), this.getOutputSlots());
        handler.registerInputFilter(new ArrayFilter(CommonFilters.DischargeEU, new BasicItemFilter(Items.field_151137_ax), new BasicItemFilter(Ic2Items.suBattery)), 0);
        handler.registerOutputFilter(CommonFilters.NotDischargeEU, 0);
        handler.registerInputFilter(new MachineFilter(this), 1);
        handler.registerSlotType(SlotType.Discharge, 0);
        handler.registerSlotType(SlotType.Input, 1);
        handler.registerSlotType(SlotType.Output, this.getOutputSlots());
    }

    @Override
    protected void addComparators(ComparatorManager manager) {
        super.addComparators(manager);
        manager.addComparatorMode(new ComparatorProgress(this));
    }

    @Override
    public int getEnergyUsage() {
        return 1 + (this.getActive() ? this.recipeEnergy : 0);
    }

    @Override
    public float getSpeed() {
        return this.speed;
    }

    @Override
    public float getMaxSpeed() {
        return 10000.0f;
    }

    @Override
    public float getProgress() {
        return this.progress;
    }

    @Override
    public float getMaxProgress() {
        return this.recipeOperation;
    }

    public abstract IMachineRecipeList.RecipeEntry getOutputFor(ItemStack var1);

    public abstract int[] getOutputSlots();

    public abstract Slot[] getInventorySlots(InventoryPlayer var1);

    public abstract ResourceLocation getTexture();

    public abstract LocaleComp getSpeedName();

    public int getRecipeSlots() {
        return 1;
    }

    public Box2D getChargeBox() {
        return Ic2GuiComp.machineChargeBox;
    }

    public Box2D getProgressBox() {
        return Ic2GuiComp.machineProgressBox;
    }

    public boolean canWorkWithoutItems() {
        return false;
    }

    public ResourceLocation getStartingSoundFile() {
        return null;
    }

    public ResourceLocation getStoppingSoundFile() {
        return null;
    }

    public ResourceLocation getProcessSoundFile() {
        return null;
    }

    public ResourceLocation getInterruptSoundFile() {
        return null;
    }

    public void operateOnce(int slot, IRecipeInput input, MachineOutput output, List<IStackOutput> list) {
        for (ItemStack stack : output.getRecipeOutput(this.func_145831_w().field_73012_v, this.getTileData())) {
            list.add(new MultiSlotOutput(stack, this.getOutputSlots()));
        }
        this.consumeInput(input, slot, output.getMetadata());
    }

    public void consumeInput(IRecipeInput input, int slot, NBTTagCompound recipeData) {
        if (input instanceof INullableRecipeInput && ((ItemStack)this.inventory.get(slot)).func_190926_b()) {
            return;
        }
        if (((ItemStack)this.inventory.get(slot)).func_77973_b().hasContainerItem((ItemStack)this.inventory.get(slot)) && (recipeData == null || !recipeData.func_74767_n("consume_containers"))) {
            this.inventory.set(slot, (Object)((ItemStack)this.inventory.get(slot)).func_77973_b().getContainerItem((ItemStack)this.inventory.get(slot)));
        } else {
            ((ItemStack)this.inventory.get(slot)).func_190918_g(input.getAmount());
        }
    }

    @Override
    public boolean supportsNotify() {
        return true;
    }

    public void func_73660_a() {
        boolean operate;
        this.handleRedstone();
        this.updateNeighbors();
        boolean noRoom = this.addToInventory();
        IMachineRecipeList.RecipeEntry entry = this.getRecipe();
        boolean canWork = this.canWork() || entry != null && this.energy > 0;
        boolean bl = operate = canWork && !noRoom && entry != null;
        if (canWork || entry != null) {
            this.handleChargeSlot(this.recipeEnergy * this.recipeOperation);
        }
        if ((canWork || entry != null) && this.energy > 0) {
            if (this.speed < 10000) {
                ++this.speed;
                this.getNetwork().updateTileGuiField(this, "speed");
            }
            this.useEnergy(1);
        } else if (this.speed > 0) {
            this.speed -= Math.min(this.speed, 4);
            this.getNetwork().updateTileGuiField(this, "speed");
        }
        if (operate && this.energy >= this.energyConsume) {
            this.setActive(true);
            if (!this.isProcessing) {
                this.getNetwork().initiateTileEntityEvent(this, 0, false);
            }
            this.isProcessing = true;
            this.progress += this.speed / 30;
            this.useEnergy(this.recipeEnergy);
            if (this.progress >= this.recipeOperation) {
                this.operate(1, entry);
                this.progress = 0;
                this.notifyNeighbors();
                this.notCheckRecipe.clear();
            }
            this.getNetwork().updateTileGuiField(this, "progress");
        } else {
            if (this.isProcessing) {
                if (this.progress != 0) {
                    this.getNetwork().initiateTileEntityEvent(this, 1, false);
                } else {
                    this.getNetwork().initiateTileEntityEvent(this, 2, false);
                }
            }
            this.progress = this.updateInactiveProgress(entry, this.progress);
            if (!canWork || this.energy < 0) {
                this.setActive(false);
            }
            this.isProcessing = false;
        }
        if (canWork && this.energy > 0) {
            this.setActive(true);
        }
        for (int i = 0; i < 2; ++i) {
            ItemStack item = (ItemStack)this.inventory.get(i + this.inventory.size() - 2);
            if (item.func_190926_b() || !(item.func_77973_b() instanceof IMachineUpgradeItem)) continue;
            ((IMachineUpgradeItem)item.func_77973_b()).onTick(item, this);
        }
        this.updateComparators();
    }

    public int updateInactiveProgress(IMachineRecipeList.RecipeEntry entry, int currentProgress) {
        if (entry == null && currentProgress != 0) {
            this.getNetwork().updateTileGuiField(this, "progress");
            return 0;
        }
        return currentProgress;
    }

    public void handleModifiers(IMachineRecipeList.RecipeEntry entry) {
        if (entry == null || entry.getOutput().getMetadata() == null) {
            if (this.recipeEnergy != this.energyConsume) {
                this.recipeEnergy = this.energyConsume;
                if (this.recipeEnergy < 1) {
                    this.recipeEnergy = 1;
                }
                this.getNetwork().updateTileGuiField(this, "recipeEnergy");
            }
            if (this.recipeOperation != this.operationLength) {
                this.recipeOperation = this.operationLength;
                if (this.recipeOperation < 1) {
                    this.recipeOperation = 1;
                }
                this.getNetwork().updateTileGuiField(this, "recipeOperation");
            }
            return;
        }
        NBTTagCompound nbt = entry.getOutput().getMetadata();
        double energyMod = nbt.func_74764_b("RecipeEnergyModifier") ? nbt.func_74769_h("RecipeEnergyModifier") : 1.0;
        int newEnergy = TileEntityAdvancedMachine.applyModifier(this.energyConsume, nbt.func_74762_e("RecipeEnergy"), energyMod);
        if (newEnergy != this.recipeEnergy) {
            this.recipeEnergy = newEnergy;
            if (this.recipeEnergy < 1) {
                this.recipeEnergy = 1;
            }
            this.getNetwork().updateTileGuiField(this, "recipeEnergy");
        }
        double progMod = nbt.func_74764_b("RecipeTimeModifier") ? nbt.func_74769_h("RecipeTimeModifier") : 1.0;
        int newProgress = TileEntityAdvancedMachine.applyModifier(this.operationLength, nbt.func_74762_e("RecipeTime"), progMod);
        if (newProgress != this.recipeOperation) {
            this.recipeOperation = newProgress;
            if (this.recipeOperation < 1) {
                this.recipeOperation = 1;
            }
            this.getNetwork().updateTileGuiField(this, "recipeOperation");
        }
    }

    public void operate(int slot, IMachineRecipeList.RecipeEntry entry) {
        if (entry == null) {
            return;
        }
        this.notCheckRecipe.clear();
        IRecipeInput input = entry.getInput();
        MachineOutput output = entry.getOutput().copy();
        for (int i = 0; i < 2; ++i) {
            ItemStack itemStack = (ItemStack)this.inventory.get(i + this.inventory.size() - 2);
            if (itemStack.func_190926_b() || !(itemStack.func_77973_b() instanceof IMachineUpgradeItem)) continue;
            IMachineUpgradeItem item = (IMachineUpgradeItem)itemStack.func_77973_b();
            item.onProcessEndPre(itemStack, this, output);
        }
        ArrayList<IStackOutput> list = new ArrayList<IStackOutput>();
        this.operateOnce(slot, input, output, list);
        for (int i = 0; i < 2; ++i) {
            ItemStack itemStack = (ItemStack)this.inventory.get(i + this.inventory.size() - 2);
            if (itemStack.func_190926_b() || !(itemStack.func_77973_b() instanceof IMachineUpgradeItem)) continue;
            IMachineUpgradeItem item = (IMachineUpgradeItem)itemStack.func_77973_b();
            item.onProcessEndPost(itemStack, this, input, output, list);
        }
        if (list.size() > 0) {
            this.results.addAll(list);
            this.addToInventory();
        }
    }

    @Override
    public void setStackInSlot(int slot, ItemStack stack) {
        super.setStackInSlot(slot, stack);
        if (this.isSimulating()) {
            this.notCheckRecipe.clear();
        }
    }

    public boolean addToInventory() {
        if (this.results.isEmpty()) {
            return false;
        }
        Iterator iter = this.results.iterator();
        while (iter.hasNext()) {
            IStackOutput output = (IStackOutput)iter.next();
            if (!output.addToInventory(this)) continue;
            iter.remove();
        }
        return this.results.size() > 0;
    }

    public IMachineRecipeList.RecipeEntry getRecipe() {
        return this.getRecipe(1);
    }

    public IMachineRecipeList.RecipeEntry getRecipe(int slot) {
        EnumActionResult result;
        if (this.notCheckRecipe.contains(slot)) {
            return (IMachineRecipeList.RecipeEntry)this.activeRecipes.get(slot);
        }
        this.notCheckRecipe.add(slot);
        if (((ItemStack)this.inventory.get(slot)).func_190926_b() && !this.canWorkWithoutItems()) {
            this.lastRecipes.remove(slot);
            this.activeRecipes.remove(slot);
            return null;
        }
        IMachineRecipeList.RecipeEntry lastRecipe = (IMachineRecipeList.RecipeEntry)this.lastRecipes.get(slot);
        if (lastRecipe != null) {
            EnumActionResult result2;
            IRecipeInput recipe = lastRecipe.getInput();
            if (recipe instanceof INullableRecipeInput) {
                if (!recipe.matches((ItemStack)this.inventory.get(slot))) {
                    this.lastRecipes.remove(slot);
                    this.activeRecipes.remove(slot);
                    lastRecipe = null;
                } else {
                    result2 = this.isRecipeStillValid(lastRecipe);
                    if (result2 == EnumActionResult.FAIL) {
                        this.lastRecipes.remove(slot);
                        this.activeRecipes.remove(slot);
                        lastRecipe = null;
                    } else if (result2 == EnumActionResult.PASS) {
                        this.activeRecipes.remove(slot);
                        return null;
                    }
                }
            } else if (((ItemStack)this.inventory.get(slot)).func_190926_b() || !recipe.matches((ItemStack)this.inventory.get(slot))) {
                this.lastRecipes.remove(slot);
                this.activeRecipes.remove(slot);
                lastRecipe = null;
            } else {
                if (recipe.getAmount() > ((ItemStack)this.inventory.get(slot)).func_190916_E()) {
                    this.activeRecipes.remove(slot);
                    return null;
                }
                result2 = this.isRecipeStillValid(lastRecipe);
                if (result2 == EnumActionResult.FAIL) {
                    this.lastRecipes.remove(slot);
                    this.activeRecipes.remove(slot);
                    lastRecipe = null;
                } else if (result2 == EnumActionResult.PASS) {
                    this.activeRecipes.remove(slot);
                    return null;
                }
            }
        }
        if (lastRecipe == null) {
            IMachineRecipeList.RecipeEntry out = this.getOutputFor(((ItemStack)this.inventory.get(slot)).func_77946_l());
            if (out == null) {
                this.activeRecipes.remove(slot);
                return null;
            }
            lastRecipe = out;
            this.lastRecipes.put(slot, (Object)lastRecipe);
            this.activeRecipes.put(slot, (Object)lastRecipe);
            this.handleModifiers(out);
        }
        if ((result = this.canFillRecipeIntoOutputs(lastRecipe.getOutput())) == EnumActionResult.SUCCESS) {
            this.activeRecipes.put(slot, (Object)lastRecipe);
            return lastRecipe;
        }
        if (result == EnumActionResult.PASS) {
            this.activeRecipes.remove(slot);
            return null;
        }
        if (this.hasEmptyOutput(slot)) {
            this.activeRecipes.put(slot, (Object)lastRecipe);
            return lastRecipe;
        }
        for (ItemStack output : lastRecipe.getOutput().getAllOutputs()) {
            for (int outputSlot : this.getOutputSlots()) {
                if (!StackUtil.isStackEqual((ItemStack)this.inventory.get(outputSlot), output, false, true) || ((ItemStack)this.inventory.get(outputSlot)).func_190916_E() + output.func_190916_E() > ((ItemStack)this.inventory.get(outputSlot)).func_77976_d()) continue;
                this.activeRecipes.put(slot, (Object)lastRecipe);
                return lastRecipe;
            }
        }
        this.activeRecipes.remove(slot);
        return null;
    }

    protected EnumActionResult canFillRecipeIntoOutputs(MachineOutput output) {
        return EnumActionResult.FAIL;
    }

    protected EnumActionResult isRecipeStillValid(IMachineRecipeList.RecipeEntry entry) {
        return EnumActionResult.SUCCESS;
    }

    public boolean hasEmptyOutput(int slot) {
        for (int output : this.getOutputSlots()) {
            if (!((ItemStack)this.inventory.get(output)).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public boolean canWork() {
        if (!this.redstoneSensitive) {
            return true;
        }
        return this.isRedstonePowered();
    }

    @Override
    public boolean isRedstonePowered() {
        if (this.redstoneInverted) {
            return !super.isRedstonePowered();
        }
        return super.isRedstonePowered();
    }

    @Override
    public boolean needsInitialRedstoneUpdate() {
        return true;
    }

    @Override
    public void handleRedstone() {
        if (this.redstoneSensitive) {
            super.handleRedstone();
        }
    }

    @Override
    public double getEnergy() {
        return this.energy;
    }

    @Override
    public boolean useEnergy(double amount, boolean simulate) {
        if ((double)this.energy < amount) {
            return false;
        }
        if (!simulate) {
            this.useEnergy((int)amount);
        }
        return true;
    }

    @Override
    public void setRedstoneSensitive(boolean active) {
        if (this.redstoneSensitive != active) {
            this.redstoneSensitive = active;
        }
    }

    @Override
    public World getMachineWorld() {
        return this.func_145831_w();
    }

    @Override
    public BlockPos getMachinePos() {
        return this.func_174877_v();
    }

    @Override
    public boolean isRedstoneSensitive() {
        return this.redstoneSensitive;
    }

    @Override
    public boolean isProcessing() {
        return this.isProcessing;
    }

    @Override
    public boolean isValidInput(ItemStack par1) {
        if (((ItemStack)this.inventory.get(1)).func_190926_b()) {
            return true;
        }
        return StackUtil.isStackEqual((ItemStack)this.inventory.get(1), par1, false, true);
    }

    @Override
    public IHasInventory getOutputInventory() {
        return new RangedInventoryWrapper(this, this.getOutputSlots());
    }

    @Override
    public IHasInventory getInputInventory() {
        return new RangedInventoryWrapper(this, 1).setFilters(new MachineFilter(this));
    }

    @Override
    public Set<IMachineUpgradeItem.UpgradeType> getSupportedTypes() {
        ObjectLinkedOpenHashSet set = new ObjectLinkedOpenHashSet(Arrays.asList(IMachineUpgradeItem.UpgradeType.values()));
        set.remove((Object)IMachineUpgradeItem.UpgradeType.MachineModifierA);
        return set;
    }

    public void setOverclockRates() {
        this.lastRecipes.clear();
        int extraProcessTime = 0;
        double processTimeMultiplier = 1.0;
        int extraEnergyDemand = 0;
        double energyDemandMultiplier = 1.0;
        int extraEnergyStorage = 0;
        double energyStorageMultiplier = 1.0;
        int extraTier = 0;
        float soundModfier = 1.0f;
        boolean redstonePowered = false;
        this.redstoneSensitive = this.defaultSensitive;
        for (int i = 0; i < 2; ++i) {
            ItemStack item = (ItemStack)this.inventory.get(i + this.inventory.size() - 2);
            if (item.func_190926_b() || !(item.func_77973_b() instanceof IMachineUpgradeItem)) continue;
            IMachineUpgradeItem upgrade = (IMachineUpgradeItem)item.func_77973_b();
            upgrade.onInstalling(item, this);
            extraProcessTime += upgrade.getExtraProcessTime(item, this) * item.func_190916_E();
            processTimeMultiplier *= Math.pow(upgrade.getProcessTimeMultiplier(item, this), item.func_190916_E());
            extraEnergyDemand += upgrade.getExtraEnergyDemand(item, this) * item.func_190916_E();
            energyDemandMultiplier *= Math.pow(upgrade.getEnergyDemandMultiplier(item, this), item.func_190916_E());
            extraEnergyStorage += upgrade.getExtraEnergyStorage(item, this) * item.func_190916_E();
            energyStorageMultiplier *= Math.pow(upgrade.getEnergyStorageMultiplier(item, this), item.func_190916_E());
            soundModfier = (float)((double)soundModfier * Math.pow(upgrade.getSoundVolumeMultiplier(item, this), item.func_190916_E()));
            extraTier += upgrade.getExtraTier(item, this) * item.func_190916_E();
            if (!upgrade.useRedstoneInverter(item, this)) continue;
            redstonePowered = true;
        }
        this.redstoneInverted = redstonePowered;
        this.energyConsume = TileEntityAdvancedMachine.applyModifier(this.defaultEnergyConsume, extraEnergyDemand, energyDemandMultiplier);
        this.operationLength = TileEntityAdvancedMachine.applyModifier(this.defaultOperationLength, extraProcessTime, processTimeMultiplier);
        this.setMaxEnergy(TileEntityAdvancedMachine.applyModifier(this.defaultEnergyStorage, extraEnergyStorage, energyStorageMultiplier));
        this.tier = this.baseTier + extraTier;
        if (this.tier > 13) {
            this.tier = 13;
        }
        this.maxInput = (int)EnergyNet.instance.getPowerFromTier(this.tier);
        if (this.maxInput < 0) {
            this.maxInput = Integer.MAX_VALUE;
        }
        if (this.energy > this.maxEnergy) {
            this.energy = this.maxEnergy;
        }
        this.soundLevel = soundModfier;
        if (this.operationLength < 1) {
            this.operationLength = 1;
        }
        if (this.energyConsume < 1) {
            this.energyConsume = 1;
        }
        this.handleModifiers(null);
        this.getNetwork().updateTileEntityField(this, "redstoneInverted");
        this.getNetwork().updateTileEntityField(this, "redstoneSensitive");
        this.getNetwork().updateTileEntityField(this, "soundLevel");
        this.getNetwork().updateTileGuiField(this, "maxInput");
        this.getNetwork().updateTileGuiField(this, "energy");
    }

    public static int applyModifier(int base, int extra, double multiplier) {
        long ret = Math.round((double)(base + extra) * multiplier);
        return ret > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.isSimulating()) {
            this.setOverclockRates();
        }
    }

    @Override
    public void onUnloaded() {
        if (this.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource.remove();
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    @Override
    public void onNetworkEvent(int event) {
        if (this.audioSource != null && this.audioSource.isRemoved()) {
            this.audioSource = null;
        }
        if (this.audioSource == null && this.getProcessSoundFile() != null) {
            this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, this.getProcessSoundFile(), true, false, IC2.audioManager.defaultVolume * this.soundLevel);
        }
        if (event == 0) {
            if (this.audioSource != null) {
                this.audioSource.play();
            }
        } else if (event == 1) {
            if (this.audioSource != null) {
                this.audioSource.stop();
                if (this.getInterruptSoundFile() != null) {
                    IC2.audioManager.playOnce(this, PositionSpec.Center, this.getInterruptSoundFile(), false, IC2.audioManager.defaultVolume * this.soundLevel);
                }
            }
        } else if (event == 2 && this.audioSource != null) {
            this.audioSource.stop();
        }
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("soundLevel")) {
            if (this.audioSource != null) {
                this.audioSource.setVolume(IC2.audioManager.defaultVolume * this.soundLevel);
            }
        } else if (field.equals("isActive") && this.isActiveChanged()) {
            if (!this.firstPacket) {
                if (this.getActive()) {
                    if (this.getStartingSoundFile() != null) {
                        IC2.audioManager.playOnce(this, PositionSpec.Center, this.getStartingSoundFile(), false, IC2.audioManager.defaultVolume * this.soundLevel);
                    }
                } else if (this.getStoppingSoundFile() != null) {
                    IC2.audioManager.playOnce(this, PositionSpec.Center, this.getStoppingSoundFile(), false, IC2.audioManager.defaultVolume * this.soundLevel);
                }
            } else {
                this.firstPacket = false;
            }
        } else if (field.equals("isProcessing") && this.isProcessing) {
            this.onNetworkEvent(0);
        }
        super.onNetworkUpdate(field);
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerAdvMachine(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    public double getWrenchDropRate() {
        return 0.8;
    }

    @Override
    public boolean canRemoveBlock(EntityPlayer player) {
        return true;
    }

    @Override
    public boolean canSetFacing(EntityPlayer player, EnumFacing facing) {
        return this.getFacing() != facing;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.progress = nbt.func_74765_d("progress");
        this.speed = nbt.func_74762_e("Speed");
        this.results.clear();
        NBTTagList list = nbt.func_150295_c("Results", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            IStackOutput output = IStackRegistry.INSTANCE.readNBT(list.func_150305_b(i));
            if (output == null) continue;
            this.results.add(output);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("progress", this.progress);
        nbt.func_74768_a("Speed", this.speed);
        NBTTagList list = new NBTTagList();
        for (IStackOutput item : this.results) {
            list.func_74742_a((NBTBase)IStackRegistry.INSTANCE.saveNBT(item));
        }
        nbt.func_74782_a("Results", (NBTBase)list);
        return nbt;
    }
}

