/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.stevekunglib.utils;

import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class NumberUtils {
    private static final NavigableMap<Long, String> SUFFIXES = new TreeMap<Long, String>();

    public static String format(long value) {
        if (value == Long.MIN_VALUE) {
            return NumberUtils.format(-9223372036854775807L);
        }
        if (value < 0L) {
            return "-" + NumberUtils.format(-value);
        }
        if (value < 1000L) {
            return Long.toString(value);
        }
        Map.Entry<Long, String> entry = SUFFIXES.floorEntry(value);
        Long divideBy = entry.getKey();
        String suffix = entry.getValue();
        long truncated = value / (divideBy / 10L);
        boolean hasDecimal = truncated < 100L && (double)truncated / 10.0 != (double)(truncated / 10L);
        return hasDecimal ? (double)truncated / 10.0 + suffix : truncated / 10L + suffix;
    }

    public static boolean isNumber(char character) {
        return character >= '0' && character <= '9' || character == '-';
    }

    static {
        SUFFIXES.put(1000L, "k");
        SUFFIXES.put(1000000L, "M");
        SUFFIXES.put(1000000000L, "G");
        SUFFIXES.put(1000000000000L, "T");
        SUFFIXES.put(1000000000000000L, "P");
        SUFFIXES.put(1000000000000000000L, "E");
    }
}

