/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.render.font;

import cofh.core.render.FontRendererCore;
import cofh.core.render.font.ICustomCharRenderer;
import cofh.core.util.helpers.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import org.lwjgl.opengl.GL11;

public class RenderIcon
implements ICustomCharRenderer {
    public final char underlyingCharacter;
    private final TextureAtlasSprite icon;

    public RenderIcon(char underlyingCharacter, TextureAtlasSprite icon) {
        this.underlyingCharacter = underlyingCharacter;
        this.icon = icon;
    }

    @Override
    public float renderChar(char letter, boolean italicFlag, float x, float y, FontRendererCore fontRenderer) {
        if (this.icon == null) {
            return 0.0f;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.setBlockTextureSheet();
        float u = this.icon.func_94209_e();
        float v = this.icon.func_94206_g();
        float w = this.icon.func_94212_f() - u;
        float h = this.icon.func_94210_h() - v;
        float rw = w / h * 8.02f;
        float italicOffset = italicFlag ? 1.0f : 0.0f;
        GL11.glBegin((int)5);
        GL11.glTexCoord2f((float)u, (float)v);
        GL11.glVertex3f((float)(x + italicOffset), (float)y, (float)0.0f);
        GL11.glTexCoord2f((float)u, (float)(v + h));
        GL11.glVertex3f((float)(x - italicOffset), (float)(y + 7.99f), (float)0.0f);
        GL11.glTexCoord2f((float)(u + w), (float)v);
        GL11.glVertex3f((float)(x + w / h * 7.99f + italicOffset), (float)y, (float)0.0f);
        GL11.glTexCoord2f((float)(u + w), (float)(v + h));
        GL11.glVertex3f((float)(x + w / h * 7.99f - italicOffset), (float)(y + 7.99f), (float)0.0f);
        GL11.glEnd();
        fontRenderer.resetColor();
        return rw;
    }

    @Override
    public int getCharWidth(char letter, FontRendererCore fontRenderer) {
        if (this.icon == null) {
            return 0;
        }
        float w = this.icon.func_94212_f() - this.icon.func_94209_e();
        float h = this.icon.func_94210_h() - this.icon.func_94206_g();
        return (int)Math.ceil(w / h * 8.0f - 2.0E-4f);
    }

    public static void addRenderer(char c, TextureAtlasSprite icon, FontRendererCore fontRenderer) {
        fontRenderer.renderOverrides.put(c, (Object)new RenderIcon(c, icon));
    }
}

