/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.client;

import mcjty.theoneprobe.api.IEntityStyle;
import mcjty.theoneprobe.rendering.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.fixes.EntityId;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ElementEntityRender {
    private static final EntityId FIXER = new EntityId();

    public static void renderPlayer(String entityName, Integer playerID, IEntityStyle style, int x, int y) {
        Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(playerID.intValue());
        if (entity != null) {
            ElementEntityRender.renderEntity(style, x, y, entity);
        }
    }

    public static void render(String entityName, NBTTagCompound entityNBT, IEntityStyle style, int x, int y) {
        if (entityName != null && !entityName.isEmpty()) {
            Entity entity = null;
            if (entityNBT != null) {
                entity = EntityList.func_75615_a((NBTTagCompound)entityNBT, (World)Minecraft.func_71410_x().field_71441_e);
            } else {
                String fixed = ElementEntityRender.fixEntityId(entityName);
                EntityEntry value = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(fixed));
                if (value != null) {
                    entity = value.newInstance((World)Minecraft.func_71410_x().field_71441_e);
                }
            }
            if (entity != null) {
                ElementEntityRender.renderEntity(style, x, y, entity);
            }
        }
    }

    public static String fixEntityId(String id) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("id", id);
        nbt = FIXER.func_188217_a(nbt);
        return nbt.func_74779_i("id");
    }

    private static void renderEntity(IEntityStyle style, int x, int y, Entity entity) {
        float height = entity.field_70131_O;
        height = (float)((double)(height - 1.0f) * 0.7 + 1.0);
        float s = style.getScale() * ((float)style.getHeight() * 14.0f / 25.0f / height);
        RenderHelper.renderEntity(entity, x, y, s);
    }
}

