/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.lib;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoggingHelper {
    private final Logger logger;

    public LoggingHelper(String name) {
        this(LogManager.getLogger((String)name));
    }

    public LoggingHelper(Logger logger) {
        this.logger = logger;
    }

    public void catching(Throwable t) {
        this.logger.catching(t);
    }

    public void debug(String message, Object ... params) {
        this.logger.debug(message, params);
    }

    public void error(String message, Object ... params) {
        this.logger.error(message, params);
    }

    public void fatal(String message, Object ... params) {
        this.logger.fatal(message, params);
    }

    public void info(String message, Object ... params) {
        this.logger.info(message, params);
    }

    public void log(Level level, String message, Object ... params) {
        this.logger.log(level, message, params);
    }

    public void trace(String message, Object ... params) {
        this.logger.trace(message, params);
    }

    public void warn(String message, Object ... params) {
        this.logger.warn(message, params);
    }

    public void warn(Throwable t, String message, Object ... params) {
        this.logger.warn(message, params);
        this.logger.catching(t);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void noticableWarning(boolean trace, List<String> lines) {
        this.error("********************************************************************************", new Object[0]);
        for (String line : lines) {
            for (String subline : LoggingHelper.wrapString(line, 78, false, new ArrayList<String>())) {
                this.error("* " + subline, new Object[0]);
            }
        }
        if (trace) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            for (int i = 2; i < 8 && i < stackTrace.length; ++i) {
                this.warn("*  at {}{}", stackTrace[i].toString(), i == 7 ? "..." : "");
            }
        }
        this.error("********************************************************************************", new Object[0]);
    }

    public static List<String> wrapString(String string, int lnLength, boolean wrapLongWords, List<String> list) {
        String[] lines;
        for (String line : lines = WordUtils.wrap((String)string, (int)lnLength, null, (boolean)wrapLongWords).split(SystemUtils.LINE_SEPARATOR)) {
            list.add(line);
        }
        return list;
    }
}

