/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.json.serial;

import alexiil.mc.mod.load.json.ConfigManager;
import alexiil.mc.mod.load.json.JsonRender;
import alexiil.mc.mod.load.json.serial.IThrowingDeserialiser;
import alexiil.mc.mod.load.json.subtypes.JsonRenderImage;
import alexiil.mc.mod.load.json.subtypes.JsonRenderPanorama;
import alexiil.mc.mod.load.json.subtypes.JsonRenderSlideshow;
import alexiil.mc.mod.load.json.subtypes.JsonRenderText;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.InvalidExpressionException;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;

public enum ImageDeserialiser implements IThrowingDeserialiser<JsonRender>
{
    INSTANCE;

    private static final JsonPrimitive BUILTIN_TEXT;
    private static final JsonPrimitive BUILTIN_IMAGE;
    private static final JsonPrimitive BUILTIN_SLIDESHOW;
    private static final JsonPrimitive BUILTIN_PANORAMA;

    @Override
    public JsonRender deserialize0(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws InvalidExpressionException {
        if (json.isJsonObject()) {
            JsonObject obj = json.getAsJsonObject();
            if (obj.has("parent")) {
                JsonRender render = ImageDeserialiser.deserialise0(context, obj);
                render.setSource((JsonElement)obj);
                return render;
            }
            throw new JsonSyntaxException("Expected either a builtin parent, or a known existing parent!");
        }
        if (json.isJsonPrimitive()) {
            JsonPrimitive prim = json.getAsJsonPrimitive();
            if (prim.isString()) {
                return ConfigManager.getAsImage(prim.getAsString());
            }
            throw new JsonSyntaxException("Expected an object or a string, found " + prim);
        }
        throw new JsonSyntaxException("Expected an object or a string, found " + json);
    }

    private static JsonRender deserialise0(JsonDeserializationContext context, JsonObject obj) {
        JsonElement pe = obj.get("parent");
        if (BUILTIN_TEXT.equals((Object)pe)) {
            return new JsonRenderText(null, obj, context);
        }
        if (BUILTIN_IMAGE.equals((Object)pe)) {
            return new JsonRenderImage(null, obj, context);
        }
        if (BUILTIN_SLIDESHOW.equals((Object)pe)) {
            return new JsonRenderSlideshow(null, obj, context);
        }
        if (BUILTIN_PANORAMA.equals((Object)pe)) {
            return new JsonRenderPanorama(null, obj, context);
        }
        JsonRender parent = (JsonRender)context.deserialize(pe, JsonRender.class);
        if (parent instanceof JsonRenderText) {
            return new JsonRenderText((JsonRenderText)parent, obj, context);
        }
        if (parent instanceof JsonRenderSlideshow) {
            return new JsonRenderSlideshow((JsonRenderSlideshow)parent, obj, context);
        }
        if (parent instanceof JsonRenderImage) {
            return new JsonRenderImage((JsonRenderImage)parent, obj, context);
        }
        if (parent instanceof JsonRenderPanorama) {
            return new JsonRenderPanorama((JsonRenderPanorama)parent, obj, context);
        }
        throw new IllegalStateException("Unknown JsonRender " + parent.getClass());
    }

    static {
        BUILTIN_TEXT = new JsonPrimitive("builtin/text");
        BUILTIN_IMAGE = new JsonPrimitive("builtin/image");
        BUILTIN_SLIDESHOW = new JsonPrimitive("builtin/slideshow");
        BUILTIN_PANORAMA = new JsonPrimitive("builtin/panorama");
    }
}

