/*
 * Decompiled with CFR 0.152.
 */
package landmaster.plustic.api;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.ref.WeakReference;
import landmaster.plustic.modifiers.armor.JetpackPancakeHippos;
import landmaster.plustic.traits.MusicOfTheSpheres;
import net.minecraft.client.audio.MovingSound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import tonius.simplyjetpacks.sound.SJSoundRegistry;

@Mod.EventBusSubscriber(modid="plustic")
public class Sounds {
    public static final SoundEvent LASER_BEAM = (SoundEvent)new SoundEvent(new ResourceLocation("plustic", "laser_beam")).setRegistryName("laser_beam");

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().register((IForgeRegistryEntry)LASER_BEAM);
    }

    public static void playSoundToAll(Entity entity, SoundEvent sound, float volume, float pitch) {
        entity.func_130014_f_().func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, sound, entity.func_184176_by(), volume, pitch);
    }

    @SideOnly(value=Side.CLIENT)
    public static class PTSoundJetpack
    extends MovingSound {
        private static final Int2ObjectMap<PTSoundJetpack> playingFor = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectOpenHashMap());
        private final EntityLivingBase user;
        private int fadeOut = -1;

        public PTSoundJetpack(EntityLivingBase target) {
            super(SJSoundRegistry.JETPACK.getSoundEvent(), SoundCategory.PLAYERS);
            this.field_147659_g = true;
            this.user = target;
            playingFor.put(target.func_145782_y(), (Object)this);
        }

        public static boolean isPlayingFor(int entityId) {
            return playingFor.containsKey(entityId) && playingFor.get(entityId) != null && !((PTSoundJetpack)((Object)PTSoundJetpack.playingFor.get((int)entityId))).field_147668_j;
        }

        public static void clearPlayingFor() {
            playingFor.clear();
        }

        public void func_73660_a() {
            this.field_147660_d = (float)this.user.field_70165_t;
            this.field_147661_e = (float)this.user.field_70163_u;
            this.field_147658_f = (float)this.user.field_70161_v;
            if (this.fadeOut < 0 && !JetpackPancakeHippos.getJetpackStates().containsKey(this.user.func_145782_y())) {
                this.fadeOut = 0;
                playingFor.remove(this.user.func_145782_y());
            } else if (this.fadeOut >= 5) {
                this.field_147668_j = true;
            } else if (this.fadeOut >= 0) {
                this.field_147662_b = 1.0f - (float)this.fadeOut / 5.0f;
                ++this.fadeOut;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class MOTSSound
    extends MovingSound {
        private WeakReference<EntityPlayer> player;

        public MOTSSound(EntityPlayer player, SoundEvent soundIn, SoundCategory categoryIn) {
            super(soundIn, categoryIn);
            this.player = new WeakReference<EntityPlayer>(player);
        }

        public void func_73660_a() {
            if (this.player.get() == null || !TinkerUtil.hasTrait((NBTTagCompound)TagUtil.getTagSafe((ItemStack)((EntityPlayer)this.player.get()).func_184614_ca()), (String)MusicOfTheSpheres.musicofthespheres.identifier)) {
                this.field_147668_j = true;
            }
            this.field_147660_d = (float)((EntityPlayer)this.player.get()).field_70165_t;
            this.field_147661_e = (float)((EntityPlayer)this.player.get()).field_70163_u;
            this.field_147658_f = (float)((EntityPlayer)this.player.get()).field_70161_v;
        }
    }
}

