/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.worldgen.structures.villages;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeAdaptive;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenStructureData;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureStart;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.util.BiomeUtils;
import zollerngalaxy.worldgen.structures.villages.StructureComponentVillageField2ZG;
import zollerngalaxy.worldgen.structures.villages.StructureComponentVillageFieldZG;
import zollerngalaxy.worldgen.structures.villages.StructureComponentVillageHouseZG;
import zollerngalaxy.worldgen.structures.villages.StructureComponentVillagePathGenZG;
import zollerngalaxy.worldgen.structures.villages.StructureComponentVillageRoadPieceZG;
import zollerngalaxy.worldgen.structures.villages.StructureComponentVillageStartPieceZG;
import zollerngalaxy.worldgen.structures.villages.StructureComponentVillageTorchZG;
import zollerngalaxy.worldgen.structures.villages.StructureComponentVillageWoodHutZG;
import zollerngalaxy.worldgen.structures.villages.StructureVillageStartZG;

public class MapGenVillageZG
extends MapGenStructure {
    public static List<Biome> villageSpawnBiomes = Arrays.asList(BiomeAdaptive.biomeDefault);
    private final int terrainType;
    private static boolean initialized;
    private String worldName;
    private IBlockState VILLAGE_BLOCK;
    private static MapGenVillageZG INSTANCE;
    private MapGenStructureData structureData;

    public static void initiateStructures() throws Throwable {
        if (!initialized) {
            MapGenStructureIO.func_143034_b(StructureVillageStartZG.class, (String)"ZGVillage");
            MapGenStructureIO.func_143031_a(StructureComponentVillageFieldZG.class, (String)"ZGField1");
            MapGenStructureIO.func_143031_a(StructureComponentVillageField2ZG.class, (String)"ZGField2");
            MapGenStructureIO.func_143031_a(StructureComponentVillageHouseZG.class, (String)"ZGHouse");
            MapGenStructureIO.func_143031_a(StructureComponentVillageRoadPieceZG.class, (String)"ZGRoadPiece");
            MapGenStructureIO.func_143031_a(StructureComponentVillagePathGenZG.class, (String)"ZGPath");
            MapGenStructureIO.func_143031_a(StructureComponentVillageTorchZG.class, (String)"ZGTorch");
            MapGenStructureIO.func_143031_a(StructureComponentVillageStartPieceZG.class, (String)"ZGWell");
            MapGenStructureIO.func_143031_a(StructureComponentVillageWoodHutZG.class, (String)"ZGWoodHut");
        }
        initialized = true;
    }

    public MapGenVillageZG(String worldNameIn, IBlockState houseBlockIn) {
        this.terrainType = 0;
        this.worldName = worldNameIn;
        this.VILLAGE_BLOCK = houseBlockIn;
        INSTANCE = this;
    }

    public MapGenVillageZG(String worldNameIn, Block houseBlockIn) {
        this(worldNameIn, houseBlockIn.func_176223_P());
    }

    public MapGenVillageZG(String worldNameIn) {
        this(worldNameIn, ZGBlocks.blockShinestoneCrystalBricks.func_176223_P());
    }

    protected boolean func_75047_a(int i, int j) {
        int numChunks = 32;
        int offsetChunks = 8;
        int oldi = i;
        int oldj = j;
        Biome biome = this.field_75039_c.func_180494_b(new BlockPos(i, 0, j));
        if (BiomeUtils.isOceanBiome(biome)) {
            return false;
        }
        if (i < 0) {
            i -= 31;
        }
        if (j < 0) {
            j -= 31;
        }
        int randX = i / 32;
        int randZ = j / 32;
        Random var7 = this.field_75039_c.func_72843_D(i, j, 10387312);
        randX *= 32;
        randZ *= 32;
        return oldi == (randX += var7.nextInt(24)) && oldj == (randZ += var7.nextInt(24));
    }

    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean p_180706_3_) {
        this.field_75039_c = worldIn;
        return MapGenVillageZG.func_191069_a((World)worldIn, (MapGenStructure)this, (BlockPos)pos, (int)32, (int)8, (int)10387312, (boolean)false, (int)100, (boolean)p_180706_3_);
    }

    protected StructureStart func_75049_b(int par1, int par2) {
        GCLog.debug((String)("Generating " + this.worldName + " Village at x" + par1 * 16 + " z" + par2 * 16));
        return new StructureVillageStartZG(this.field_75039_c, this.field_75038_b, par1, par2, this.terrainType);
    }

    public String func_143025_a() {
        return "ZGVillage";
    }

    public IBlockState getHouseBlock() {
        return this.VILLAGE_BLOCK;
    }

    public static MapGenVillageZG instance() {
        return INSTANCE;
    }

    static {
        try {
            MapGenVillageZG.initiateStructures();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

