/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.worldgen.structures.villages;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeAdaptive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.gen.structure.StructureVillagePieces;

public class MapGenVillageHarran
extends MapGenStructure {
    public static List<Biome> VILLAGE_SPAWN_BIOMES = Arrays.asList(BiomeAdaptive.biomeDefault);
    private int size;
    private int distance = 32;
    private final int minTownSeparation;

    public MapGenVillageHarran() {
        this.minTownSeparation = 8;
    }

    public MapGenVillageHarran(Map<String, String> map) {
        this();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getKey().equals("size")) {
                this.size = MathHelper.func_82714_a((String)entry.getValue(), (int)this.size, (int)0);
                continue;
            }
            if (!entry.getKey().equals("distance")) continue;
            this.distance = MathHelper.func_82714_a((String)entry.getValue(), (int)this.distance, (int)9);
        }
    }

    public String func_143025_a() {
        return "HarranVillage";
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        boolean flag;
        int i = chunkX;
        int j = chunkZ;
        if (chunkX < 0) {
            chunkX -= this.distance - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= this.distance - 1;
        }
        int k = chunkX / this.distance;
        int l = chunkZ / this.distance;
        Random random = this.field_75039_c.func_72843_D(k, l, 10387312);
        k *= this.distance;
        l *= this.distance;
        return i == (k += random.nextInt(this.distance - 8)) && j == (l += random.nextInt(this.distance - 8)) && (flag = this.field_75039_c.func_72959_q().func_76940_a(i * 16 + 8, j * 16 + 8, 0, VILLAGE_SPAWN_BIOMES));
    }

    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        this.field_75039_c = worldIn;
        return MapGenVillageHarran.func_191069_a((World)worldIn, (MapGenStructure)this, (BlockPos)pos, (int)this.distance, (int)8, (int)10387312, (boolean)false, (int)100, (boolean)findUnexplored);
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ, this.size);
    }

    public static class Start
    extends StructureStart {
        private boolean hasMoreThanTwoComponents;

        public Start() {
        }

        public Start(World worldIn, Random rand, int x, int z, int size) {
            super(x, z);
            List list = StructureVillagePieces.func_75084_a((Random)rand, (int)size);
            StructureVillagePieces.Start structurevillagepieces$start = new StructureVillagePieces.Start(worldIn.func_72959_q(), 0, rand, (x << 4) + 2, (z << 4) + 2, list, size);
            this.field_75075_a.add(structurevillagepieces$start);
            structurevillagepieces$start.func_74861_a((StructureComponent)structurevillagepieces$start, this.field_75075_a, rand);
            List list1 = structurevillagepieces$start.field_74930_j;
            List list2 = structurevillagepieces$start.field_74932_i;
            while (!list1.isEmpty() || !list2.isEmpty()) {
                if (list1.isEmpty()) {
                    int i = rand.nextInt(list2.size());
                    StructureComponent structurecomponent = (StructureComponent)list2.remove(i);
                    structurecomponent.func_74861_a((StructureComponent)structurevillagepieces$start, this.field_75075_a, rand);
                    continue;
                }
                int j = rand.nextInt(list1.size());
                StructureComponent structurecomponent2 = (StructureComponent)list1.remove(j);
                structurecomponent2.func_74861_a((StructureComponent)structurevillagepieces$start, this.field_75075_a, rand);
            }
            this.func_75072_c();
            int k = 0;
            for (StructureComponent structurecomponent1 : this.field_75075_a) {
                if (structurecomponent1 instanceof StructureVillagePieces.Road) continue;
                ++k;
            }
            this.hasMoreThanTwoComponents = k > 2;
        }

        public boolean func_75069_d() {
            return this.hasMoreThanTwoComponents;
        }

        public void func_143022_a(NBTTagCompound tagCompound) {
            super.func_143022_a(tagCompound);
            tagCompound.func_74757_a("Valid", this.hasMoreThanTwoComponents);
        }

        public void func_143017_b(NBTTagCompound tagCompound) {
            super.func_143017_b(tagCompound);
            this.hasMoreThanTwoComponents = tagCompound.func_74767_n("Valid");
        }
    }
}

