/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.worldgen.structures.dungeons.eden;

import micdoodle8.mods.galacticraft.core.world.gen.dungeon.DungeonConfiguration;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class DungeonConfigurationEden
extends DungeonConfiguration {
    private IBlockState brickBlock;
    private int yPosition;
    private int hallwayLengthMin;
    private int hallwayLengthMax;
    private int hallwayHeight;
    private int roomHeight;
    private Class<?> bossRoom;
    private Class<?> treasureRoom;
    protected ResourceLocation lootTable;
    protected ResourceLocation dungeonLoot;
    private IBlockState chestState;
    private IBlockState spawnerState;
    private IBlockState fluidState;
    private ResourceLocation mobs;

    public DungeonConfigurationEden() {
    }

    public DungeonConfigurationEden(IBlockState brickBlock, int yPosition, int hallwayLengthMin, int hallwayLengthMax, int hallwayHeight, int roomHeight, Class<?> bossRoom, Class<?> treasureRoom) {
        this.brickBlock = brickBlock;
        this.yPosition = yPosition;
        this.hallwayLengthMin = hallwayLengthMin;
        this.hallwayLengthMax = hallwayLengthMax;
        this.hallwayHeight = hallwayHeight;
        this.roomHeight = roomHeight;
        this.bossRoom = bossRoom;
        this.treasureRoom = treasureRoom;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74778_a("brickBlock", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.brickBlock.func_177230_c())).toString());
        tagCompound.func_74768_a("brickBlockMeta", this.brickBlock.func_177230_c().func_176201_c(this.brickBlock));
        tagCompound.func_74768_a("yPosition", this.yPosition);
        tagCompound.func_74768_a("hallwayLengthMin", this.hallwayLengthMin);
        tagCompound.func_74768_a("hallwayLengthMax", this.hallwayLengthMax);
        tagCompound.func_74768_a("hallwayHeight", this.hallwayHeight);
        tagCompound.func_74768_a("roomHeight", this.roomHeight);
        tagCompound.func_74778_a("bossRoom", this.bossRoom.getName());
        tagCompound.func_74778_a("treasureRoom", this.treasureRoom.getName());
        return tagCompound;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        try {
            this.brickBlock = Block.func_149684_b((String)tagCompound.func_74779_i("brickBlock")).func_176203_a(tagCompound.func_74762_e("brickBlockMeta"));
            this.yPosition = tagCompound.func_74762_e("yPosition");
            this.hallwayLengthMin = tagCompound.func_74762_e("hallwayLengthMin");
            this.hallwayLengthMax = tagCompound.func_74762_e("hallwayLengthMax");
            this.hallwayHeight = tagCompound.func_74762_e("hallwayHeight");
            this.roomHeight = tagCompound.func_74762_e("roomHeight");
            this.bossRoom = Class.forName(tagCompound.func_74779_i("bossRoom"));
            this.treasureRoom = Class.forName(tagCompound.func_74779_i("treasureRoom"));
        }
        catch (Exception e) {
            System.err.println("Failed to read dungeon configuration from NBT");
            e.printStackTrace();
        }
    }

    public IBlockState getBrickBlock() {
        return this.brickBlock;
    }

    public int getYPosition() {
        return this.yPosition;
    }

    public int getHallwayLengthMin() {
        return this.hallwayLengthMin;
    }

    public int getHallwayLengthMax() {
        return this.hallwayLengthMax;
    }

    public int getHallwayHeight() {
        return this.hallwayHeight;
    }

    public int getRoomHeight() {
        return this.roomHeight;
    }

    public Class<?> getBossRoom() {
        return this.bossRoom;
    }

    public Class<?> getTreasureRoom() {
        return this.treasureRoom;
    }

    public DungeonConfigurationEden getConfiguration() {
        return this;
    }
}

