/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.util;

import java.lang.reflect.InvocationTargetException;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderMetztli;
import zollerngalaxy.events.ZGSoundEvents;
import zollerngalaxy.lib.helpers.ZGHelper;
import zollerngalaxy.mobs.entities.base.EntityMutantZombie;
import zollerngalaxy.mobs.entities.villagers.EntityHarranVillager;
import zollerngalaxy.mobs.entities.zombiemutations.EntityGhoul;
import zollerngalaxy.mobs.entities.zombiemutations.EntityOverlord;
import zollerngalaxy.mobs.entities.zombiemutations.EntitySeeker;
import zollerngalaxy.mobs.entities.zombiemutations.EntityVolatile;

public abstract class ZombieUtils {
    public static final int MUTATE_VOLATILE_CHANCE = 50;
    public static final int MUTATE_SEEKER_CHANCE = 32;
    public static final int MUTATE_OVERLORD_CHANCE = 26;
    public static final int MUTATE_GHOUL_CHANCE = 15;
    public static final int MUTATE_LIGHTWALKER_CHANCE = 2;
    public static final int HULK_CHANCE = 5;

    public static void convertToZombie(EntityPlayer player, World world, Class<? extends EntityMob> entityMutant, String entityName) {
        String playerName = player.func_70005_c_();
        double x = player.field_70165_t;
        double y = player.field_70163_u;
        double z = player.field_70161_v;
        Random rand = new Random();
        EntityZombie zombie = new EntityZombie(world);
        if (entityName != "Zombie") {
            try {
                zombie = entityMutant.getDeclaredConstructor(World.class).newInstance(world);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                ZGHelper.LogErr("There was an error when trying to mutate a Zombie!");
                e.printStackTrace();
            }
        }
        zombie.func_70012_b(x, y, z, player.field_70177_z, player.field_70125_A);
        zombie.func_96094_a(entityName + " " + playerName);
        world.func_72838_d((Entity)zombie);
        ZombieUtils.playMutateSound(zombie.field_70165_t, zombie.field_70163_u, zombie.field_70161_v, world, rand);
    }

    public static void playMutateSound(double x, double y, double z, World world, Random rand) {
        float volume = 4.0f + rand.nextFloat();
        float pitch = rand.nextFloat() * 0.7f + 0.3f;
        boolean distanceDelay = false;
        double extendBy = 1.5;
        world.func_184134_a(x += extendBy, y += extendBy, z += extendBy, ZGSoundEvents.ENTITY_VOLATILE_MUTATE, SoundCategory.AMBIENT, volume, pitch, distanceDelay);
    }

    public static boolean isValidLightLevel(World world, EntityZombie zombieIn, Random rand) {
        BlockPos blockpos = new BlockPos(zombieIn.field_70165_t, zombieIn.func_174813_aQ().field_72338_b, zombieIn.field_70161_v);
        if (world.func_175642_b(EnumSkyBlock.SKY, blockpos) > rand.nextInt(32)) {
            return false;
        }
        int i = world.func_175671_l(blockpos);
        if (world.func_72911_I()) {
            int j = world.func_175657_ab();
            world.func_175692_b(10);
            i = world.func_175671_l(blockpos);
            world.func_175692_b(j);
        }
        return i <= rand.nextInt(8);
    }

    public static void HandleMutations(EntityLivingBase entity, Random rand) {
        if (entity instanceof EntityZombie && !(entity instanceof EntityMutantZombie)) {
            EntityZombie zombie = (EntityZombie)entity;
            World world = entity.field_70170_p;
            if (!world.field_72995_K && world.field_73011_w instanceof WorldProviderMetztli && rand.nextInt(400) == 0) {
                int mutantChance = rand.nextInt(100);
                if (mutantChance <= 15) {
                    EntityGhoul gzombie = new EntityGhoul(world);
                    gzombie.func_82149_j((Entity)zombie);
                    if (zombie.func_145818_k_()) {
                        String zombieName = zombie.func_95999_t();
                        String gZombieName = zombieName.replace("Zombie", "Ghoul");
                        gzombie.func_96094_a(gZombieName);
                    }
                    world.func_72838_d((Entity)gzombie);
                    ZombieUtils.playMutateSound(gzombie.field_70165_t, gzombie.field_70163_u, gzombie.field_70161_v, world, rand);
                } else if (mutantChance <= 26) {
                    zombie.func_70106_y();
                    EntityOverlord ozombie = new EntityOverlord(world);
                    ozombie.func_82149_j((Entity)zombie);
                    if (zombie.func_145818_k_()) {
                        String zombieName = zombie.func_95999_t();
                        String oZombieName = zombieName.replace("Zombie", "Overlord");
                        ozombie.func_96094_a(oZombieName);
                    }
                    world.func_72838_d((Entity)ozombie);
                    ZombieUtils.playMutateSound(ozombie.field_70165_t, ozombie.field_70163_u, ozombie.field_70161_v, world, rand);
                } else if (mutantChance <= 32) {
                    zombie.func_70106_y();
                    EntitySeeker szombie = new EntitySeeker(world);
                    szombie.func_82149_j((Entity)zombie);
                    if (zombie.func_145818_k_()) {
                        String zombieName = zombie.func_95999_t();
                        String sZombieName = zombieName.replace("Zombie", "Seeker");
                        szombie.func_96094_a(sZombieName);
                    }
                    world.func_72838_d((Entity)szombie);
                    ZombieUtils.playMutateSound(szombie.field_70165_t, szombie.field_70163_u, szombie.field_70161_v, world, rand);
                } else if (mutantChance <= 50) {
                    zombie.func_70106_y();
                    EntityVolatile vzombie = new EntityVolatile(world);
                    vzombie.func_82149_j((Entity)zombie);
                    if (zombie.func_145818_k_()) {
                        String zombieName = zombie.func_95999_t();
                        String vZombieName = zombieName.replace("Zombie", "Volatile");
                        vzombie.func_96094_a(vZombieName);
                    }
                    world.func_72838_d((Entity)vzombie);
                    ZombieUtils.playMutateSound(vzombie.field_70165_t, vzombie.field_70163_u, vzombie.field_70161_v, world, rand);
                }
            }
        }
    }

    public static void doMutation(Entity entity, Random rand) {
        if (entity instanceof EntityHarranVillager && ConfigManagerZG.enableAlienVillagerMutation) {
            WorldProvider provider;
            EntityHarranVillager villager = (EntityHarranVillager)entity;
            World world = villager.func_130014_f_();
            if (!world.field_72995_K && (provider = world.field_73011_w) instanceof WorldProviderMetztli) {
                EntityEvolvedZombie zombie = new EntityEvolvedZombie(world);
                if (!provider.isDaytime() && rand.nextInt(500) == 0) {
                    villager.func_70106_y();
                    zombie.func_82149_j((Entity)villager);
                    zombie.func_96094_a("Harran Villager Mutant");
                    world.func_72838_d((Entity)zombie);
                    ZombieUtils.playMutateSound(zombie.field_70165_t, zombie.field_70163_u, zombie.field_70161_v, world, rand);
                    ZombieUtils.playMutateSound(villager.field_70165_t, villager.field_70163_u, villager.field_70161_v, world, rand);
                }
            }
        }
    }
}

