/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.recipes;

import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.blocks.fluids.ZGFluids;
import zollerngalaxy.items.ZGItems;
import zollerngalaxy.lib.helpers.ZGHelper;
import zollerngalaxy.lib.helpers.ZGRecipeHelper;

public class CraftingRecipes {
    private static int totalCraftRecipes = 0;

    public static void init() {
        CraftingRecipes.addRecipes();
        ZGHelper.Log("Loaded a total of " + totalCraftRecipes + " new crafting recipes.");
    }

    private static void addRecipes() {
        CraftingRecipes.addBriteStone(ZGItems.dustBrightstone, ZGBlocks.edenBrightStone);
        CraftingRecipes.addBriteStone(ZGItems.perdGlowdust, ZGBlocks.perdGlowstone);
        CraftingRecipes.addBriteStone(ZGItems.dustShinestone, ZGBlocks.blockShinestone);
        CraftingRecipes.addBriteStone(ZGBlocks.blockShinestoneCrystal, ZGBlocks.blockShinestonePolished);
        CraftingRecipes.addBricks(Items.field_151064_bs, ZGBlocks.magmaSlimeBlock);
        CraftingRecipes.addRockBricks(ZGBlocks.zolStone, ZGBlocks.zolRockBricks);
        CraftingRecipes.addRockBricks(ZGBlocks.kriffStone, ZGBlocks.kriffRockBricks);
        CraftingRecipes.addRockBricks(ZGBlocks.purgStone, ZGBlocks.purgRockBricks);
        CraftingRecipes.addRockBricks(ZGBlocks.edenStone, ZGBlocks.edenRockBricks);
        CraftingRecipes.addRockBricks(ZGBlocks.edenBloodSand, ZGBlocks.edenBloodStone);
        CraftingRecipes.addRockBricks(ZGBlocks.edenSacredStone, ZGBlocks.edenDungeonBricks);
        CraftingRecipes.addRockBricks(ZGBlocks.xathStone, ZGBlocks.xathRockBricks);
        CraftingRecipes.addRockBricks(ZGBlocks.oasisStone, ZGBlocks.oasisRockBricks);
        CraftingRecipes.addRockBricks(ZGBlocks.atheonStone, ZGBlocks.atheonRockBricks);
        CraftingRecipes.addRockBricks(ZGBlocks.blockShinestonePolished, ZGBlocks.blockShinestoneCrystalBricks);
        CraftingRecipes.addRockBricks(ZGBlocks.blockChocolate, ZGBlocks.blockChocolateBricks);
        CraftingRecipes.addRockBricks(ZGBlocks.xantheonChrome, ZGBlocks.xantheonConstructBlock);
        CraftingRecipes.addRockBricks(ZGBlocks.perdRock, ZGBlocks.perdRockBricks);
        CraftingRecipes.addRockBricks(ZGBlocks.perdCaveStone, ZGBlocks.perdCaveStoneBricks);
        CraftingRecipes.addRockBricks(ZGBlocks.caligroStone, ZGBlocks.caligroStoneBricks);
        CraftingRecipes.addRockBricks(ZGBlocks.corruptStone, ZGBlocks.corruptStoneBricks);
        CraftingRecipes.addRockBricks(ZGBlocks.tociStone, ZGBlocks.tociStoneBricks);
        CraftingRecipes.addRockBricks(ZGBlocks.mavethStone, ZGBlocks.mavethStoneBricks);
        CraftingRecipes.addIngotMetal(ZGItems.ingotVirinium, ZGBlocks.blockViri);
        CraftingRecipes.addIngotMetal(ZGItems.ingotCobalt, ZGBlocks.blockCobalt);
        CraftingRecipes.addIngotMetal(ZGItems.ingotEvenium, ZGBlocks.blockEve);
        CraftingRecipes.addIngotMetal(ZGItems.prometheanCrystal, ZGBlocks.blockPromethean);
        CraftingRecipes.addIngotMetal(ZGItems.superChargedCoal, ZGBlocks.blockSuperChargedCoal);
        CraftingRecipes.addIngotMetal(ZGItems.ingotShinestone, ZGBlocks.blockShinestoneCrystal);
        CraftingRecipes.addIngotMetal(ZGItems.ingotShinium, ZGBlocks.blockShinium);
        CraftingRecipes.addIngotMetal(ZGItems.ingotChargium, ZGBlocks.blockChargium);
        CraftingRecipes.addIngotMetal(ZGItems.ingotFueltonium, ZGBlocks.blockFueltonium);
        CraftingRecipes.addIngotMetal(ZGItems.ingotAmaranth, ZGBlocks.blockAmaranth);
        CraftingRecipes.addIngotMetal(ZGItems.azurite, ZGBlocks.blockAzurite);
        CraftingRecipes.addIngotMetal(ZGItems.ingotZollernium, ZGBlocks.blockZollernium);
        CraftingRecipes.addIngotMetal(ZGItems.ingotZinc, ZGBlocks.blockZinc);
        CraftingRecipes.addIngotMetal(ZGItems.perdDiamond, ZGBlocks.blockPerdDiamond);
        CraftingRecipes.addIngotMetal(ZGItems.ingotEtrium, ZGBlocks.blockPerdEtrium);
        CraftingRecipes.addIngotMetal(ZGItems.ingotZucrite, ZGBlocks.blockZucrite);
        CraftingRecipes.addIngotMetal(ZGItems.ingotRhodium, ZGBlocks.blockRhodium);
        CraftingRecipes.addIngotMetal(ZGItems.ingotPlutonium, ZGBlocks.blockPlutonium);
        CraftingRecipes.addIngotMetal(ZGItems.plutoniumCrystal, ZGItems.ingotPlutonium, 9);
        CraftingRecipes.addIngotMetal(ZGItems.amber, ZGBlocks.blockAmber);
        CraftingRecipes.addIngotMetal(ZGItems.topaz, ZGBlocks.blockTopaz);
        CraftingRecipes.addIngotMetal(ZGItems.opal, ZGBlocks.blockOpal);
        CraftingRecipes.addIngotMetal(ZGItems.aquamarine, ZGBlocks.blockAquamarine);
        CraftingRecipes.addIngotMetal(ZGItems.garnet, ZGBlocks.blockGarnet);
        CraftingRecipes.addIngotMetal(ZGItems.ruby, ZGBlocks.blockRuby);
        CraftingRecipes.addIngotMetal(ZGItems.sapphire, ZGBlocks.blockSapphire);
        CraftingRecipes.addIngotMetal(ZGItems.amberStatic, ZGBlocks.blockAmberStatic);
        CraftingRecipes.addIngotMetal(ZGItems.aquamarineIcy, ZGBlocks.blockAquamarineIcy);
        CraftingRecipes.addIngotMetal(ZGItems.garnetFire, ZGBlocks.blockGarnetFire);
        CraftingRecipes.addIngotMetal(ZGItems.witherite, ZGBlocks.blockWitherite);
        CraftingRecipes.addIngotMetal(ZGItems.radium, ZGBlocks.blockRadium);
        CraftingRecipes.addIngotMetal(ZGItems.netheridium, ZGBlocks.blockNetheridium);
        CraftingRecipes.addIngotMetal(ZGItems.shadowBone, ZGBlocks.blockShadowBone);
        CraftingRecipes.addIngotMetal(Items.field_151065_br, ZGBlocks.blazeRock);
        CraftingRecipes.addIngotMetal((Block)Blocks.field_150337_Q, ZGBlocks.blockRedshroom);
        CraftingRecipes.addIngotMetal(Items.field_151102_aT, ZGBlocks.blockSugarCube);
        CraftingRecipes.addIngotMetal(ZGItems.ingotObsidian, Blocks.field_150343_Z);
        CraftingRecipes.addIngotMetal(ZGItems.zanium, ZGBlocks.blockZanium);
        CraftingRecipes.addIngotMetal(ZGItems.ingotRadite, ZGBlocks.blockRadite);
        CraftingRecipes.addIngotMetal(ZGItems.ingotZogite, ZGBlocks.blockZogite);
        CraftingRecipes.addIngotMetal(ZGItems.ingotZogradite, ZGBlocks.blockZogradite);
        CraftingRecipes.addIngotMetal(ZGItems.ingotVibranium, ZGBlocks.blockVibranium);
        CraftingRecipes.addIngotMetal(ZGItems.compressedCobalt, ZGBlocks.blockCompressedCobalt);
        CraftingRecipes.addIngotMetal(ZGItems.compressedEvenium, ZGBlocks.blockCompressedEve);
        CraftingRecipes.addIngotMetal(ZGItems.compressedHeartium, ZGBlocks.blockCompressedHeartium);
        CraftingRecipes.addIngotMetal(ZGItems.compressedPromethean, ZGBlocks.blockCompressedPromethean);
        CraftingRecipes.addIngotMetal(ZGItems.compressedSuperChargedCoal, ZGBlocks.blockCompressedSuperChargedCoal);
        CraftingRecipes.addIngotMetal(ZGItems.compressedVirinium, ZGBlocks.blockCompressedViri);
        CraftingRecipes.addIngotMetal(ZGItems.compressedZucrite, ZGBlocks.blockCompressedZucrite);
        CraftingRecipes.addIngotMetal(ZGItems.compressedRhodium, ZGBlocks.blockCompressedRhodium);
        CraftingRecipes.addIngotMetal(ZGItems.chocolateBar, ZGBlocks.blockChocolate);
        CraftingRecipes.addIngotMetal(Items.field_151106_aX, ZGBlocks.blockCookie);
        CraftingRecipes.addIngotMetal(ZGItems.brownie, ZGBlocks.blockBrownie);
        CraftingRecipes.addIngotMetal(ZGItems.iceCreamSandwich, ZGBlocks.blockIceCreamSandwich);
        CraftingRecipes.addPlanks(ZGBlocks.edenWoodLog, ZGBlocks.edenWoodPlanks);
        CraftingRecipes.addPlanks(ZGBlocks.perdWoodLogs, ZGBlocks.perdWoodPlanks);
        CraftingRecipes.addPlanks(ZGBlocks.edenParadiseWoodLog, ZGBlocks.edenParadiseWoodPlanks);
        CraftingRecipes.addPlanks(ZGBlocks.edenGoldenWoodLog, ZGBlocks.edenGoldenWoodPlanks);
        CraftingRecipes.addPlanks(ZGBlocks.edenLovetreeLog, ZGBlocks.edenLovetreePlanks);
        CraftingRecipes.addPlanks(ZGBlocks.exoWoodLogs, ZGBlocks.exoWoodPlanks);
        CraftingRecipes.addPlanks(ZGBlocks.cherryWoodLog, ZGBlocks.cherryWoodPlanks);
        CraftingRecipes.addPlanks(ZGBlocks.bananaLog, ZGBlocks.bananaPlanks);
        CraftingRecipes.addPlanks(ZGBlocks.guavaLog, ZGBlocks.guavaPlanks);
        CraftingRecipes.addPlanks(ZGBlocks.peachLog, ZGBlocks.peachPlanks);
        CraftingRecipes.addPlanks(ZGBlocks.grapefruitLog, ZGBlocks.grapefruitPlanks);
        CraftingRecipes.addPlanks(ZGBlocks.orangeLog, ZGBlocks.orangePlanks);
        CraftingRecipes.addPlanks(ZGBlocks.lemonLog, ZGBlocks.lemonPlanks);
        CraftingRecipes.addPlanks(ZGBlocks.limeLog, ZGBlocks.limePlanks);
        CraftingRecipes.addPlanks(ZGBlocks.limonLog, ZGBlocks.limonPlanks);
        CraftingRecipes.addArmorSet(ZGItems.helmetWood, Blocks.field_150344_f, "helmet");
        CraftingRecipes.addArmorSet(ZGItems.helmetStone, Blocks.field_150348_b, "helmet");
        CraftingRecipes.addArmorSet(ZGItems.helmetAmaranth, ZGItems.ingotAmaranth, "helmet");
        CraftingRecipes.addArmorSet(ZGItems.helmetZollernium, ZGItems.ingotZollernium, "helmet");
        CraftingRecipes.addArmorSet(ZGItems.helmetAzurite, ZGItems.azurite, "helmet");
        CraftingRecipes.addArmorSet(ZGItems.helmetRadium, ZGItems.radium, "helmet");
        CraftingRecipes.addArmorSet(ZGItems.helmetRuby, ZGItems.ruby, "helmet");
        CraftingRecipes.addArmorSet(ZGItems.helmetSapphire, ZGItems.sapphire, "helmet");
        CraftingRecipes.addArmorSet(ZGItems.helmetZanium, ZGItems.zanium, "helmet");
        CraftingRecipes.addArmorSet(ZGItems.helmetRadite, ZGItems.ingotRadite, "helmet");
        CraftingRecipes.addArmorSet(ZGItems.helmetZogite, ZGItems.ingotZogite, "helmet");
        CraftingRecipes.addArmorSet(ZGItems.chestWood, Blocks.field_150344_f, "chest");
        CraftingRecipes.addArmorSet(ZGItems.chestStone, Blocks.field_150348_b, "chest");
        CraftingRecipes.addArmorSet(ZGItems.chestAmaranth, ZGItems.ingotAmaranth, "chest");
        CraftingRecipes.addArmorSet(ZGItems.chestZollernium, ZGItems.ingotZollernium, "chest");
        CraftingRecipes.addArmorSet(ZGItems.chestAzurite, ZGItems.azurite, "chest");
        CraftingRecipes.addArmorSet(ZGItems.chestRadium, ZGItems.radium, "chest");
        CraftingRecipes.addArmorSet(ZGItems.chestRuby, ZGItems.ruby, "chest");
        CraftingRecipes.addArmorSet(ZGItems.chestSapphire, ZGItems.sapphire, "chest");
        CraftingRecipes.addArmorSet(ZGItems.chestZanium, ZGItems.zanium, "chest");
        CraftingRecipes.addArmorSet(ZGItems.chestRadite, ZGItems.ingotRadite, "chest");
        CraftingRecipes.addArmorSet(ZGItems.chestZogite, ZGItems.ingotZogite, "chest");
        CraftingRecipes.addArmorSet(ZGItems.legsWood, Blocks.field_150344_f, "legs");
        CraftingRecipes.addArmorSet(ZGItems.legsStone, Blocks.field_150348_b, "legs");
        CraftingRecipes.addArmorSet(ZGItems.legsAmaranth, ZGItems.ingotAmaranth, "legs");
        CraftingRecipes.addArmorSet(ZGItems.legsZollernium, ZGItems.ingotZollernium, "legs");
        CraftingRecipes.addArmorSet(ZGItems.legsAzurite, ZGItems.azurite, "legs");
        CraftingRecipes.addArmorSet(ZGItems.legsRadium, ZGItems.radium, "legs");
        CraftingRecipes.addArmorSet(ZGItems.legsRuby, ZGItems.ruby, "legs");
        CraftingRecipes.addArmorSet(ZGItems.legsSapphire, ZGItems.sapphire, "legs");
        CraftingRecipes.addArmorSet(ZGItems.legsZanium, ZGItems.zanium, "legs");
        CraftingRecipes.addArmorSet(ZGItems.legsRadite, ZGItems.ingotRadite, "legs");
        CraftingRecipes.addArmorSet(ZGItems.legsZogite, ZGItems.ingotZogite, "legs");
        CraftingRecipes.addArmorSet(ZGItems.bootsWood, Blocks.field_150344_f, "boots");
        CraftingRecipes.addArmorSet(ZGItems.bootsStone, Blocks.field_150348_b, "boots");
        CraftingRecipes.addArmorSet(ZGItems.bootsAmaranth, ZGItems.ingotAmaranth, "boots");
        CraftingRecipes.addArmorSet(ZGItems.bootsZollernium, ZGItems.ingotZollernium, "boots");
        CraftingRecipes.addArmorSet(ZGItems.bootsAzurite, ZGItems.azurite, "boots");
        CraftingRecipes.addArmorSet(ZGItems.bootsRadium, ZGItems.radium, "boots");
        CraftingRecipes.addArmorSet(ZGItems.bootsRuby, ZGItems.ruby, "boots");
        CraftingRecipes.addArmorSet(ZGItems.bootsSapphire, ZGItems.sapphire, "boots");
        CraftingRecipes.addArmorSet(ZGItems.bootsZanium, ZGItems.zanium, "boots");
        CraftingRecipes.addArmorSet(ZGItems.bootsRadite, ZGItems.ingotRadite, "boots");
        CraftingRecipes.addArmorSet(ZGItems.bootsZogite, ZGItems.ingotZogite, "boots");
        ZGRecipeHelper.addRecipe(new ItemStack(ZGBlocks.blockRedObsidian, 2), "BN ", "NB ", "   ", Character.valueOf('B'), Blocks.field_189878_dg, Character.valueOf('N'), Blocks.field_150343_Z);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.netheridium, 1), "BSB", "LXL", "VAV", Character.valueOf('B'), ZGItems.darkEssence, Character.valueOf('S'), ZGItems.superChargedCoal, Character.valueOf('V'), ZGItems.garnet, Character.valueOf('X'), ZGBlocks.blockWitherite, Character.valueOf('L'), Blocks.field_150343_Z, Character.valueOf('V'), Items.field_151065_br, Character.valueOf('A'), ZGItems.shadowBone);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGBlocks.blockNetherizedObsidian, 1), "WNW", "NON", "SNS", Character.valueOf('N'), ZGBlocks.blockNetheridium, Character.valueOf('W'), ZGBlocks.blockWitherite, Character.valueOf('O'), ZGBlocks.blockRedObsidian, Character.valueOf('S'), ZGItems.darkEssence);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.radium, 2), "GSG", "GAG", "GSG", Character.valueOf('G'), ZGBlocks.atheonConstructBlock, Character.valueOf('S'), ZGBlocks.blockSuperChargedCoal, Character.valueOf('A'), ZGBlocks.blockAzurite);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.BEDROCK_BREAKER), "ZAZ", " M ", " M ", Character.valueOf('Z'), ZGItems.ingotZucrite, Character.valueOf('A'), ZGItems.ascendium, Character.valueOf('M'), ZGItems.ingotAscendantAmaranth);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.garnetFire, 1), "BLB", "RGR", "BLB", Character.valueOf('B'), Items.field_151065_br, Character.valueOf('G'), ZGBlocks.blockGarnet, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('L'), Items.field_151072_bj);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.aquamarineIcy, 1), "SDS", "ZAZ", "AAA", Character.valueOf('S'), ZGItems.ingotShinium, Character.valueOf('Z'), ZGItems.dustShinestone, Character.valueOf('A'), ZGBlocks.blockAquamarine, Character.valueOf('D'), Items.field_151045_i);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.amberStatic, 1), "GTG", "UAU", "ZTZ", Character.valueOf('G'), Items.field_151043_k, Character.valueOf('T'), ZGItems.topaz, Character.valueOf('A'), ZGBlocks.blockAmber, Character.valueOf('Z'), ZGItems.ingotZinc, Character.valueOf('U'), ZGItems.azurite);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.swordFire, 1), " F ", " F ", "GPG", Character.valueOf('F'), ZGBlocks.blockGarnetFire, Character.valueOf('G'), ZGItems.garnet, Character.valueOf('P'), ZGItems.powerStick);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.swordThor, 1), " S ", " S ", "APA", Character.valueOf('S'), ZGBlocks.blockAmberStatic, Character.valueOf('A'), ZGItems.amber, Character.valueOf('P'), ZGItems.powerStick);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.swordEnder, 1), " E ", " E ", "OPM", Character.valueOf('E'), ZGBlocks.blockPerdEtrium, Character.valueOf('O'), ZGBlocks.blockPerdDiamond, Character.valueOf('M'), ZGBlocks.blockOpal, Character.valueOf('P'), ZGItems.powerStick);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.swordIce, 1), " I ", " I ", "APA", Character.valueOf('I'), ZGItems.aquamarineIcy, Character.valueOf('A'), ZGItems.aquamarine, Character.valueOf('P'), ZGItems.powerStick);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.swordWither, 1), " W ", " W ", "RAX", Character.valueOf('W'), ZGBlocks.blockNetheridium, Character.valueOf('R'), ZGBlocks.blockWitherite, Character.valueOf('A'), ZGItems.powerStick, Character.valueOf('X'), ZGItems.darkEssence);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.swordLight, 1), " W ", " W ", "RAX", Character.valueOf('W'), ZGBlocks.blockRadium, Character.valueOf('R'), ZGBlocks.blockAmberStatic, Character.valueOf('A'), ZGItems.powerStick, Character.valueOf('X'), ZGItems.radium);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.ingotShinium, 1), "DLD", "DSD", "DLD", Character.valueOf('D'), ZGItems.prometheanCrystal, Character.valueOf('S'), ZGItems.ingotShinestone, Character.valueOf('L'), ZGItems.ingotLapis);
        ++totalCraftRecipes;
        ItemStack filledChargiumBucket = FluidUtil.getFilledBucket((FluidStack)new FluidStack(ZGFluids.fluidChargium, 1000));
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.dustChargium, 8), "SS ", "ZZ ", "F  ", Character.valueOf('S'), ZGItems.dustShinium, Character.valueOf('Z'), ZGItems.kriffCrystal, Character.valueOf('F'), filledChargiumBucket);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.hud, 1), "RXR", "SDS", "RXR", Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('X'), new ItemStack(GCItems.basicItem, 1, 3), Character.valueOf('S'), new ItemStack(GCItems.basicItem, 1, 5), Character.valueOf('D'), new ItemStack(MarsItems.marsItemBasic, 1, 3));
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.kriffCrystal, 1), "FZF", "CVC", "ERE", Character.valueOf('F'), ZGItems.compressedKriffonium, Character.valueOf('Z'), ZGItems.zolCrystal, Character.valueOf('C'), ZGItems.compressedCobalt, Character.valueOf('V'), new ItemStack(MarsItems.marsItemBasic, 1, 3), Character.valueOf('E'), ZGItems.compressedHeartium, Character.valueOf('R'), ZGItems.compressedEmerald);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.purgCrystal, 1), "E E", " R ", "E E", Character.valueOf('E'), ZGItems.compressedEvenium, Character.valueOf('R'), Items.field_151137_ax);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.edenCrystal, 1), "EXE", "HRH", "EXE", Character.valueOf('E'), ZGItems.compressedEmerald, Character.valueOf('R'), ZGItems.kriffCrystal, Character.valueOf('X'), ZGItems.purgCrystal, Character.valueOf('H'), ZGItems.zolCrystal);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.alienStone, 1), "CVC", "ZBZ", "CIC", Character.valueOf('C'), ZGItems.edenCrystal, Character.valueOf('V'), ZGItems.compressedVyrex, Character.valueOf('Z'), ZGBlocks.blockCompressedCobalt, Character.valueOf('B'), ZGBlocks.blockViri, Character.valueOf('I'), ZGBlocks.edenBrightStone);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.chocolateRaw, 3), "CCC", "CEC", "CCC", Character.valueOf('C'), new ItemStack(Items.field_151100_aR, 1, 3), Character.valueOf('E'), Items.field_151110_aK);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.brownie, 4), "CC ", "CC ", "   ", Character.valueOf('C'), ZGItems.chocolateRaw);
        ++totalCraftRecipes;
        ZGRecipeHelper.addShapelessRecipe(new ItemStack(ZGItems.candyApple, 1), Items.field_151034_e, ZGItems.chocolateRaw);
        ++totalCraftRecipes;
        ZGRecipeHelper.addShapelessRecipe(new ItemStack(ZGItems.creamBall, 3), Items.field_151117_aB, Items.field_151102_aT);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.iceCreamSandwich, 1), "B  ", "C  ", "B  ", Character.valueOf('B'), ZGItems.brownie, Character.valueOf('C'), ZGItems.creamBall);
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.iceCreamSandwich, 1), " B ", " C ", " B ", Character.valueOf('B'), ZGItems.brownie, Character.valueOf('C'), ZGItems.creamBall);
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.iceCreamSandwich, 1), "  B", "  C", "  B", Character.valueOf('B'), ZGItems.brownie, Character.valueOf('C'), ZGItems.creamBall);
        totalCraftRecipes += 3;
        ZGRecipeHelper.addShapelessRecipe(new ItemStack(ZGItems.chocolateStrawberry, 1), ZGItems.chocolateRaw, ZGItems.strawberry);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(Items.field_151025_P, 16), "   ", "DDD", "   ", Character.valueOf('D'), ZGItems.doughCooked);
        ++totalCraftRecipes;
        ZGRecipeHelper.addShapelessRecipe(new ItemStack(Items.field_151174_bG, 2), Items.field_151170_bI, ZGItems.dustEnrichment);
        ZGRecipeHelper.addShapelessRecipe(new ItemStack(ZGItems.pea, 4), ZGItems.peas);
        ZGRecipeHelper.addShapelessRecipe(new ItemStack(ZGItems.cornKernel, 32), ZGItems.corn);
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.popcornBowl, 1), "CCC", "CBC", "CCC", Character.valueOf('C'), ZGItems.popcorn, Character.valueOf('B'), Items.field_151054_z);
        CraftingRecipes.addPickaxe(new ItemStack(ZGItems.pickaxeCobalt), ZGItems.ingotCobalt);
        CraftingRecipes.addPickaxe(new ItemStack(ZGItems.pickaxeEvenium), ZGItems.ingotEvenium);
        CraftingRecipes.addPickaxe(new ItemStack(ZGItems.pickaxeVirinium), ZGItems.ingotVirinium);
        CraftingRecipes.addPickaxe(new ItemStack(ZGItems.pickaxeAmaranth), ZGItems.ingotAmaranth);
        CraftingRecipes.addPickaxe(new ItemStack(ZGItems.pickaxeAzurite), ZGItems.azurite);
        CraftingRecipes.addPickaxe(new ItemStack(ZGItems.pickaxeZollernium), ZGItems.ingotZollernium);
        CraftingRecipes.addPickaxe(new ItemStack(ZGItems.pickaxeRuby), ZGItems.ruby);
        CraftingRecipes.addPickaxe(new ItemStack(ZGItems.pickaxeSapphire), ZGItems.sapphire);
        CraftingRecipes.addPickaxe(new ItemStack(ZGItems.pickaxeZanium), ZGItems.zanium);
        CraftingRecipes.addShovel(new ItemStack(ZGItems.shovelCobalt), ZGItems.ingotCobalt);
        CraftingRecipes.addShovel(new ItemStack(ZGItems.shovelEvenium), ZGItems.ingotEvenium);
        CraftingRecipes.addShovel(new ItemStack(ZGItems.shovelVirinium), ZGItems.ingotVirinium);
        CraftingRecipes.addShovel(new ItemStack(ZGItems.shovelAmaranth), ZGItems.ingotAmaranth);
        CraftingRecipes.addShovel(new ItemStack(ZGItems.shovelAzurite), ZGItems.azurite);
        CraftingRecipes.addShovel(new ItemStack(ZGItems.shovelZollernium), ZGItems.ingotZollernium);
        CraftingRecipes.addShovel(new ItemStack(ZGItems.shovelRuby), ZGItems.ruby);
        CraftingRecipes.addShovel(new ItemStack(ZGItems.shovelSapphire), ZGItems.sapphire);
        CraftingRecipes.addShovel(new ItemStack(ZGItems.shovelZanium), ZGItems.zanium);
        CraftingRecipes.addAxe(new ItemStack(ZGItems.axeCobalt), ZGItems.ingotCobalt);
        CraftingRecipes.addAxe(new ItemStack(ZGItems.axeEvenium), ZGItems.ingotEvenium);
        CraftingRecipes.addAxe(new ItemStack(ZGItems.axeVirinium), ZGItems.ingotVirinium);
        CraftingRecipes.addAxe(new ItemStack(ZGItems.axeAmaranth), ZGItems.ingotAmaranth);
        CraftingRecipes.addAxe(new ItemStack(ZGItems.axeAzurite), ZGItems.azurite);
        CraftingRecipes.addAxe(new ItemStack(ZGItems.axeZollernium), ZGItems.ingotZollernium);
        CraftingRecipes.addAxe(new ItemStack(ZGItems.axeRuby), ZGItems.ruby);
        CraftingRecipes.addAxe(new ItemStack(ZGItems.axeSapphire), ZGItems.sapphire);
        CraftingRecipes.addAxe(new ItemStack(ZGItems.axeZanium), ZGItems.zanium);
        CraftingRecipes.addHoe(new ItemStack(ZGItems.hoeCobalt), ZGItems.ingotCobalt);
        CraftingRecipes.addHoe(new ItemStack(ZGItems.hoeEvenium), ZGItems.ingotEvenium);
        CraftingRecipes.addHoe(new ItemStack(ZGItems.hoeVirinium), ZGItems.ingotVirinium);
        CraftingRecipes.addHoe(new ItemStack(ZGItems.hoeAmaranth), ZGItems.ingotAmaranth);
        CraftingRecipes.addHoe(new ItemStack(ZGItems.hoeAzurite), ZGItems.azurite);
        CraftingRecipes.addHoe(new ItemStack(ZGItems.hoeZollernium), ZGItems.ingotZollernium);
        CraftingRecipes.addHoe(new ItemStack(ZGItems.hoeRuby), ZGItems.ruby);
        CraftingRecipes.addHoe(new ItemStack(ZGItems.hoeSapphire), ZGItems.sapphire);
        CraftingRecipes.addHoe(new ItemStack(ZGItems.hoeZanium), ZGItems.zanium);
        CraftingRecipes.addSword(new ItemStack(ZGItems.swordCobalt), ZGItems.ingotCobalt);
        CraftingRecipes.addSword(new ItemStack(ZGItems.swordEvenium), ZGItems.ingotEvenium);
        CraftingRecipes.addSword(new ItemStack(ZGItems.swordVirinium), ZGItems.ingotVirinium);
        CraftingRecipes.addSword(new ItemStack(ZGItems.swordAmaranth), ZGItems.ingotAmaranth);
        CraftingRecipes.addSword(new ItemStack(ZGItems.swordAzurite), ZGItems.azurite);
        CraftingRecipes.addSword(new ItemStack(ZGItems.swordZollernium), ZGItems.ingotZollernium);
        CraftingRecipes.addSword(new ItemStack(ZGItems.swordRuby), ZGItems.ruby);
        CraftingRecipes.addSword(new ItemStack(ZGItems.swordSapphire), ZGItems.sapphire);
        CraftingRecipes.addSword(new ItemStack(ZGItems.swordZanium), ZGItems.zanium);
        CraftingRecipes.addTunneler(new ItemStack(ZGItems.tunnelerCopper), new ItemStack(GCItems.basicItem, 1, 3), new ItemStack(Items.field_151065_br, 1));
        CraftingRecipes.addTunneler(new ItemStack(ZGItems.tunnelerGold), ZGItems.compressedGold, ZGItems.radium);
        CraftingRecipes.addTunneler(new ItemStack(ZGItems.tunnelerAmaranth), ZGItems.compressedAmaranth, ZGItems.perdDiamond);
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.ascendium, 1), " Z ", " C ", " A ", Character.valueOf('Z'), ZGItems.compressedZollernium, Character.valueOf('C'), ZGItems.compressedZucrite, Character.valueOf('A'), ZGItems.compressedAmaranth);
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.powerStick, 2), " A ", " L ", " A ", Character.valueOf('A'), ZGItems.compressedAmaranth, Character.valueOf('L'), ZGItems.lapisStick);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.lapisStick, 4), " L ", " L ", " L ", Character.valueOf('L'), ZGItems.ingotLapis);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGBlocks.atheonConstructBlock, 4), "GGG", "GCG", "GGG", Character.valueOf('G'), Blocks.field_150340_R, Character.valueOf('C'), ZGBlocks.xantheonConstructBlock);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.OMNITOOL, 1), "ZZZ", "APA", " P ", Character.valueOf('Z'), ZGItems.compressedZollernium, Character.valueOf('A'), ZGItems.compressedAzurite, Character.valueOf('P'), ZGItems.powerStick);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.blueprintCorruption, 1), "ZZZ", "APA", " P ", Character.valueOf('Z'), ZGItems.compressedAscendantAmaranth, Character.valueOf('A'), ZGItems.ascendium, Character.valueOf('P'), ZGItems.ascendium);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.healingHeart), "AZA", "AOA", "ARA", Character.valueOf('A'), ZGItems.compressedHeartium, Character.valueOf('Z'), ZGItems.ingotZollernium, Character.valueOf('R'), ZGItems.ingotAmaranth, Character.valueOf('O'), ZGItems.radium);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.healingHeartForce), "ZSZ", "ZHZ", "ZZZ", Character.valueOf('Z'), ZGItems.ingotZinc, Character.valueOf('S'), ZGItems.ingotZollernium, Character.valueOf('H'), ZGItems.healingHeart);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.starGateTier1, 1), "VCV", "HYH", "YCY", Character.valueOf('V'), ZGItems.compressedDiamond, Character.valueOf('C'), ZGItems.compressedHeartium, Character.valueOf('H'), ZGItems.heartium, Character.valueOf('Y'), ZGItems.zolCrystal);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.starGateTier2, 1), "VCV", "HYH", "YCY", Character.valueOf('V'), ZGItems.compressedCobalt, Character.valueOf('C'), ZGItems.kriffCrystal, Character.valueOf('H'), ZGItems.heartium, Character.valueOf('Y'), ZGBlocks.blockCobalt);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.starGateTier3, 1), "VCV", "HYH", "YCY", Character.valueOf('V'), ZGItems.compressedEvenium, Character.valueOf('C'), ZGItems.compressedHeartium, Character.valueOf('H'), ZGItems.compressedCobalt, Character.valueOf('Y'), ZGItems.purgCrystal);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.starGateTier4, 1), "VCV", "HYH", "YCY", Character.valueOf('V'), ZGBlocks.blockCompressedViri, Character.valueOf('C'), ZGItems.compressedVyrex, Character.valueOf('H'), ZGBlocks.blockCompressedCobalt, Character.valueOf('Y'), ZGItems.alienStone);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.starGateTier5, 1), "VCV", "HYH", "YCY", Character.valueOf('V'), ZGBlocks.blockCompressedPromethean, Character.valueOf('C'), ZGItems.prometheanCrystal, Character.valueOf('H'), ZGBlocks.blockCompressedViri, Character.valueOf('Y'), ZGItems.compressedPromethean);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.starGateTier6, 1), "VCV", "HYH", "YCY", Character.valueOf('V'), ZGBlocks.blockCompressedSuperChargedCoal, Character.valueOf('C'), ZGItems.compressedRiven, Character.valueOf('H'), ZGBlocks.blockCompressedPromethean, Character.valueOf('Y'), ZGItems.compressedSuperChargedCoal);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.starGateTier7, 1), "VCV", "HYH", "YCY", Character.valueOf('V'), ZGItems.compressedAmaranth, Character.valueOf('C'), ZGItems.compressedAzurite, Character.valueOf('H'), ZGBlocks.xantheonConstructBlock, Character.valueOf('Y'), ZGBlocks.blockFueltonium);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.starGateTier8, 1), "VCV", "HYH", "YCY", Character.valueOf('V'), ZGItems.compressedGold, Character.valueOf('C'), ZGItems.compressedAzurite, Character.valueOf('H'), ZGBlocks.blockPlutonium, Character.valueOf('Y'), ZGBlocks.blockCompressedPromethean);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.starGateTier9, 1), "VCV", "HYH", "YCY", Character.valueOf('V'), ZGBlocks.blockCompressedZucrite, Character.valueOf('C'), ZGItems.ascendium, Character.valueOf('H'), ZGItems.compressedZollernium, Character.valueOf('Y'), ZGItems.alienStone);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.starGateTier10, 1), "VCV", "HYH", "YCY", Character.valueOf('V'), ZGBlocks.blockCompressedRhodium, Character.valueOf('C'), ZGItems.ascendium, Character.valueOf('H'), ZGItems.darkEssence, Character.valueOf('Y'), ZGItems.rokkite);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.starGateCandy, 1), "VCV", "HYH", "YCY", Character.valueOf('V'), ZGBlocks.xathCobble, Character.valueOf('C'), ZGBlocks.oasisRock, Character.valueOf('H'), ZGBlocks.atheonConstructBlock, Character.valueOf('Y'), ZGBlocks.blockPlutonium);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.starGateMoon, 1), "VCV", "HYH", "YCY", Character.valueOf('V'), GCItems.meteoricIronRaw, Character.valueOf('C'), ZGItems.compressedVirinium, Character.valueOf('H'), new ItemStack(GCBlocks.blockMoon, 1, 4), Character.valueOf('Y'), ZGItems.dustObsidian);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.amuletStorm, 1), "SVS", "VSV", "SVS", Character.valueOf('S'), ZGItems.stormCrystal, Character.valueOf('V'), ZGItems.ingotVirinium);
        ++totalCraftRecipes;
        ZGRecipeHelper.addShapelessRecipe(new ItemStack(ZGItems.medkit, 2), ZGItems.alcohol, ZGItems.gauze);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.gauze, 1), "S S", " P ", "S S", Character.valueOf('S'), Items.field_151007_F, Character.valueOf('P'), Items.field_151121_aF);
        ++totalCraftRecipes;
        ZGRecipeHelper.addShapelessRecipe(new ItemStack(ZGItems.alcohol, 1), Items.field_151069_bo, Items.field_151131_as, Items.field_151014_N, Items.field_151119_aD);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.nail, 2), " I ", " I ", "   ", Character.valueOf('I'), Items.field_151042_j);
        ++totalCraftRecipes;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.nailGroup, 1), "NN ", "NN ", "   ", Character.valueOf('N'), ZGItems.nail);
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.nailGroup, 1), " NN", " NN", "   ", Character.valueOf('N'), ZGItems.nail);
        totalCraftRecipes += 2;
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.woodBox, 1), "W W", " W ", "   ", Character.valueOf('W'), Blocks.field_150344_f);
        ZGRecipeHelper.addRecipe(new ItemStack(ZGItems.woodBox, 1), "   ", "W W", " W ", Character.valueOf('W'), Blocks.field_150344_f);
        totalCraftRecipes += 2;
        ZGRecipeHelper.addShapelessRecipe(new ItemStack(ZGItems.metalParts, 1), ZGItems.woodBox, ZGItems.nailGroup);
        ++totalCraftRecipes;
        ZGRecipeHelper.addShapelessRecipe(new ItemStack(ZGItems.dough, 2), ZGItems.flour, Items.field_151110_aK, Items.field_151117_aB);
        ++totalCraftRecipes;
        CraftingRecipes.addBricks(ZGItems.mudClayBall, ZGBlocks.mudClayBlock);
        CraftingRecipes.addSiren(ZGBlocks.ironSiren, Items.field_151042_j);
        CraftingRecipes.addSiren(ZGBlocks.goldSiren, Items.field_151043_k);
        CraftingRecipes.addSiren(ZGBlocks.diamondSiren, Items.field_151045_i);
        CraftingRecipes.addSiren(ZGBlocks.emeraldSiren, Items.field_151166_bC);
        CraftingRecipes.addOxygenTank(ZGItems.oxygenTankTier4, ZGItems.ingotLapis, ZGItems.compressedVirinium);
        CraftingRecipes.addOxygenTank(ZGItems.oxygenTankTier5, ZGItems.ingotAmaranth, ZGItems.compressedRhodium);
        CraftingRecipes.addOxygenTank(ZGItems.oxygenTankTier6, ZGItems.ingotPlutonium, ZGItems.compressedZanium);
    }

    public static void addBricks(Item coloredBrick, Block coloredBlock) {
        ZGRecipeHelper.addRecipe(new ItemStack(coloredBlock, 1), "CC ", "CC ", "   ", Character.valueOf('C'), coloredBrick);
        ZGRecipeHelper.addShapelessRecipe(new ItemStack(coloredBrick, 4), coloredBlock);
        ++totalCraftRecipes;
    }

    private static void addRockBricks(Block stoneIn, Block bricksOut) {
        ZGRecipeHelper.addRecipe(new ItemStack(bricksOut, 4), "SS", "SS", Character.valueOf('S'), stoneIn);
        ++totalCraftRecipes;
    }

    private static void addIngotMetal(Item ingotIn, Block blockOut) {
        ZGRecipeHelper.addRecipe(new ItemStack(blockOut, 1), "III", "III", "III", Character.valueOf('I'), ingotIn);
        ZGRecipeHelper.addShapelessRecipe(new ItemStack(ingotIn, 9), new ItemStack(blockOut));
        totalCraftRecipes += 2;
    }

    private static void addIngotMetal(Item ingotIn, Item itemOut) {
        ZGRecipeHelper.addRecipe(new ItemStack(itemOut, 1), "III", "III", "III", Character.valueOf('I'), ingotIn);
        ZGRecipeHelper.addShapelessRecipe(new ItemStack(ingotIn, 9), new ItemStack(itemOut));
        totalCraftRecipes += 2;
    }

    private static void addIngotMetal(Item ingotIn, Item itemOut, int stackAmount) {
        ZGRecipeHelper.addRecipe(new ItemStack(itemOut, 1), "III", "III", "III", Character.valueOf('I'), ingotIn);
        ZGRecipeHelper.addShapelessRecipe(new ItemStack(ingotIn, 9), new ItemStack(itemOut, stackAmount));
        totalCraftRecipes += 2;
    }

    private static void addIngotMetal(Block ingotIn, Block blockOut) {
        ZGRecipeHelper.addRecipe(new ItemStack(blockOut, 1), "III", "III", "III", Character.valueOf('I'), ingotIn);
        ZGRecipeHelper.addShapelessRecipe(new ItemStack(ingotIn, 9), new ItemStack(blockOut));
        totalCraftRecipes += 2;
    }

    private static void addIngotMetal(Block ingotIn, Block blockOut, int stackAmount) {
        ZGRecipeHelper.addRecipe(new ItemStack(blockOut, 1), "III", "III", "III", Character.valueOf('I'), ingotIn);
        ZGRecipeHelper.addShapelessRecipe(new ItemStack(ingotIn, 9), new ItemStack(blockOut, stackAmount));
        totalCraftRecipes += 2;
    }

    private static void addBriteStone(Item dustIn, Block blockOut) {
        ZGRecipeHelper.addRecipe(new ItemStack(blockOut, 1), "DD", "DD", Character.valueOf('D'), dustIn);
        ++totalCraftRecipes;
    }

    private static void addBriteStone(Block blockIn, Block blockOut) {
        ZGRecipeHelper.addRecipe(new ItemStack(blockOut, 1), "DD", "DD", Character.valueOf('D'), blockIn);
        ++totalCraftRecipes;
    }

    private static void addPlanks(Block logIn, Block planksOut) {
        ZGRecipeHelper.addShapelessRecipe(new ItemStack(planksOut, 4), new ItemStack(logIn));
        ++totalCraftRecipes;
    }

    private static void addToolSet(ItemStack itemOutput, Item itemIngot, String toolType) {
        ZGRecipeHelper.addSimpleToolSet(itemOutput, itemIngot, toolType);
        ++totalCraftRecipes;
    }

    public static void addArmorSet(Item itemInput, Item itemOutput, String armorType) {
        ZGRecipeHelper.addArmorSet(itemOutput, itemInput, armorType);
    }

    private static void addArmorSet(Item itemInput, Block blockInput, String armorType) {
        ZGRecipeHelper.addArmorSet(itemInput, blockInput, armorType);
    }

    private static void addPickaxe(ItemStack itemOutput, Item itemIngot) {
        CraftingRecipes.addToolSet(itemOutput, itemIngot, "pickaxe");
    }

    private static void addShovel(ItemStack itemOutput, Item itemIngot) {
        CraftingRecipes.addToolSet(itemOutput, itemIngot, "shovel");
    }

    private static void addAxe(ItemStack itemOutput, Item itemIngot) {
        CraftingRecipes.addToolSet(itemOutput, itemIngot, "axe");
    }

    private static void addSword(ItemStack itemOutput, Item itemIngot) {
        CraftingRecipes.addToolSet(itemOutput, itemIngot, "sword");
    }

    private static void addHoe(ItemStack itemOutput, Item itemIngot) {
        CraftingRecipes.addToolSet(itemOutput, itemIngot, "hoe");
    }

    private static void addTunneler(ItemStack itemOutput, Item itemMain, Item itemSecondary) {
        ZGRecipeHelper.addRecipe(itemOutput, "SMS", " M ", "SMS", Character.valueOf('M'), itemMain, Character.valueOf('S'), itemSecondary);
        ++totalCraftRecipes;
    }

    private static void addTunneler(ItemStack itemOutput, ItemStack itemMain, ItemStack itemSecondary) {
        ZGRecipeHelper.addRecipe(itemOutput, "SMS", " M ", "SMS", Character.valueOf('M'), itemMain, Character.valueOf('S'), itemSecondary);
        ++totalCraftRecipes;
    }

    private static void addSiren(Block sirenBlock, Item ingotIn) {
        ZGRecipeHelper.addRecipe(new ItemStack(sirenBlock, 1), "OIO", "IRI", "OIO", Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('I'), ingotIn, Character.valueOf('R'), Items.field_151137_ax);
        ++totalCraftRecipes;
    }

    private static void addOxygenTank(Item oxygenTankOut, Item ingotItemIn, Item compressedItemIn) {
        ZGRecipeHelper.addRecipe(new ItemStack(oxygenTankOut, 1), "XXX", "YYY", "ZZZ", Character.valueOf('X'), ingotItemIn, Character.valueOf('Y'), GCItems.oxTankHeavy, Character.valueOf('Z'), compressedItemIn);
        ++totalCraftRecipes;
    }
}

