/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.mobs.entities.robots.sentinels;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.mobs.entities.EntityFacehugger;
import zollerngalaxy.mobs.entities.EntityKree;
import zollerngalaxy.mobs.entities.EntityXenomorph;
import zollerngalaxy.mobs.entities.ai.EntityAIFindNearestPlayerZG;
import zollerngalaxy.mobs.entities.ai.EntityAISentinelAttackOnCollide;
import zollerngalaxy.mobs.entities.ai.EntityAISentinelLaserAttack;
import zollerngalaxy.mobs.entities.base.EntityRobotBaseZG;
import zollerngalaxy.mobs.entities.robots.sentinels.EntitySentinelDrone;
import zollerngalaxy.mobs.entities.robots.sentinels.EntitySentinelHound;
import zollerngalaxy.mobs.entities.robots.sentinels.EntitySentinelWalker;

public abstract class EntityAbstractSentinel
extends EntityRobotBaseZG {
    protected static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(EntityAbstractSentinel.class, (DataSerializer)DataSerializers.field_187198_h);
    protected int threatLevel;
    protected boolean hasCalledForBackup;
    protected static final int MAX_THREAT_LEVEL = 10;

    public EntityAbstractSentinel(World worldIn) {
        super(worldIn);
        this.setThreatLevel(0);
        this.setHasCalledForBackup(false);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAISentinelLaserAttack(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAISentinelAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, true));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAISentinelAttackOnCollide((EntityCreature)this, EntityAgeable.class, 1.0, true));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAISentinelAttackOnCollide((EntityCreature)this, EntityXenomorph.class, 1.0, true));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAISentinelAttackOnCollide((EntityCreature)this, EntityFacehugger.class, 1.0, true));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAISentinelAttackOnCollide((EntityCreature)this, EntityKree.class, 1.0, true));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAIFindNearestPlayerZG((EntityLiving)this));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(25.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
    }

    @Override
    public void func_70636_d() {
        IAttributeInstance maxHealthAttr = this.func_110148_a(SharedMonsterAttributes.field_111267_a);
        float currentHealth = this.func_110143_aJ();
        double maxHealth = maxHealthAttr.func_111125_b();
        if (this.threatLevel >= 10 || (double)currentHealth <= maxHealth / 2.0 && this.field_70146_Z.nextInt(10) == 0) {
            this.callReinforcements();
        }
        super.func_70636_d();
    }

    public void func_70645_a(DamageSource damagesource) {
        super.func_70645_a(damagesource);
        if (this.field_70146_Z.nextInt(8) == 0) {
            this.callReinforcements();
        }
    }

    protected void callReinforcements() {
        if (!this.field_70170_p.field_72995_K && ConfigManagerZG.enableSentinelReinforcements && !this.getHasCalledForBackup() && this.field_70146_Z.nextInt(this.getCallReinforcementsChance()) == 0) {
            EntityAbstractSentinel sentinel = null;
            int spawnTypeChance = this.field_70146_Z.nextInt(100);
            if (spawnTypeChance == 1) {
                sentinel = new EntitySentinelWalker(this.field_70170_p);
            } else if (spawnTypeChance <= 25) {
                sentinel = new EntitySentinelHound(this.field_70170_p);
            } else if (spawnTypeChance <= 45) {
                sentinel = new EntitySentinelDrone(this.field_70170_p);
            }
            if (sentinel != null && sentinel.func_70601_bi()) {
                sentinel.func_82149_j((Entity)this);
                this.field_70170_p.func_72838_d((Entity)sentinel);
                this.setThreatLevel(0);
                this.setHasCalledForBackup(true);
            }
        }
    }

    protected int getCallReinforcementsChance() {
        return 8;
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74777_a("ThreatLevel", (short)this.threatLevel);
        tag.func_74757_a("HasCalledForBackup", this.hasCalledForBackup);
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.threatLevel = tag.func_74765_d("ThreatLevel");
        this.hasCalledForBackup = tag.func_74767_n("HasCalledForBackup");
    }

    protected void setThreatLevel(int i) {
        this.threatLevel = i;
    }

    protected void setHasCalledForBackup(boolean hasCalledIn) {
        this.hasCalledForBackup = hasCalledIn;
    }

    protected int getThreatLevel() {
        return this.threatLevel;
    }

    protected boolean getHasCalledForBackup() {
        return this.hasCalledForBackup;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity instanceof EntityPlayer) {
            this.threatLevel += this.field_70146_Z.nextInt(4) == 0 ? 1 : 0;
            if (this.getThreatLevel() > 10) {
                this.setThreatLevel(10);
            }
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACKING, (Object)false);
    }

    public void setAttacking(boolean attacking) {
        this.field_70180_af.func_187227_b(ATTACKING, (Object)attacking);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACKING);
    }

    protected float func_70599_aP() {
        return 5.0f;
    }
}

