/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.mobs.entities.boss;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.blocks.centotl.BlockFacehuggerEgg;
import zollerngalaxy.core.ZGLootTables;
import zollerngalaxy.core.ZollernGalaxyCore;
import zollerngalaxy.events.ZGSoundEvents;
import zollerngalaxy.lib.helpers.ZGHelper;
import zollerngalaxy.mobs.entities.EntityXenomorph;
import zollerngalaxy.proxy.IProxy;
import zollerngalaxy.util.ZGUtils;

public class EntityXenomorphQueen
extends EntityXenomorph {
    private int maxHealth = 2500;
    private int xp = 12500;
    private double attackDamage = 15.0;
    private BlockPos entPos = this.func_180425_c();
    ZollernGalaxyCore core = ZollernGalaxyCore.instance();
    private IProxy proxy = ZollernGalaxyCore.proxy;
    private final BossInfoServer bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS);

    public EntityXenomorphQueen(World worldIn) {
        super(worldIn);
        this.func_70105_a(5.4f, 20.475f);
        this.func_98053_h(true);
        this.entPos = this.func_180425_c();
        this.field_70728_aV = this.xp;
        this.field_70744_aE = this.xp;
        this.field_70138_W = 2.0f;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return ZGSoundEvents.ENTITY_XENO_QUEEN_SAY;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return ZGSoundEvents.ENTITY_XENO_QUEEN_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return ZGSoundEvents.ENTITY_XENO_QUEEN_DEATH;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(2500.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(55.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3625721351723251);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.attackDamage);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(20.0);
    }

    public void func_70636_d() {
        double maxAtkDmg;
        double atkDmg;
        this.entPos = this.func_180425_c();
        Random rand = new Random();
        int randInt = rand.nextInt(1000);
        World world = this.field_70170_p;
        if (randInt <= 25) {
            this.layEgg(world, this.entPos);
        }
        if (this.func_110143_aJ() <= 550.0f && rand.nextInt(1000) <= 20 && (atkDmg = this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b()) < (maxAtkDmg = this.attackDamage * 2.0)) {
            this.attackDamage += 1.0;
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.attackDamage);
        }
        this.entPos = this.func_180425_c();
        super.func_70636_d();
    }

    protected void layEgg(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            IBlockState posDown = world.func_180495_p(pos.func_177977_b());
            IBlockState AIR = Blocks.field_150350_a.func_176223_P();
            IBlockState blockState = world.func_180495_p(pos);
            if (blockState == AIR && posDown != AIR && posDown != ZGBlocks.facehuggerEgg.func_176223_P()) {
                BlockFacehuggerEgg egg = (BlockFacehuggerEgg)ZGBlocks.facehuggerEgg;
                world.func_175656_a(pos, egg.func_176223_P());
                if (ZGHelper.rngInt(0, 100) <= 25) {
                    egg.hatchEgg(world, pos);
                }
            }
        }
    }

    @Override
    public void func_70074_a(EntityLivingBase par1EntityLivingBase) {
        super.func_70074_a(par1EntityLivingBase);
        float health = this.maxHealth;
        if (health <= (float)(this.maxHealth / 2)) {
            int randInt = this.field_70146_Z.nextInt(150);
            this.func_70606_j(this.maxHealth / 2 + randInt);
        }
    }

    protected float func_70599_aP() {
        return 5.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 18828890;
    }

    public float func_70013_c() {
        return 5.0f;
    }

    public boolean func_70104_M() {
        return false;
    }

    @Override
    public float func_70047_e() {
        float f = 5.74f;
        return f;
    }

    public boolean func_70814_o() {
        return true;
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public void func_70645_a(DamageSource par1) {
        super.func_70645_a(par1);
        if (this.field_70717_bb != null) {
            this.proxy.sendChatMessage(this.field_70717_bb, ZGUtils.translate("tooltips.xenobossbeaten"));
            this.onDefeat(this.field_70717_bb, this.field_70170_p, this.entPos, this.field_70146_Z);
        }
    }

    public void onDefeat(EntityPlayer player, World world, BlockPos chestPos, Random rand) {
        ZGLootTables.generateChest(world, chestPos, rand, ZGLootTables.CHEST_XENO_BOSS);
        String txtFormat = TextFormatting.GOLD + "" + TextFormatting.BOLD;
        String primeMsg = txtFormat + ZGUtils.translate("tooltips.treasurespawned");
        int chestX = chestPos.func_177958_n();
        int chestY = chestPos.func_177956_o();
        int chestZ = chestPos.func_177952_p();
        String chestPosStr = " (" + chestX + " " + chestY + " " + chestZ + ")";
        String fullMsg = primeMsg + chestPosStr;
        this.proxy.sendChatMessage(player, fullMsg);
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }
}

