/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.mobs;

import com.google.common.base.CaseFormat;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import zollerngalaxy.core.ZollernGalaxyCore;
import zollerngalaxy.lib.helpers.ZGHelper;
import zollerngalaxy.mobs.entities.EntityArcon;
import zollerngalaxy.mobs.entities.EntityBladeFish;
import zollerngalaxy.mobs.entities.EntityBloodWorm;
import zollerngalaxy.mobs.entities.EntityBlubberFish;
import zollerngalaxy.mobs.entities.EntityEdenCow;
import zollerngalaxy.mobs.entities.EntityFacehugger;
import zollerngalaxy.mobs.entities.EntityFaceless;
import zollerngalaxy.mobs.entities.EntityFrostGiant;
import zollerngalaxy.mobs.entities.EntityGalaxyKnight;
import zollerngalaxy.mobs.entities.EntityGrayAlien;
import zollerngalaxy.mobs.entities.EntityGypsyFish;
import zollerngalaxy.mobs.entities.EntityHelleton;
import zollerngalaxy.mobs.entities.EntityJellyfish;
import zollerngalaxy.mobs.entities.EntityKree;
import zollerngalaxy.mobs.entities.EntityKrull;
import zollerngalaxy.mobs.entities.EntityMagmos;
import zollerngalaxy.mobs.entities.EntityMegaCreeper;
import zollerngalaxy.mobs.entities.EntityMummy;
import zollerngalaxy.mobs.entities.EntityOinkus;
import zollerngalaxy.mobs.entities.EntityPigShroom;
import zollerngalaxy.mobs.entities.EntityScorpion;
import zollerngalaxy.mobs.entities.EntityShade;
import zollerngalaxy.mobs.entities.EntityShadowSkeleton;
import zollerngalaxy.mobs.entities.EntityShark;
import zollerngalaxy.mobs.entities.EntitySpiderling;
import zollerngalaxy.mobs.entities.EntitySquidlus;
import zollerngalaxy.mobs.entities.EntityWanderer;
import zollerngalaxy.mobs.entities.EntityWasp;
import zollerngalaxy.mobs.entities.EntityXenomorph;
import zollerngalaxy.mobs.entities.boss.EntityCrawler;
import zollerngalaxy.mobs.entities.boss.EntityShadowAlien;
import zollerngalaxy.mobs.entities.boss.EntityVexBotBoss;
import zollerngalaxy.mobs.entities.boss.EntityXenomorphQueen;
import zollerngalaxy.mobs.entities.companions.EntityGalaxyDragon;
import zollerngalaxy.mobs.entities.projectiles.EntitySentinelLaser;
import zollerngalaxy.mobs.entities.robots.EntityVexBot;
import zollerngalaxy.mobs.entities.robots.EntityVexBotGold;
import zollerngalaxy.mobs.entities.robots.sentinels.EntitySentinelDrone;
import zollerngalaxy.mobs.entities.robots.sentinels.EntitySentinelHound;
import zollerngalaxy.mobs.entities.robots.sentinels.EntitySentinelWalker;
import zollerngalaxy.mobs.entities.villagers.EntityAbyssalVillager;
import zollerngalaxy.mobs.entities.villagers.EntityAstrosVillager;
import zollerngalaxy.mobs.entities.villagers.EntityAtheonVillager;
import zollerngalaxy.mobs.entities.villagers.EntityCaligroVillager;
import zollerngalaxy.mobs.entities.villagers.EntityCandoraVillager;
import zollerngalaxy.mobs.entities.villagers.EntityCentotlVillager;
import zollerngalaxy.mobs.entities.villagers.EntityEdenVillager;
import zollerngalaxy.mobs.entities.villagers.EntityExodusVillager;
import zollerngalaxy.mobs.entities.villagers.EntityHarranVillager;
import zollerngalaxy.mobs.entities.villagers.EntityKriffonVillager;
import zollerngalaxy.mobs.entities.villagers.EntityKronosVillager;
import zollerngalaxy.mobs.entities.villagers.EntityMavethVillager;
import zollerngalaxy.mobs.entities.villagers.EntityOasisVillager;
import zollerngalaxy.mobs.entities.villagers.EntityPerditaVillager;
import zollerngalaxy.mobs.entities.villagers.EntityPurgotVillager;
import zollerngalaxy.mobs.entities.villagers.EntityTlalocVillager;
import zollerngalaxy.mobs.entities.villagers.EntityTociVillager;
import zollerngalaxy.mobs.entities.villagers.EntityZollusVillager;
import zollerngalaxy.mobs.entities.zombiemutations.EntityGhoul;
import zollerngalaxy.mobs.entities.zombiemutations.EntityOverlord;
import zollerngalaxy.mobs.entities.zombiemutations.EntitySeeker;
import zollerngalaxy.mobs.entities.zombiemutations.EntityVolatile;

public class MobRegistry {
    private static int entityId = -1;
    private static int totalMobs = 0;
    private static CaseFormat caseFormLower = CaseFormat.LOWER_CAMEL;
    private static CaseFormat caseFormUnder = CaseFormat.LOWER_UNDERSCORE;
    private static ZollernGalaxyCore coreInstance = ZollernGalaxyCore.instance();

    public static void init() {
        MobRegistry.registerEntity("moolus", EntityEdenCow.class, entityId++, 35584, 0xEEEEEE);
        MobRegistry.registerEntity("oinkus", EntityOinkus.class, entityId++, 40704, 0xEEFFEE);
        MobRegistry.registerEntity("squidlus", EntitySquidlus.class, entityId++, 39423, 0xEEEEEE);
        EntitySpawnPlacementRegistry.setPlacementType(EntitySquidlus.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
        MobRegistry.registerEntity("frostgiant", EntityFrostGiant.class, entityId++, 39423, 0x3399FF);
        MobRegistry.registerEntity("magmos", EntityMagmos.class, entityId++, 0x8B0000, 0xFF0000);
        MobRegistry.registerEntity("grayalien", EntityGrayAlien.class, entityId++, 0xEEEEEE, 0);
        MobRegistry.registerEntity("galaxyknight", EntityGalaxyKnight.class, entityId++, 0x444444, 0x8B008B);
        MobRegistry.registerEntity("megacreeper", EntityMegaCreeper.class, entityId++, 0xEE00EE, 60928);
        MobRegistry.registerEntity("mummy", EntityMummy.class, entityId++, 571792, 16117427);
        MobRegistry.registerEntity("scorpion", EntityScorpion.class, entityId++, 16117427, 9148672);
        MobRegistry.registerEntity("spiderling", EntitySpiderling.class, entityId++, 0, 16747264);
        MobRegistry.registerEntity("krull", EntityKrull.class, entityId++, 16117427, 0x444444);
        MobRegistry.registerEntity("shadowskeleton", EntityShadowSkeleton.class, entityId++, 0xEEEEEE, 158);
        MobRegistry.registerEntity("helleton", EntityHelleton.class, entityId++, 0x8B0000, 0xAA0000);
        MobRegistry.registerEntity("shade", EntityShade.class, entityId++, 0, 0xFFFFFF);
        MobRegistry.registerEntity("faceless", EntityFaceless.class, entityId++, 0x800080, 16753920);
        MobRegistry.registerEntity("shadowalien", EntityShadowAlien.class, entityId++, 0, 0xEEEEEE);
        MobRegistry.registerEntity("xenomorphqueen", EntityXenomorphQueen.class, entityId++, 0xEEEEEE, 9159932);
        MobRegistry.registerEntity("vexbotboss", EntityVexBotBoss.class, entityId++, 0xEEDDEA, 9109663);
        MobRegistry.registerEntity("crawler", EntityCrawler.class, entityId++, 0xDDDDDD, 0x444444);
        MobRegistry.registerEntity("blubberfish", EntityBlubberFish.class, entityId++, 0xFFFF00, 39423);
        EntitySpawnPlacementRegistry.setPlacementType(EntityBlubberFish.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
        MobRegistry.registerEntity("gypsyfish", EntityGypsyFish.class, entityId++, 9148672, 39423);
        EntitySpawnPlacementRegistry.setPlacementType(EntityGypsyFish.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
        MobRegistry.registerEntity("bladefish", EntityBladeFish.class, entityId++, 0x8B0000, 39423);
        EntitySpawnPlacementRegistry.setPlacementType(EntityBladeFish.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
        MobRegistry.registerEntity("shark", EntityShark.class, entityId++, 0, 0x777777);
        EntitySpawnPlacementRegistry.setPlacementType(EntityShark.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
        MobRegistry.registerEntity("jellyfish", EntityJellyfish.class, entityId++, 139, 35584);
        EntitySpawnPlacementRegistry.setPlacementType(EntityJellyfish.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
        MobRegistry.registerEntity("abyssalvillager", EntityAbyssalVillager.class, entityId++, 0x8B8B00, 39423);
        EntitySpawnPlacementRegistry.setPlacementType(EntityAbyssalVillager.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
        MobRegistry.registerEntity("harranvillager", EntityHarranVillager.class, entityId++, 9129355, 0xFFFF4D);
        MobRegistry.registerEntity("edenvillager", EntityEdenVillager.class, entityId++, 39423, 35584);
        MobRegistry.registerEntity("astrosvillager", EntityAstrosVillager.class, entityId++, 0xEEEEEE, 0xEEFFEE);
        MobRegistry.registerEntity("caligrovillager", EntityCaligroVillager.class, entityId++, 0, 0xFF0000);
        MobRegistry.registerEntity("zollusvillager", EntityZollusVillager.class, entityId++, 39423, 0);
        MobRegistry.registerEntity("kriffonvillager", EntityKriffonVillager.class, entityId++, 0xFF0000, 0x8B0000);
        MobRegistry.registerEntity("purgotvillager", EntityPurgotVillager.class, entityId++, 9849600, 16730880);
        MobRegistry.registerEntity("centotlvillager", EntityCentotlVillager.class, entityId++, 0, 0xFFFFFF);
        MobRegistry.registerEntity("tocivillager", EntityTociVillager.class, entityId++, 39423, 0x8B008B);
        MobRegistry.registerEntity("perditavillager", EntityPerditaVillager.class, entityId++, 0x8B008B, 14977852);
        MobRegistry.registerEntity("tlalocvillager", EntityTlalocVillager.class, entityId++, 0xEEEEEE, 0xBBBBBB);
        MobRegistry.registerEntity("oasisvillager", EntityOasisVillager.class, entityId++, 0xFF0000, 16766720);
        MobRegistry.registerEntity("candoravillager", EntityCandoraVillager.class, entityId++, 10972097, 139);
        MobRegistry.registerEntity("exodusvillager", EntityExodusVillager.class, entityId++, 35584, 65486);
        MobRegistry.registerEntity("kronosvillager", EntityKronosVillager.class, entityId++, 39423, 9109759);
        MobRegistry.registerEntity("atheonvillager", EntityAtheonVillager.class, entityId++, 65535, 35723);
        MobRegistry.registerEntity("mavethvillager", EntityMavethVillager.class, entityId++, 17612, 0xEEEEEE);
        MobRegistry.registerEntity("wanderer", EntityWanderer.class, entityId++, 56576, 9118174);
        MobRegistry.registerEntity("wasp", EntityWasp.class, entityId++, 0, 0xFFFF00);
        EntitySpawnPlacementRegistry.setPlacementType(EntityWasp.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_AIR);
        MobRegistry.registerEntity("pigshroom", EntityPigShroom.class, entityId++, 0x990000, 0xEEEEEE);
        MobRegistry.registerEntity("arcon", EntityArcon.class, entityId++, 238, 204);
        MobRegistry.registerEntity("volatile", EntityVolatile.class, entityId++, 0xEEEEEE, 0xF00000);
        MobRegistry.registerEntity("seeker", EntitySeeker.class, entityId++, 39168, 139);
        MobRegistry.registerEntity("overlord", EntityOverlord.class, entityId++, 0xEEEEEE, 35584);
        MobRegistry.registerEntity("ghoul", EntityGhoul.class, entityId++, 0x444444, 0xEEEEEE);
        MobRegistry.registerEntity("facehugger", EntityFacehugger.class, entityId++, 10972097, 9849600);
        MobRegistry.registerEntity("xenomorph", EntityXenomorph.class, entityId++, 0xEEEEEE, 0xCCCCCC);
        MobRegistry.registerEntity("dragon", EntityGalaxyDragon.class, entityId++, 0, 0x990099);
        MobRegistry.registerEntity("vexbot", EntityVexBot.class, entityId++, 0xEEEEEE, 0xBEBEBE);
        MobRegistry.registerEntity("vexbotgold", EntityVexBotGold.class, entityId++, 0xFFFF00, 0xBE0000);
        MobRegistry.registerEntity("bloodworm", EntityBloodWorm.class, entityId++, 0x8B008B, 0x8B008B);
        MobRegistry.registerEntity("kree", EntityKree.class, entityId++, 139, 139);
        MobRegistry.registerNonMobEntity("sentinelgunshot", EntitySentinelLaser.class, entityId++);
        MobRegistry.registerEntity("sentinel", EntitySentinelDrone.class, entityId++, 0x444444, 0x8B0000);
        MobRegistry.registerEntity("sentinelhound", EntitySentinelHound.class, entityId++, 0x777777, 0xFF0000);
        MobRegistry.registerEntity("sentinelwalker", EntitySentinelWalker.class, entityId++, 0x222222, 0x8F0000);
        ZGHelper.Log("Loaded a total of " + totalMobs + " new mobs.");
    }

    private static void registerNonMobEntity(String name, Class<? extends Entity> cls, int id) {
        ResourceLocation registryName = new ResourceLocation("zollerngalaxy:" + name);
        String strName = registryName.toString();
        String entityName = caseFormUnder.to(caseFormLower, strName);
        EntityRegistry.registerModEntity((ResourceLocation)registryName, cls, (String)entityName, (int)id, (Object)coreInstance, (int)64, (int)1, (boolean)true);
        ++totalMobs;
    }

    private static void registerEntity(String name, Class<? extends Entity> cls, int id, int primaryEggColor, int secondaryEggColor) {
        ResourceLocation registryName = new ResourceLocation("zollerngalaxy:" + name);
        String strName = registryName.toString();
        int clrPrm = primaryEggColor;
        int clrSec = secondaryEggColor;
        String entityName = caseFormUnder.to(caseFormLower, strName);
        EntityRegistry.registerModEntity((ResourceLocation)registryName, cls, (String)entityName, (int)id, (Object)coreInstance, (int)64, (int)1, (boolean)true, (int)clrPrm, (int)clrSec);
        ++totalMobs;
    }
}

