/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.events;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.planets.venus.client.FakeLightningBoltRenderer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zollerngalaxy.blocks.ZGBlockDirt;
import zollerngalaxy.blocks.ZGBlockGrass;
import zollerngalaxy.blocks.ZGSand;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.ZGLootTables;
import zollerngalaxy.core.ZollernGalaxyCore;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderCaligro;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderMetztli;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderVortex;
import zollerngalaxy.events.WindBlowingEvent;
import zollerngalaxy.events.ZGSoundEvents;
import zollerngalaxy.items.ZGItems;
import zollerngalaxy.lib.helpers.ZGHelper;
import zollerngalaxy.mobs.entities.EntityBladeFish;
import zollerngalaxy.mobs.entities.EntityBlubberFish;
import zollerngalaxy.mobs.entities.EntityEdenCow;
import zollerngalaxy.mobs.entities.EntityGalaxyKnight;
import zollerngalaxy.mobs.entities.EntityGrayAlien;
import zollerngalaxy.mobs.entities.EntityKree;
import zollerngalaxy.mobs.entities.EntityMegaCreeper;
import zollerngalaxy.mobs.entities.EntityMummy;
import zollerngalaxy.mobs.entities.EntityOinkus;
import zollerngalaxy.mobs.entities.EntityScorpion;
import zollerngalaxy.mobs.entities.EntityShadowSkeleton;
import zollerngalaxy.mobs.entities.EntityShark;
import zollerngalaxy.mobs.entities.base.EntityMutantZombie;
import zollerngalaxy.mobs.entities.companions.EntityGalaxyDragon;
import zollerngalaxy.mobs.entities.interfaces.IShadeEntity;
import zollerngalaxy.mobs.entities.robots.EntityVexBot;
import zollerngalaxy.potions.ZGPotions;
import zollerngalaxy.proxy.IProxy;
import zollerngalaxy.util.ArmorUtils;
import zollerngalaxy.util.CachedEnumZG;
import zollerngalaxy.util.VillagerUtils;
import zollerngalaxy.util.ZGDamageSrc;
import zollerngalaxy.util.ZGUtils;
import zollerngalaxy.util.ZombieUtils;

public class ZGEvents {
    private ZollernGalaxyCore core = ZollernGalaxyCore.instance();
    private IProxy proxy = ZollernGalaxyCore.proxy;
    private Map<BlockPos, Integer> lightning = Maps.newHashMap();

    @SubscribeEvent(priority=EventPriority.HIGH, receiveCanceled=true)
    public void onBlockBrokenEvent(BlockEvent.BreakEvent event) {
        BlockPos pos;
        IBlockState state;
        World world = event.getWorld();
        if (!world.field_72995_K && (state = world.func_180495_p(pos = event.getPos())).func_177230_c() == Blocks.field_150380_bt) {
            EntityGalaxyDragon galaxyDragon = new EntityGalaxyDragon(world);
            ZGHelper.spawnEntity((Entity)galaxyDragon, world, pos);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGH, receiveCanceled=true)
    public void onWindBlowingEvent(WindBlowingEvent event) {
        if (ConfigManagerZG.enableWindBlowEvent) {
            Minecraft minecraft = ZGUtils.getClient();
            EntityPlayerSP player = minecraft.field_71439_g;
            World world = event.getWorld();
            WorldProvider provider = world.field_73011_w;
            if (ZGHelper.rngInt(1, 150) == 0 && provider instanceof WorldProviderVortex) {
                double freq = player.func_70681_au().nextDouble() * Math.PI * 2.0;
                double dist = 60.0;
                double dX = dist * Math.cos(freq);
                double dZ = dist * Math.sin(freq);
                double posX = player.field_70165_t + dX;
                double posY = 70.0;
                double posZ = player.field_70161_v + dZ;
                float pitch = 5.0f + player.func_70681_au().nextFloat() * 0.2f;
                event.updateDirectionBasedOnChance();
                minecraft.field_71441_e.func_184148_a((EntityPlayer)player, posX, posY, posZ, ZGSoundEvents.WEATHER_WIND, SoundCategory.WEATHER, 1000.0f, pitch);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGH, receiveCanceled=true)
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ItemStack repairItemStack;
        int toolDamage;
        Item currentItem;
        ItemStack heldItem;
        Item radium;
        ItemStack radiumStack;
        boolean hasRadium;
        EntityPlayer player = event.player;
        InventoryPlayer playerInventory = player.field_71071_by;
        World world = player.field_70170_p;
        WorldProvider provider = world.field_73011_w;
        boolean isCreativeMode = player.field_71075_bZ.field_75098_d;
        boolean isRadianceActive = player.func_70644_a(ZGPotions.radiance);
        boolean isAntiCorruptActive = player.func_70644_a(ZGPotions.antiCorruption);
        Iterator<Map.Entry<BlockPos, Integer>> it = this.lightning.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<BlockPos, Integer> entry = it.next();
            int val = entry.getValue();
            if (val - 1 <= 0) {
                it.remove();
                continue;
            }
            entry.setValue(val - 1);
        }
        if (player.func_70681_au().nextInt(550) == 0 && provider instanceof WorldProviderVortex) {
            double freq = player.func_70681_au().nextDouble() * Math.PI * 2.0;
            double dist = 60.0;
            double dX = dist * Math.cos(freq);
            double dZ = dist * Math.sin(freq);
            double posX = player.field_70165_t + dX;
            double posY = 70.0;
            double posZ = player.field_70161_v + dZ;
            float volume = 1000.0f;
            float pitch = 5.0f + player.func_70681_au().nextFloat() * 0.2f;
            this.lightning.put(new BlockPos(posX, posY, posZ), 20);
            SoundEvent thunder = SoundEvents.field_187754_de;
            SoundCategory category = SoundCategory.WEATHER;
            world.func_184148_a(player, posX, posY, posZ, thunder, category, volume, pitch);
        } else if (provider instanceof WorldProviderCaligro && (hasRadium = playerInventory.func_70431_c(radiumStack = new ItemStack(radium = ZGItems.radium, 1))) && !isCreativeMode && !isRadianceActive) {
            PotionEffect radianceEffect = new PotionEffect(ZGPotions.radiance, 6000, 1);
            player.func_70690_d(radianceEffect);
            if (playerInventory.func_70431_c(radiumStack)) {
                int invSlot = playerInventory.func_184429_b(radiumStack);
                playerInventory.func_70298_a(invSlot, 1);
            }
            this.proxy.sendChatMessage(player, TextFormatting.GOLD + ZGUtils.translate("tooltips.radiance"));
        }
        EnumHand currentHand = player.func_184600_cs();
        if (currentHand != null && (heldItem = player.func_184586_b(currentHand)) != null && (currentItem = heldItem.func_77973_b()) == ZGItems.BEDROCK_BREAKER && (toolDamage = heldItem.func_77952_i()) >= heldItem.func_77958_k() && playerInventory.func_70431_c(repairItemStack = new ItemStack(ZGItems.ingotAscendantAmaranth))) {
            ItemStack repairedItem = heldItem.func_77946_l();
            repairedItem.func_77964_b(0);
            int invSlot = playerInventory.func_184429_b(heldItem);
            playerInventory.func_70299_a(invSlot, repairedItem);
            playerInventory.func_70298_a(playerInventory.func_184429_b(repairItemStack), 1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGH, receiveCanceled=true)
    public void renderLightning(ClientProxyCore.EventSpecialRender event) {
        for (Map.Entry<BlockPos, Integer> entry : this.lightning.entrySet()) {
            BlockPos entryKey = entry.getKey();
            long seed = entry.getValue() / 10 + entryKey.func_177958_n() + entryKey.func_177952_p();
            double x = (double)entryKey.func_177958_n() - ClientProxyCore.playerPosX;
            double y = (double)entryKey.func_177956_o() - ClientProxyCore.playerPosY;
            double z = (double)entryKey.func_177952_p() - ClientProxyCore.playerPosZ;
            FakeLightningBoltRenderer.renderBolt((long)seed, (double)x, (double)y, (double)z);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH, receiveCanceled=true)
    public void onPlayerDeath(LivingDeathEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        WorldProvider provider = world.field_73011_w;
        if (!world.field_72995_K && provider instanceof WorldProviderMetztli && entity instanceof EntityPlayer) {
            DamageSource damageSource = event.getSource();
            Entity damageSourceEntity = damageSource.func_76364_f();
            EntityPlayer player = (EntityPlayer)entity;
            if (damageSourceEntity instanceof EntityZombie) {
                ZombieUtils.convertToZombie(player, world, EntityZombie.class, "Zombie");
            } else if (damageSourceEntity instanceof EntityMutantZombie) {
                String strMutantName = ((EntityMutantZombie)damageSourceEntity).getMutantName();
                strMutantName = strMutantName == "" || strMutantName == null ? "Mutant" : strMutantName;
                Class<?> mutantZombieClass = damageSourceEntity.getClass();
                ZombieUtils.convertToZombie(player, world, mutantZombieClass, strMutantName);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH, receiveCanceled=true)
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        Random rand = new Random();
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            BlockPos playerLocation = new BlockPos(player.field_70165_t, player.field_70163_u - 1.0, player.field_70161_v);
            World world = player.field_70170_p;
            boolean isCreativeMode = player.field_71075_bZ.field_75098_d;
            boolean isRadianceActive = player.func_70644_a(ZGPotions.radiance);
            boolean isAntiCorruptActive = player.func_70644_a(ZGPotions.antiCorruption);
            if (world.field_73011_w instanceof WorldProviderVortex) {
                if (ZGHelper.rngInt(1, 700) <= 15 && ConfigManagerZG.enableWindBlowEvent) {
                    MinecraftForge.EVENT_BUS.post((Event)new WindBlowingEvent(world, player));
                }
            } else if (world.field_73011_w instanceof WorldProviderCaligro && !isCreativeMode && !isRadianceActive) {
                player.func_70097_a((DamageSource)ZGDamageSrc.deathShadows, ZGDamageSrc.deathShadows.getDamageBase());
            }
            if (isRadianceActive) {
                ZGPotions.radiance.func_76394_a((EntityLivingBase)player, 1);
            }
            if (player.func_70644_a(ZGPotions.infected)) {
                Object[] playerArray;
                ZGPotions.infected.func_76394_a((EntityLivingBase)player, 1);
                Class<EntityPlayer> playerClass = EntityPlayer.class;
                AxisAlignedBB boundingBox = player.func_174813_aQ();
                AxisAlignedBB expandedBox = boundingBox.func_72321_a(5.0, 2.0, 5.0);
                List playerList = world.func_72872_a(playerClass, expandedBox);
                for (Object o : playerArray = playerList.toArray()) {
                    EntityPlayer currentPlayer = (EntityPlayer)o;
                    if (currentPlayer.func_70644_a(ZGPotions.infected)) continue;
                    PotionEffect infectEffect = new PotionEffect(ZGPotions.infected, 400, 1);
                    currentPlayer.func_70690_d(infectEffect);
                }
            }
            if (ConfigManagerZG.enableArmorEffects) {
                ArmorUtils.performArmorCheck(player);
            }
        }
        ZombieUtils.HandleMutations(entity, rand);
        ZombieUtils.doMutation((Entity)entity, rand);
    }

    @SubscribeEvent(priority=EventPriority.HIGH, receiveCanceled=true)
    public void onNameFormatEvent(PlayerEvent.NameFormat event) {
        if (!ConfigManagerZG.changeContributorNames) {
            return;
        }
        String username = event.getUsername();
        if ((username = username.toLowerCase()).equals("alphawolf918")) {
            event.setDisplayname(TextFormatting.GOLD + "Zollern Wolf" + TextFormatting.WHITE);
        } else if (username.equals("nascarmpfan")) {
            event.setDisplayname(TextFormatting.RED + "Specter Fettel" + TextFormatting.WHITE);
        } else if (username.equals("applepiec00kie")) {
            event.setDisplayname(TextFormatting.LIGHT_PURPLE + "Queen Apple" + TextFormatting.WHITE);
        } else if (username.equals("lazy_logic")) {
            event.setDisplayname(TextFormatting.AQUA + "Logic" + TextFormatting.WHITE);
        } else if (username.equals("master_zane")) {
            event.setDisplayname(TextFormatting.GOLD + "Master Zane" + TextFormatting.WHITE);
        } else if (username.equals("chronoxshift") || username.equals("chrono_miles_")) {
            event.setDisplayname(TextFormatting.AQUA + "ChronoxShift" + TextFormatting.WHITE);
        } else if (username.equals("actural_guy")) {
            event.setDisplayname(TextFormatting.GOLD + "ExistingEevee" + TextFormatting.WHITE);
        } else if (username.equals("autumnstarfire")) {
            event.setDisplayname(TextFormatting.LIGHT_PURPLE + "AutumnStarFire" + TextFormatting.WHITE);
        } else if (username.equals("snorlaxdacat")) {
            event.setDisplayname(TextFormatting.RED + "SnorlaxDaCat" + TextFormatting.WHITE);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onEntityDamaged(LivingHurtEvent event) {
        EntityLivingBase ent = event.getEntityLiving();
        DamageSource src = event.getSource();
        Random rand = ZGHelper.getRNG();
        if (ent instanceof EntityGrayAlien && ConfigManagerZG.spawnGalaxyKnight && rand.nextInt(100) <= 10) {
            EntityGrayAlien alien = (EntityGrayAlien)ent;
            if (src.func_76346_g() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)src.func_76346_g();
                BlockPos worldPos = alien.func_180425_c();
                World world = alien.func_130014_f_();
                EntityGalaxyKnight spaceKnight = new EntityGalaxyKnight(world);
                spaceKnight.func_70107_b(worldPos.func_177958_n(), worldPos.func_177956_o(), worldPos.func_177952_p());
                spaceKnight.func_70624_b((EntityLivingBase)player);
                world.func_72838_d((Entity)spaceKnight);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onLootTableLoadEvent(LootTableLoadEvent event) {
        ResourceLocation lootName = event.getName();
        if (lootName == LootTableList.field_186390_ao) {
            LootTableManager lootMgr = event.getLootTableManager();
            LootTable lootTbl = event.getTable();
            LootCondition[] conditions = new LootCondition[]{};
            RandomValueRange rng = new RandomValueRange(1.0f);
            RandomValueRange rngBonus = new RandomValueRange(0.0f);
            LootEntryTable entryZGFish = new LootEntryTable(ZGLootTables.GAMEPLAY_FISHING, 20, 10, conditions, "zgfishingentry");
            LootEntry[] entries = new LootEntry[]{entryZGFish};
            LootPool pool = new LootPool(entries, conditions, rng, rngBonus, "zgfishingpool");
            lootTbl.addPool(pool);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onJoinWorldEvent(EntityJoinWorldEvent event) {
        World world = event.getWorld();
        WorldProvider provider = world.field_73011_w;
        if (!world.field_72995_K) {
            EntityLightningBolt bolt;
            BlockPos boltPos;
            IBlockState posState;
            Block stateBlock;
            Entity ent = event.getEntity();
            if (ent instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)ent;
                if (this.core.isInTestMode() || this.core.isInDevMode()) {
                    String txtFormat = TextFormatting.BOLD + " " + TextFormatting.RED;
                    String msg = txtFormat + "WARNING: This is NOT a valid version of Zollern Galaxy! Please uninstall the mod and install the correct version, or it will not operate correctly. Please also contact the mod author immediately!";
                    this.proxy.sendChatMessage(player, msg);
                }
            }
            if (ent instanceof EntityLightningBolt && ((stateBlock = (posState = world.func_180495_p(boltPos = (bolt = (EntityLightningBolt)ent).func_180425_c())).func_177230_c()) instanceof BlockSand || stateBlock instanceof ZGSand)) {
                world.func_175656_a(boltPos, Blocks.field_150359_w.func_176223_P());
            }
        }
        VillagerUtils.ConvertVillagers(event);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onLivingDropsEvent(LivingDropsEvent event) {
        EntityLivingBase theEntity = event.getEntityLiving();
        World worldObj = theEntity.field_70170_p;
        if (!worldObj.field_72995_K) {
            int i;
            Random rand = new Random();
            int randInt = rand.nextInt(100);
            if (theEntity instanceof EntityEdenCow) {
                for (i = 0; i < ZGHelper.rngInt(1, 4); ++i) {
                    ZGHelper.dropItem(ZGItems.rawAlienBeef, worldObj, (Entity)theEntity);
                }
            }
            if (theEntity instanceof EntityOinkus) {
                for (i = 0; i < ZGHelper.rngInt(1, 4); ++i) {
                    ZGHelper.dropItem(ZGItems.rawAlienBacon, worldObj, (Entity)theEntity);
                }
            }
            if (theEntity instanceof EntityGrayAlien) {
                for (i = 0; i < ZGHelper.rngInt(1, 2); ++i) {
                    ZGHelper.dropItem(ZGItems.alienStone, worldObj, (Entity)theEntity);
                }
            }
            if (theEntity instanceof EntityMegaCreeper) {
                for (i = 0; i < ZGHelper.rngInt(1, 4); ++i) {
                    ZGHelper.dropItem(ZGItems.superChargedCoal, worldObj, (Entity)theEntity);
                }
            }
            if (theEntity instanceof EntityMummy) {
                if (ZGHelper.getRNGChance(5, 10)) {
                    for (i = 0; i < ZGHelper.rngInt(1, 3); ++i) {
                        ZGHelper.dropItem(Items.field_151121_aF, worldObj, (Entity)theEntity);
                    }
                }
                if (ZGHelper.getRNGChance(5, 20)) {
                    for (i = 0; i < ZGHelper.rngInt(1, 2); ++i) {
                        ZGHelper.dropItem(ZGItems.perdGlowdust, worldObj, (Entity)theEntity);
                    }
                }
            }
            if (theEntity instanceof EntityScorpion && ZGHelper.getRNGChance(5, 20)) {
                for (i = 0; i < ZGHelper.rngInt(1, 2); ++i) {
                    ZGHelper.dropItem(ZGItems.dustEmerald, worldObj, (Entity)theEntity);
                }
            }
            if (theEntity instanceof EntityShadowSkeleton && ZGHelper.getRNGChance(5, 10)) {
                for (i = 0; i < ZGHelper.rngInt(1, 4); ++i) {
                    ZGHelper.dropItem(ZGItems.shadowBone, worldObj, (Entity)theEntity);
                }
            }
            if (theEntity instanceof EntityBlubberFish) {
                ZGHelper.dropItem(ZGItems.rawBlubberFish, worldObj, (Entity)theEntity);
            }
            if (theEntity instanceof EntityBlubberFish) {
                ZGHelper.dropItem(ZGItems.rawGypsyFish, worldObj, (Entity)theEntity);
            }
            if (theEntity instanceof EntityBladeFish) {
                ZGHelper.dropItem(ZGItems.rawBladeFish, worldObj, (Entity)theEntity);
            }
            if (theEntity instanceof EntityShark) {
                if (ZGHelper.getRNGChance(5, 10)) {
                    for (i = 0; i < ZGHelper.rngInt(1, 2); ++i) {
                        ZGHelper.dropItem(ZGItems.shagreen, worldObj, (Entity)theEntity);
                    }
                }
                if (ZGHelper.getRNGChance(5, 10)) {
                    for (i = 0; i < ZGHelper.rngInt(1, 3); ++i) {
                        ZGHelper.dropItem(ZGItems.sharkTooth, worldObj, (Entity)theEntity);
                    }
                }
            }
            if (theEntity instanceof IShadeEntity && ((IShadeEntity)theEntity).shouldDropEssence() && ZGHelper.getRNGChance(5, 10)) {
                for (i = 0; i < ZGHelper.rngInt(1, 4); ++i) {
                    ZGHelper.dropItem(ZGItems.darkEssence, worldObj, (Entity)theEntity);
                }
            }
            if (theEntity instanceof EntityVexBot) {
                if (ZGHelper.getRNGChance(5, 10)) {
                    for (i = 0; i < ZGHelper.rngInt(1, 2); ++i) {
                        ZGHelper.dropItem(ZGItems.dustVirinium, worldObj, (Entity)theEntity);
                    }
                }
                if (ZGHelper.getRNGChance(5, 10)) {
                    for (i = 0; i < ZGHelper.rngInt(1, 2); ++i) {
                        ZGHelper.dropItem(ZGItems.ingotRhodium, worldObj, (Entity)theEntity);
                    }
                }
                if (ZGHelper.getRNGChance(5, 10)) {
                    for (i = 0; i < ZGHelper.rngInt(1, 2); ++i) {
                        ZGHelper.dropItem(ZGItems.ingotZinc, worldObj, (Entity)theEntity);
                    }
                }
            }
            if (theEntity instanceof EntityKree) {
                for (i = 0; i < ZGHelper.rngInt(1, 2); ++i) {
                    ZGHelper.dropItem(ZGItems.kreeFlesh, worldObj, (Entity)theEntity);
                }
                if (rand.nextInt(6) == 0) {
                    ZGHelper.dropItem(ZGItems.kreeReaperAxe, worldObj, (Entity)theEntity);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onUseHoe(UseHoeEvent event) {
        if (event.getResult() != Event.Result.DEFAULT || event.isCanceled()) {
            return;
        }
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (world.func_175623_d(pos.func_177984_a()) && (block instanceof ZGBlockGrass || block instanceof ZGBlockDirt)) {
            this.setFarmland(event, world, pos, Blocks.field_150458_ak);
        }
    }

    private void setFarmland(UseHoeEvent event, World world, BlockPos pos, Block farmland) {
        world.func_175656_a(pos, farmland.func_176223_P());
        event.setResult(Event.Result.ALLOW);
        SoundEvent stepSound = SoundType.field_185849_b.func_185844_d();
        SoundCategory soundCategory = SoundCategory.BLOCKS;
        float soundVolume = (SoundType.field_185849_b.func_185843_a() + 1.0f) / 2.0f;
        float soundPitch = SoundType.field_185849_b.func_185847_b() * 0.8f;
        world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stepSound, soundCategory, soundVolume, soundPitch);
        for (EnumHand hand : CachedEnumZG.valuesHandCached()) {
            event.getEntityPlayer().func_184609_a(hand);
        }
    }
}

