/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.core.dimensions.worldproviders.orbit;

import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderOverworldOrbit;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zollerngalaxy.celestial.ZGPlanets;
import zollerngalaxy.celestial.spacestations.ZGSpaceStations;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.dimensions.ZGDimensions;
import zollerngalaxy.core.dimensions.chunkproviders.ChunkProviderOrbitZG;

public class WorldProviderOrbitVortex
extends WorldProviderOverworldOrbit {
    public CelestialBody getCelestialBody() {
        return ZGSpaceStations.VORTEX_SPACE_STATION;
    }

    public float getSolarSize() {
        return 1.8f;
    }

    public Vector3 getFogColor() {
        float f = 1.1f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.78431374f * f), (double)(0.023529412f * f), (double)(0.972549f * f));
    }

    public Vector3 getSkyColor() {
        float f = 1.15f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.039215688f * f), (double)(0.003921569f * f), (double)(0.9843137f * f));
    }

    public boolean canRainOrSnow() {
        return false;
    }

    public boolean hasSunset() {
        return false;
    }

    public long getDayLength() {
        return 36527L;
    }

    public Class<? extends IChunkGenerator> getChunkProviderClass() {
        return ChunkProviderOrbitZG.class;
    }

    public boolean isDaytime() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        float f1 = this.field_76579_a.func_72826_c(par1);
        float f2 = 1.0f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.3f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return f2 * f2 * 1.4f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float par1) {
        float f1 = this.field_76579_a.func_72826_c(1.0f);
        float f2 = 0.9f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.2f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        f2 = 1.0f - f2;
        return f2 * 0.6f;
    }

    public boolean func_76561_g() {
        return false;
    }

    public double getHorizon() {
        return 44.0;
    }

    public int func_76557_i() {
        return 44;
    }

    public boolean func_76569_d() {
        return true;
    }

    public boolean func_76566_a(int var1, int var2) {
        return true;
    }

    public float getGravity() {
        return 0.024f;
    }

    public boolean hasBreathableAtmosphere() {
        return false;
    }

    public double getMeteorFrequency() {
        return 0.0;
    }

    public double getFuelUsageMultiplier() {
        return 6.5;
    }

    public String getPlanetToOrbit() {
        return "planet.vortex";
    }

    public String getSaveFolder() {
        return "space_stations/vortex";
    }

    public double getSolarEnergyMultiplier() {
        return ConfigManagerCore.spaceStationEnergyScalar;
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier > ZGPlanets.planetVortex.getTierRequirement();
    }

    public float getFallDamageModifier() {
        return 0.24f;
    }

    public float getSoundVolReductionAmount() {
        return 50.0f;
    }

    public float getThermalLevelModifier() {
        return 0.0f;
    }

    public float getWindLevel() {
        return 0.5f;
    }

    public DimensionType func_186058_p() {
        return ZGDimensions.VORTEX_ORBIT;
    }

    public int getPlanetIdToOrbit() {
        return ConfigManagerZG.planetVortexDimensionId;
    }
}

