/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.core.dimensions.worldproviders;

import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IExitHeight;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import micdoodle8.mods.galacticraft.core.event.EventHandlerGC;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.world.World;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class WorldProviderZG
extends WorldProviderSpace
implements ISolarLevel,
IExitHeight {
    private static WorldProviderZG instance;

    public WorldProviderZG() {
        instance = this;
    }

    public static WorldProviderZG instance() {
        return instance;
    }

    public World getWorldObj() {
        return this.field_76579_a;
    }

    public boolean shouldForceRespawn() {
        return !ConfigManagerCore.forceOverworldRespawn;
    }

    public float getSolarSize() {
        return 1.0f;
    }

    public Vector3 getFogColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    public void updateWeather() {
        World worldObj = this.getWorldObj();
        WorldInfo worldInfo = worldObj.func_72912_H();
        if (!this.shouldDisablePrecipitation()) {
            super.updateWeather();
        } else {
            worldInfo.func_76080_g(0);
            worldInfo.func_76084_b(false);
            worldInfo.func_76090_f(0);
            worldInfo.func_76069_a(false);
            worldObj.field_73004_o = 0.0f;
            worldObj.field_73017_q = 0.0f;
        }
    }

    public Vector3 getSkyColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    public boolean func_76567_e() {
        if (EventHandlerGC.bedActivated) {
            EventHandlerGC.bedActivated = false;
            return true;
        }
        return false;
    }

    public double getFuelUsageMultiplier() {
        return 0.5;
    }

    public double getMeteorFrequency() {
        return 0.0;
    }

    public float getArrowGravity() {
        return 0.003f;
    }

    public int getDungeonSpacing() {
        return 704;
    }

    public boolean hasBreathableAtmosphere() {
        return false;
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier >= this.getCelestialBody().getTierRequirement();
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        if (super.getSkyRenderer() == null) {
            this.renderSky();
        }
        return super.getSkyRenderer();
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getCloudRenderer() {
        if (super.getCloudRenderer() == null) {
            this.renderCloud();
        }
        return super.getCloudRenderer();
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getWeatherRenderer() {
        if (super.getWeatherRenderer() == null) {
            this.renderWeather();
        }
        return super.getWeatherRenderer();
    }

    public boolean func_191066_m() {
        return true;
    }

    protected abstract void renderSky();

    protected abstract void renderCloud();

    protected abstract void renderWeather();

    public abstract Class<? extends IChunkGenerator> getChunkProviderClass();
}

