/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.core.dimensions.worldproviders;

import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeAdaptive;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.client.CloudRenderer;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zollerngalaxy.biomes.providers.BiomeProviderXantheon;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.celestial.ZGPlanet;
import zollerngalaxy.celestial.ZGPlanets;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.dimensions.ZGDimensions;
import zollerngalaxy.core.dimensions.chunkproviders.ChunkProviderXantheon;
import zollerngalaxy.core.dimensions.skyproviders.SkyProviderXantheon;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderPlanetZG;

public class WorldProviderXantheon
extends WorldProviderPlanetZG {
    public float getGravity() {
        return 0.045f;
    }

    @Override
    public double getMeteorFrequency() {
        return ConfigManagerZG.meteorGenXantheon;
    }

    @Override
    public float getSolarSize() {
        return 0.01f;
    }

    @Override
    public double getFuelUsageMultiplier() {
        return 1.8;
    }

    public float getFallDamageModifier() {
        return 0.44f;
    }

    public float getThermalLevelModifier() {
        return -1.5f;
    }

    @Override
    public float getBodyTemp() {
        ZGPlanet planet = this.getPlanet();
        float planetTemp = planet.getBodyTemperature();
        if (!this.isDaytime()) {
            planetTemp /= 3.4f;
        }
        return planetTemp;
    }

    public float getSoundVolReductionAmount() {
        return 2.0f;
    }

    public CelestialBody getCelestialBody() {
        return ZGPlanets.planetXantheon;
    }

    public double getSolarEnergyMultiplier() {
        return 0.0045;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        float var2 = this.field_76579_a.func_72826_c(par1);
        float var3 = 1.2f - (MathHelper.func_76134_b((float)(var2 * (float)Math.PI * 2.0f)) * 2.0f + 0.25f);
        if (var3 < 0.0f) {
            var3 = 0.25f;
        }
        if (var3 > 1.0f) {
            var3 = 0.75f;
        }
        return var3 * var3 * 0.5f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float par1) {
        float f1 = this.field_76579_a.func_72826_c(1.0f);
        float f2 = 1.0f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.2f);
        if (f2 < 0.0f) {
            f2 = 0.6f;
        }
        if (f2 > 1.0f) {
            f2 = 0.95f;
        }
        f2 = 0.95f - f2;
        return f2 * 0.64f;
    }

    public double getHorizon() {
        return 54.0;
    }

    public int func_76557_i() {
        return 72;
    }

    @Override
    public Vector3 getFogColor() {
        float f = 1.0f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.23529412f * f), (double)(0.23529412f * f), (double)(0.23529412f * f));
    }

    public boolean canRainOrSnow() {
        return false;
    }

    public boolean hasSunset() {
        return true;
    }

    public long getDayLength() {
        return 106020L;
    }

    public ResourceLocation getDungeonChestType() {
        return null;
    }

    public List<Block> getSurfaceBlocks() {
        ArrayList<Block> blockList = new ArrayList<Block>();
        blockList.add(ZGBlocks.xantheonRock);
        return blockList;
    }

    @Override
    protected void renderSky() {
        this.setSkyRenderer(new SkyProviderXantheon((IGalacticraftWorldProvider)this));
    }

    @Override
    protected void renderCloud() {
        this.setCloudRenderer((IRenderHandler)new CloudRenderer());
    }

    @Override
    protected void renderWeather() {
    }

    public Class<? extends BiomeProvider> getBiomeProviderClass() {
        BiomeAdaptive.setBodyMultiBiome((CelestialBody)ZGPlanets.planetXantheon);
        return BiomeProviderXantheon.class;
    }

    public DimensionType func_186058_p() {
        return ZGDimensions.XANTHEON;
    }

    public double getYCoordinateToTeleport() {
        return 120.0;
    }

    public boolean func_76561_g() {
        return true;
    }

    @Override
    public Class<? extends IChunkGenerator> getChunkProviderClass() {
        return ChunkProviderXantheon.class;
    }
}

