/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.core.dimensions.worldproviders;

import java.util.LinkedList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeAdaptive;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.client.CloudRenderer;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zollerngalaxy.biomes.providers.BiomeProviderPurgot;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.celestial.ZGPlanet;
import zollerngalaxy.celestial.ZGPlanets;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.dimensions.ZGDimensions;
import zollerngalaxy.core.dimensions.chunkproviders.ChunkProviderPurgot;
import zollerngalaxy.core.dimensions.skyproviders.SkyProviderPurgot;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderPlanetZG;

public class WorldProviderPurgot
extends WorldProviderPlanetZG {
    public float getGravity() {
        return 0.052f;
    }

    @Override
    public double getMeteorFrequency() {
        return ConfigManagerZG.meteorGenPurgot;
    }

    @Override
    public float getSolarSize() {
        return 0.5f;
    }

    @Override
    public double getFuelUsageMultiplier() {
        return 1.4;
    }

    public float getFallDamageModifier() {
        return 0.1f;
    }

    public float getSoundVolReductionAmount() {
        return 1.0f;
    }

    public float getThermalLevelModifier() {
        return -2.2f;
    }

    @Override
    public float getBodyTemp() {
        ZGPlanet planet = this.getPlanet();
        float planetTemp = planet.getBodyTemperature();
        if (!this.isDaytime()) {
            planetTemp /= 1.4f;
        }
        return planetTemp;
    }

    public CelestialBody getCelestialBody() {
        return ZGPlanets.planetPurgot;
    }

    public double getSolarEnergyMultiplier() {
        return 0.95f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        float var2 = this.field_76579_a.func_72826_c(par1);
        float var3 = 1.0f - (MathHelper.func_76134_b((float)(var2 * (float)Math.PI * 2.0f)) * 2.0f + 0.25f);
        if (var3 < 0.0f) {
            var3 = 0.25f;
        }
        if (var3 > 1.0f) {
            var3 = 0.45f;
        }
        return var3 * var3 * 1.0f + 0.6f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float par1) {
        float f1 = this.field_76579_a.func_72826_c(1.0f);
        float f2 = 1.0f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.2f);
        if (f2 < 0.0f) {
            f2 = 0.6f;
        }
        if (f2 > 1.0f) {
            f2 = 0.95f;
        }
        f2 = 0.95f - f2;
        return f2 * 1.4f;
    }

    public double getHorizon() {
        return 44.0;
    }

    public int func_76557_i() {
        return 76;
    }

    @Override
    public Vector3 getSkyColor() {
        float f = 0.6f - this.getStarBrightness(1.0f);
        return new Vector3((double)(1.0f * f), (double)(0.078431375f * f), (double)(1.0f * f));
    }

    @Override
    public Vector3 getFogColor() {
        float f = 1.0f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.78431374f * f), (double)(0.105882354f * f), (double)(0.78431374f * f));
    }

    public boolean canRainOrSnow() {
        return false;
    }

    public boolean hasSunset() {
        return true;
    }

    public long getDayLength() {
        return 22000L;
    }

    public ResourceLocation getDungeonChestType() {
        return null;
    }

    public List<Block> getSurfaceBlocks() {
        LinkedList<Block> list = new LinkedList<Block>();
        list.add(ZGBlocks.purgSurfaceRock);
        list.add(ZGBlocks.purgBlackRock);
        return list;
    }

    @Override
    protected void renderSky() {
        this.setSkyRenderer(new SkyProviderPurgot((IGalacticraftWorldProvider)this));
    }

    @Override
    protected void renderCloud() {
        this.setCloudRenderer((IRenderHandler)new CloudRenderer());
    }

    @Override
    protected void renderWeather() {
    }

    public Class<? extends BiomeProvider> getBiomeProviderClass() {
        BiomeAdaptive.setBodyMultiBiome((CelestialBody)ZGPlanets.planetPurgot);
        return BiomeProviderPurgot.class;
    }

    public DimensionType func_186058_p() {
        return ZGDimensions.PURGOT;
    }

    public double getYCoordinateToTeleport() {
        return 120.0;
    }

    public boolean func_76566_a(int var1, int var2) {
        return true;
    }

    public boolean func_76561_g() {
        return true;
    }

    @Override
    public Class<? extends IChunkGenerator> getChunkProviderClass() {
        return ChunkProviderPurgot.class;
    }
}

