/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.core.dimensions.worldproviders;

import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.event.EventHandlerGC;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zollerngalaxy.celestial.ZGPlanet;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderZG;

public abstract class WorldProviderPlanetZG
extends WorldProviderZG {
    private static WorldProviderPlanetZG instance;

    public WorldProviderPlanetZG() {
        instance = this;
    }

    public static WorldProviderPlanetZG instance() {
        return instance;
    }

    public String getSaveFolder() {
        return "planets/" + this.getPlanet().getName();
    }

    @Override
    public World getWorldObj() {
        return this.field_76579_a;
    }

    @Override
    public boolean shouldForceRespawn() {
        return !ConfigManagerCore.forceOverworldRespawn;
    }

    public ZGPlanet getPlanet() {
        CelestialBody planet = this.getCelestialBody();
        ZGPlanet planetNova = (ZGPlanet)planet;
        return planetNova;
    }

    @Override
    public float getSolarSize() {
        return 1.0f;
    }

    @Override
    public Vector3 getFogColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    public boolean canBlockFreeze(BlockPos pos, boolean byWater) {
        return this.getPlanet().getIsColdBody();
    }

    @Override
    public void updateWeather() {
        World worldObj = this.getWorldObj();
        WorldInfo worldInfo = worldObj.func_72912_H();
        if (!this.shouldDisablePrecipitation()) {
            super.updateWeather();
        } else {
            worldInfo.func_76080_g(0);
            worldInfo.func_76084_b(false);
            worldInfo.func_76090_f(0);
            worldInfo.func_76069_a(false);
            worldObj.field_73004_o = 0.0f;
            worldObj.field_73017_q = 0.0f;
        }
    }

    public float getWindLevel() {
        return this.getPlanet().getWindLevel();
    }

    @Override
    public Vector3 getSkyColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    @Override
    public boolean func_76567_e() {
        if (EventHandlerGC.bedActivated) {
            EventHandlerGC.bedActivated = false;
            return true;
        }
        return false;
    }

    @Override
    public double getFuelUsageMultiplier() {
        return 0.5;
    }

    @Override
    public double getMeteorFrequency() {
        return this.getPlanet().getAtmosphericDensity();
    }

    @Override
    public float getArrowGravity() {
        return 0.003f;
    }

    @Override
    public int getDungeonSpacing() {
        return 704;
    }

    @Override
    public boolean hasBreathableAtmosphere() {
        return this.getPlanet().getIsBreathable();
    }

    @Override
    public boolean canSpaceshipTierPass(int tier) {
        return tier >= this.getPlanet().getTierRequirement();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        if (super.getSkyRenderer() == null) {
            this.renderSky();
        }
        return super.getSkyRenderer();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getCloudRenderer() {
        if (super.getCloudRenderer() == null) {
            this.renderCloud();
        }
        return super.getCloudRenderer();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getWeatherRenderer() {
        if (super.getWeatherRenderer() == null) {
            this.renderWeather();
        }
        return super.getWeatherRenderer();
    }

    @Override
    public boolean func_191066_m() {
        return true;
    }

    @Override
    protected abstract void renderSky();

    @Override
    protected abstract void renderCloud();

    @Override
    protected abstract void renderWeather();

    public float getBodyTemp() {
        ZGPlanet planet = this.getPlanet();
        float planetTemp = planet.getBodyTemperature();
        planetTemp = this.isDaytime() ? (planetTemp /= 2.2f) : planet.getBodyTemperature();
        return planetTemp;
    }

    public float getBodyTemp(World world, BlockPos pos) {
        ZGPlanet planet = this.getPlanet();
        float planetTemp = planet.getBodyTemperature(world, pos);
        planetTemp = this.isDaytime() ? (planetTemp /= 2.2f) : planet.getBodyTemperature(world, pos);
        return planetTemp;
    }

    @Override
    public abstract Class<? extends IChunkGenerator> getChunkProviderClass();
}

