/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.core.dimensions.worldproviders;

import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeAdaptive;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.client.CloudRenderer;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zollerngalaxy.biomes.providers.BiomeProviderCaligro;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.celestial.ZGPlanets;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.dimensions.ZGDimensions;
import zollerngalaxy.core.dimensions.chunkproviders.ChunkProviderCaligro;
import zollerngalaxy.core.dimensions.skyproviders.SkyProviderCaligro;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderPlanetZG;

public class WorldProviderCaligro
extends WorldProviderPlanetZG {
    public float getGravity() {
        return 0.062f;
    }

    @Override
    public float getSolarSize() {
        return 0.12f;
    }

    @Override
    public double getMeteorFrequency() {
        return ConfigManagerZG.meteorGenCaligro;
    }

    @Override
    public double getFuelUsageMultiplier() {
        return 6.5;
    }

    @Override
    public boolean hasBreathableAtmosphere() {
        return true;
    }

    public float getFallDamageModifier() {
        return 0.6f;
    }

    public float getSoundVolReductionAmount() {
        return 2.6f;
    }

    public float getThermalLevelModifier() {
        return -1.2f;
    }

    @Override
    public float getWindLevel() {
        return this.getPlanet().getWindLevel();
    }

    public double getSolarEnergyMultiplier() {
        return 0.03;
    }

    public double getYCoordinateToTeleport() {
        return 82.0;
    }

    public float func_76571_f() {
        return 128.0f;
    }

    @Override
    public Vector3 getFogColor() {
        float f = 1.1f - this.getStarBrightness(0.5f);
        return new Vector3((double)(0.003921569f * f), (double)(0.015686275f * f), (double)(0.003921569f * f));
    }

    @Override
    public Vector3 getSkyColor() {
        float f = 1.15f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.003921569f * f), (double)(0.09411765f * f), (double)(0.003921569f * f));
    }

    public boolean canRainOrSnow() {
        return this.getPlanet().getHasRain();
    }

    public boolean hasSunset() {
        return false;
    }

    public long getDayLength() {
        return 68010L;
    }

    public boolean shouldDisablePrecipitation() {
        return !this.canRainOrSnow();
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        return this.canRainOrSnow();
    }

    @Override
    public boolean func_76567_e() {
        return this.shouldForceRespawn();
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        float f1 = this.field_76579_a.func_72826_c(par1);
        float f2 = 0.5f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.3f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return f2 * f2 * 0.05f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float par1) {
        float f1 = this.field_76579_a.func_72826_c(1.0f);
        float f2 = 0.5f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.2f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        f2 = 1.0f - f2;
        return f2 * 0.1f;
    }

    public double getMovementFactor() {
        return 16.0;
    }

    public CelestialBody getCelestialBody() {
        return ZGPlanets.planetCaligro;
    }

    public float func_76563_a(long par1, float par3) {
        return 0.5f;
    }

    public WorldBorder func_177501_r() {
        return new WorldBorder(){

            public double func_177731_f() {
                return super.func_177731_f() / 8.0;
            }

            public double func_177721_g() {
                return super.func_177721_g() / 8.0;
            }
        };
    }

    protected void func_76556_a() {
        float f = 0.1f;
        for (int i = 0; i <= 15; ++i) {
            float f1 = 1.0f - (float)i / 15.0f;
            this.field_76573_f[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * 0.9f + 0.1f;
        }
    }

    public double getHorizon() {
        return 75.0;
    }

    public int func_76557_i() {
        return 58;
    }

    public boolean func_76566_a(int var1, int var2) {
        return true;
    }

    public ResourceLocation getDungeonChestType() {
        return null;
    }

    public List<Block> getSurfaceBlocks() {
        ArrayList<Block> blockList = new ArrayList<Block>();
        blockList.add(ZGBlocks.caligroSurfaceRock);
        blockList.add(ZGBlocks.caligroDirt);
        return blockList;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void renderSky() {
        this.setSkyRenderer(new SkyProviderCaligro((IGalacticraftWorldProvider)this));
    }

    @Override
    protected void renderCloud() {
        this.setCloudRenderer((IRenderHandler)new CloudRenderer());
    }

    @Override
    protected void renderWeather() {
    }

    public DimensionType func_186058_p() {
        return ZGDimensions.CALIGRO;
    }

    public boolean func_76561_g() {
        return true;
    }

    public Class<? extends BiomeProvider> getBiomeProviderClass() {
        BiomeAdaptive.setBodyMultiBiome((CelestialBody)ZGPlanets.planetCaligro);
        return BiomeProviderCaligro.class;
    }

    @Override
    public Class<? extends IChunkGenerator> getChunkProviderClass() {
        return ChunkProviderCaligro.class;
    }
}

