/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.core.dimensions.chunkproviders;

import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.world.ChunkProviderBase;
import micdoodle8.mods.galacticraft.core.perlin.generator.Gradient;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.world.gen.EnumCraterSize;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.NoiseGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import zollerngalaxy.biomes.decorators.BiomeDecoratorCaligro;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.blocks.fluids.ZGFluids;
import zollerngalaxy.lib.helpers.ZGHelper;
import zollerngalaxy.util.BiomeUtils;
import zollerngalaxy.worldgen.mapgen.MapGenCavesZG;
import zollerngalaxy.worldgen.mapgen.MapGenRavinesZG;
import zollerngalaxy.worldgen.structures.villages.MapGenVillageZG;

public class ChunkProviderCaligro
extends ChunkProviderBase {
    public static final IBlockState STONE = ZGBlocks.caligroStone.func_176223_P();
    public static final IBlockState CORRUPT_STONE = ZGBlocks.corruptStone.func_176223_P();
    public static final IBlockState CHARGIUM = ZGFluids.blockChargiumFluid.func_176223_P();
    public static final double CHUNK_HEIGHT = 40.5;
    public static final int SEA_LEVEL = 57;
    public static int CORRUPTION_LAYER = ZGHelper.rngInt(25, 32);
    private static final int CHUNK_SIZE_X = 16;
    private static final int CHUNK_SIZE_Z = 16;
    private final BiomeDecoratorCaligro biomeDecoratorCaligro = new BiomeDecoratorCaligro();
    private Random rand;
    private NoiseGeneratorOctaves noiseGen1;
    private NoiseGeneratorOctaves noiseGen2;
    private NoiseGeneratorOctaves noiseGen3;
    private NoiseGeneratorPerlin noiseGen4;
    private NoiseGeneratorOctaves noiseGen5;
    private NoiseGeneratorOctaves noiseGen6;
    private NoiseGeneratorOctaves mobSpawnerNoise;
    private final Gradient noiseGenSmooth1;
    private World world;
    private WorldType worldType;
    private final double[] terrainCalcs;
    private final float[] parabolicField;
    private double[] stoneNoise = new double[256];
    private MapGenCavesZG caveGenerator = new MapGenCavesZG(ZGBlocks.caligroStone, (Block)ZGFluids.blockChargiumFluid);
    private MapGenCavesZG caveGenerator2 = new MapGenCavesZG(ZGBlocks.caligroStone, (Block)ZGFluids.blockChargiumFluid);
    private MapGenCavesZG caveGenerator3 = new MapGenCavesZG(ZGBlocks.corruptStone, (Block)ZGFluids.blockChargiumFluid);
    private final MapGenRavinesZG ravineGenerator = new MapGenRavinesZG(ZGBlocks.caligroStone);
    private final MapGenRavinesZG ravineGenerator2 = new MapGenRavinesZG(ZGBlocks.corruptStone);
    private final MapGenVillageZG villageGenerator = new MapGenVillageZG("Caligro", ZGBlocks.caligroCobblestone);
    private MapGenMineshaft mineshaftGenerator = new MapGenMineshaft();
    private Biome[] biomesForGeneration;
    private double[] octaves1;
    private double[] octaves2;
    private double[] octaves3;
    private double[] octaves4;
    private static final int CRATER_PROB = 20;
    public static ChunkProviderCaligro INSTANCE;

    public ChunkProviderCaligro(World worldIn, long seed, boolean mapFeaturesEnabled) {
        this.world = worldIn;
        this.worldType = worldIn.func_72912_H().func_76067_t();
        this.rand = new Random(seed);
        this.noiseGen1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(this.rand, 8);
        this.noiseGen4 = new NoiseGeneratorPerlin(this.rand, 4);
        this.noiseGen5 = new NoiseGeneratorOctaves(this.rand, 10);
        this.noiseGen6 = new NoiseGeneratorOctaves(this.rand, 16);
        this.mobSpawnerNoise = new NoiseGeneratorOctaves(this.rand, 8);
        this.noiseGenSmooth1 = new Gradient(this.rand.nextLong(), 4, 0.25f);
        this.terrainCalcs = new double[825];
        this.parabolicField = new float[25];
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                float f;
                this.parabolicField[i + 2 + (j + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(i * i + j * j) + 0.2f));
            }
        }
        NoiseGenerator[] noiseGens = new NoiseGenerator[]{this.noiseGen1, this.noiseGen2, this.noiseGen3, this.noiseGen4, this.noiseGen5, this.noiseGen6, this.mobSpawnerNoise};
        this.noiseGen1 = (NoiseGeneratorOctaves)noiseGens[0];
        this.noiseGen2 = (NoiseGeneratorOctaves)noiseGens[1];
        this.noiseGen3 = (NoiseGeneratorOctaves)noiseGens[2];
        this.noiseGen4 = (NoiseGeneratorPerlin)noiseGens[3];
        this.noiseGen5 = (NoiseGeneratorOctaves)noiseGens[4];
        this.noiseGen6 = (NoiseGeneratorOctaves)noiseGens[5];
        this.mobSpawnerNoise = (NoiseGeneratorOctaves)noiseGens[6];
        INSTANCE = this;
    }

    private void setBlocksInChunk(int chunkX, int chunkZ, ChunkPrimer primer) {
        this.noiseGenSmooth1.setFrequency(0.015f);
        this.biomesForGeneration = this.world.func_72959_q().func_76937_a(this.biomesForGeneration, chunkX * 4 - 2, chunkZ * 4 - 2, 10, 10);
        this.createLandPerBiome(chunkX * 4, chunkZ * 4);
        for (int i = 0; i < 4; ++i) {
            int j = i * 5;
            int k = (i + 1) * 5;
            for (int l = 0; l < 4; ++l) {
                int i1 = (j + l) * 33;
                int j1 = (j + l + 1) * 33;
                int k1 = (k + l) * 33;
                int l1 = (k + l + 1) * 33;
                for (int i2 = 0; i2 < 32; ++i2) {
                    double d0 = 0.125;
                    double d1 = this.terrainCalcs[i1 + i2];
                    double d2 = this.terrainCalcs[j1 + i2];
                    double d3 = this.terrainCalcs[k1 + i2];
                    double d4 = this.terrainCalcs[l1 + i2];
                    double d5 = (this.terrainCalcs[i1 + i2 + 1] - d1) * d0;
                    double d6 = (this.terrainCalcs[j1 + i2 + 1] - d2) * d0;
                    double d7 = (this.terrainCalcs[k1 + i2 + 1] - d3) * d0;
                    double d8 = (this.terrainCalcs[l1 + i2 + 1] - d4) * d0;
                    for (int j2 = 0; j2 < 8; ++j2) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int k2 = 0; k2 < 4; ++k2) {
                            double d14 = 0.25;
                            double d16 = (d11 - d10) * d14;
                            double lvt_45_1_ = d10 - d16;
                            for (int l2 = 0; l2 < 4; ++l2) {
                                double d;
                                int x = i * 4 + k2;
                                int y = i2 * 8 + j2;
                                int z = l * 4 + l2;
                                float noiseVal = this.noiseGenSmooth1.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z));
                                lvt_45_1_ += d16;
                                if (d > (double)noiseVal * 40.5) {
                                    primer.func_177855_a(x, y, z, STONE);
                                } else if (y < 57) {
                                    Biome biome = this.world.func_180494_b(new BlockPos(x, y, z));
                                    IBlockState blockToUse = CHARGIUM;
                                    primer.func_177855_a(x, y, z, blockToUse);
                                }
                                if (y > CORRUPTION_LAYER || y <= 0) continue;
                                primer.func_177855_a(x, y, z, CORRUPT_STONE);
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    private void replaceBlocksForBiome(int p_180517_1_, int p_180517_2_, ChunkPrimer p_180517_3_, Biome[] p_180517_4_) {
        double d0 = 0.03125;
        this.stoneNoise = this.noiseGen4.func_151599_a(this.stoneNoise, (double)(p_180517_1_ * 16), (double)(p_180517_2_ * 16), 16, 16, d0 * 2.0, d0 * 2.0, 1.0);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                Biome biomegenbase = p_180517_4_[j + i * 16];
                biomegenbase.func_180622_a(this.world, this.rand, p_180517_3_, p_180517_1_ * 16 + i, p_180517_2_ * 16 + j, this.stoneNoise[j + i * 16]);
            }
        }
    }

    public Chunk func_185932_a(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.setBlocksInChunk(x, z, chunkprimer);
        this.biomesForGeneration = this.world.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.replaceBlocksForBiome(x, z, chunkprimer, this.biomesForGeneration);
        this.caveGenerator.func_186125_a(this.world, x, z, chunkprimer);
        this.caveGenerator2.func_186125_a(this.world, x, z, chunkprimer);
        this.caveGenerator3.func_186125_a(this.world, x, z, chunkprimer);
        this.ravineGenerator.func_186125_a(this.world, x, z, chunkprimer);
        this.ravineGenerator2.func_186125_a(this.world, x, z, chunkprimer);
        this.mineshaftGenerator.func_186125_a(this.world, x, z, chunkprimer);
        Chunk chunk = new Chunk(this.world, chunkprimer, x, z);
        byte[] abyte = chunk.func_76605_m();
        for (int i = 0; i < abyte.length; ++i) {
            abyte[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    private void createLandPerBiome(int x, int z) {
        this.octaves4 = this.noiseGen6.func_76305_a(this.octaves4, x, z, 5, 5, 2000.0, 2000.0, 0.5);
        this.octaves1 = this.noiseGen3.func_76304_a(this.octaves1, x, 0, z, 5, 33, 5, 8.555150000000001, 4.277575000000001, 8.555150000000001);
        this.octaves2 = this.noiseGen1.func_76304_a(this.octaves2, x, 0, z, 5, 33, 5, 684.412, 684.412, 684.412);
        this.octaves3 = this.noiseGen2.func_76304_a(this.octaves3, x, 0, z, 5, 33, 5, 684.412, 684.412, 684.412);
        int i = 0;
        int j = 0;
        for (int k = 0; k < 5; ++k) {
            for (int l = 0; l < 5; ++l) {
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = 0.0f;
                int i1 = 2;
                Biome biomegenbase = this.biomesForGeneration[k + 2 + (l + 2) * 10];
                for (int j1 = -i1; j1 <= i1; ++j1) {
                    for (int k1 = -i1; k1 <= i1; ++k1) {
                        Biome biomegenbase1 = this.biomesForGeneration[k + j1 + 2 + (l + k1 + 2) * 10];
                        float f5 = biomegenbase1.func_185355_j();
                        float f6 = biomegenbase1.func_185360_m();
                        if (this.worldType == WorldType.field_151360_e && f5 > 0.0f) {
                            f5 = 1.0f + f5 * 2.0f;
                            f6 = 1.0f + f6 * 4.0f;
                        }
                        float f7 = this.parabolicField[j1 + 2 + (k1 + 2) * 5] / (f5 + 2.0f);
                        f2 += f6 * f7;
                        f3 += f5 * f7;
                        f4 += f7;
                    }
                }
                f2 /= f4;
                f3 /= f4;
                f2 = f2 * 0.9f + 0.1f;
                f3 = (f3 * 4.0f - 1.0f) / 8.0f;
                double d7 = this.octaves4[j] / 4000.0;
                if (d7 < 0.0) {
                    d7 = -d7 * 0.3;
                }
                if ((d7 = d7 * 3.0 - 2.0) < 0.0) {
                    if ((d7 /= 2.0) < -1.0) {
                        d7 = -1.0;
                    }
                    d7 /= 1.4;
                    d7 /= 2.0;
                } else {
                    if (d7 > 1.0) {
                        d7 = 1.0;
                    }
                    d7 /= 8.0;
                }
                ++j;
                double d8 = f3;
                double d9 = f2;
                d8 += d7 * 0.2;
                d8 = d8 * 8.5 / 8.0;
                double d0 = 8.5 + d8 * 4.0;
                for (int l1 = 0; l1 < 33; ++l1) {
                    double d1 = ((double)l1 - d0) * 12.0 * 128.0 / 256.0 / d9;
                    if (d1 < 0.0) {
                        d1 *= 4.0;
                    }
                    double d2 = this.octaves2[i] / 512.0;
                    double d3 = this.octaves3[i] / 1024.0;
                    double d4 = (this.octaves1[i] / 10.0 + 1.0) / 2.0;
                    double d5 = MathHelper.func_151238_b((double)d2, (double)d3, (double)d4) - d1;
                    if (l1 > 29) {
                        double d6 = (float)(l1 - 29) / 3.0f;
                        d5 = d5 * (1.0 - d6) + -10.0 * d6;
                    }
                    this.terrainCalcs[i] = d5;
                    ++i;
                }
            }
        }
    }

    public void createCraters(int chunkX, int chunkZ, ChunkPrimer primer) {
        for (int cx = chunkX - 2; cx <= chunkX + 2; ++cx) {
            for (int cz = chunkZ - 2; cz <= chunkZ + 2; ++cz) {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        if (!(Math.abs(this.randFromPoint(cx * 16 + x, (cz * 16 + z) * 1000)) < this.noiseGen4.func_151601_a((double)(x * 16 + x), (double)(cz * 16 + z)) / 20.0)) continue;
                        Random random = new Random(cx * 16 + x + (cz * 16 + z) * 5000);
                        EnumCraterSize cSize = EnumCraterSize.sizeArray[random.nextInt(EnumCraterSize.sizeArray.length)];
                        int size = random.nextInt(cSize.MAX_SIZE - cSize.MIN_SIZE) + cSize.MIN_SIZE;
                        this.makeCrater(cx * 16 + x, cz * 16 + z, chunkX * 16, chunkZ * 16, size, primer);
                    }
                }
            }
        }
    }

    private void makeCrater(int craterX, int craterZ, int chunkX, int chunkZ, int size, ChunkPrimer primer) {
        for (int x = 0; x < 16; ++x) {
            block1: for (int z = 0; z < 16; ++z) {
                double xDev = craterX - (chunkX + x);
                double zDev = craterZ - (chunkZ + z);
                if (!(xDev * xDev + zDev * zDev < (double)(size * size))) continue;
                double sqrtY = (xDev /= (double)size) * xDev + (zDev /= (double)size) * zDev;
                double yDev = sqrtY * sqrtY * 6.0;
                yDev = 5.0 - yDev;
                int helper = 0;
                for (int y = 127; y > 0; --y) {
                    if (Blocks.field_150350_a != primer.func_177856_a(x, y, z).func_177230_c() && (double)helper <= yDev) {
                        primer.func_177855_a(x, y, z, Blocks.field_150350_a.func_176223_P());
                        ++helper;
                    }
                    if ((double)helper > yDev) continue block1;
                }
            }
        }
    }

    private double randFromPoint(int x, int z) {
        int n = x + z * 57;
        n = n << 13 ^ n;
        return 1.0 - (double)(n * (n * n * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE) / 1.073741824E9;
    }

    public void func_185931_b(int x, int z) {
        BlockFalling.field_149832_M = true;
        int i = x * 16;
        int j = z * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        Biome biomegenbase = this.world.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.world.func_72905_C());
        long k = this.rand.nextLong() / 2L * 2L + 1L;
        long l = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)x * k + (long)z * l ^ this.world.func_72905_C());
        if (!ConfigManagerCore.disableMoonVillageGen && !BiomeUtils.isOceanBiome(biomegenbase)) {
            this.villageGenerator.func_175794_a(this.world, this.rand, new ChunkPos(x, z));
        }
        this.mineshaftGenerator.func_175794_a(this.world, this.rand, new ChunkPos(x, z));
        biomegenbase.func_180624_a(this.world, this.rand, new BlockPos(i, 0, j));
        WorldEntitySpawner.func_77191_a((World)this.world, (Biome)biomegenbase, (int)(i + 8), (int)(j + 8), (int)16, (int)16, (Random)this.rand);
        BlockFalling.field_149832_M = false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biomegenbase = this.world.func_180494_b(pos);
        return biomegenbase.func_76747_a(creatureType);
    }

    public void func_180514_a(Chunk chunk, int x, int z) {
        this.mineshaftGenerator.func_186125_a(this.world, x, z, null);
        Biome biome = chunk.func_177412_p().func_180494_b(new BlockPos(x, 0, z));
        if (!ConfigManagerCore.disableMoonVillageGen && !BiomeUtils.isOceanBiome(biome)) {
            this.villageGenerator.func_186125_a(this.world, x, z, null);
        }
    }
}

