/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.compat;

import net.minecraftforge.fluids.Fluid;
import slimeknights.tconstruct.library.MaterialIntegration;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.ArrowShaftMaterialStats;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.materials.ProjectileMaterialStats;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.traits.ITrait;
import zollerngalaxy.compat.tconstruct.TCSmelteryManager;
import zollerngalaxy.compat.tconstruct.traits.TraitCorrupted;
import zollerngalaxy.compat.tconstruct.traits.TraitEnlightened;
import zollerngalaxy.compat.tconstruct.traits.TraitInfection;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.lib.helpers.ZGHelper;

public class TinkersConstructCompat {
    public static int totalMaterials;
    public static TraitInfection traitInfection;
    public static TraitEnlightened traitRadiance;
    public static TraitCorrupted traitCorrupted;
    public static Material materialRadium;
    public static Material materialCorruption;
    public static Material materialInfection;

    public static void init() {
        if (ConfigManagerZG.useTConRadium) {
            TinkersConstructCompat.registerMaterials(materialRadium, "Radium");
        }
        if (ConfigManagerZG.useTConCorruption) {
            TinkersConstructCompat.registerMaterials(materialCorruption, "Corruption");
        }
        TCSmelteryManager.init();
        ZGHelper.Log("Loaded a total of " + totalMaterials + " new Tinker's Construct materials.");
        ZGHelper.Log("Initialized IMC with Tinker's Construct.");
    }

    private static void registerModifier(IModifier ... mod) {
        for (IModifier i : mod) {
            TinkersConstructCompat.registerModifier(i);
        }
    }

    private static void registerMaterials(Material Material2, String suffix) {
        TinkersConstructCompat.addMaterial(Material2, Material2.getFluid(), suffix);
    }

    public static void registerMaterial(Material material, Fluid fluid, String suffix) {
        if (fluid != null) {
            TinkersConstructCompat.integrate(material, fluid, suffix);
        } else {
            TinkerRegistry.addMaterial((Material)material);
        }
    }

    public static void registerModifier(IModifier modifier) {
        TinkerRegistry.registerModifier((IModifier)modifier);
    }

    private static MaterialIntegration add(MaterialIntegration integration) {
        return TinkerRegistry.integrate((MaterialIntegration)integration);
    }

    private static MaterialIntegration integrate(Material material, Fluid fluid, String suffix) {
        return TinkersConstructCompat.add(new MaterialIntegration(material, fluid, suffix));
    }

    private static void addMaterial(Material material, Fluid fluid, String suffix) {
        TinkersConstructCompat.registerMaterial(material, fluid, suffix);
        ++totalMaterials;
    }

    static {
        traitInfection = new TraitInfection();
        traitRadiance = new TraitEnlightened();
        traitCorrupted = new TraitCorrupted();
        materialRadium = new Material("materialRadium".toLowerCase(), 0xFFFF00);
        materialCorruption = new Material("materialCorruption".toLowerCase(), 0x8B008B);
        materialInfection = new Material("materialInfection".toLowerCase(), 0);
        if (ConfigManagerZG.useTConRadium) {
            materialRadium.addItem("oreRadium", 1, Material.VALUE_Ore());
            materialRadium.addCommonItems("Radium");
            materialRadium.setCastable(true);
            materialRadium.setCraftable(true);
            materialRadium.setRepresentativeItem("gemRadium");
            materialRadium.addTrait((ITrait)traitRadiance);
            materialRadium.addStats((IMaterialStats)new HeadMaterialStats(180, 16.0f, 26.0f, 8));
            materialRadium.addStats((IMaterialStats)new HandleMaterialStats(8.0f, 80));
            materialRadium.addStats((IMaterialStats)new ExtraMaterialStats(80));
            materialRadium.addStats((IMaterialStats)new BowMaterialStats(28.0f, 8.0f, 14.0f));
            materialRadium.addStats((IMaterialStats)new ArrowShaftMaterialStats(15.0f, 45));
            materialRadium.addStats((IMaterialStats)new ProjectileMaterialStats());
        }
        if (ConfigManagerZG.useTConCorruption) {
            materialCorruption.addItem("oreAscendium", 1, Material.VALUE_Ore());
            materialCorruption.addCommonItems("Corruption");
            materialCorruption.setCastable(true);
            materialCorruption.setCraftable(true);
            materialCorruption.setRepresentativeItem("gemAscendium");
            materialCorruption.addTrait((ITrait)traitCorrupted);
            materialCorruption.addStats((IMaterialStats)new HeadMaterialStats(90, 8.0f, 16.0f, 8));
            materialCorruption.addStats((IMaterialStats)new HandleMaterialStats(10.0f, 90));
            materialCorruption.addStats((IMaterialStats)new ExtraMaterialStats(90));
            materialCorruption.addStats((IMaterialStats)new BowMaterialStats(27.0f, 8.0f, 11.0f));
            materialCorruption.addStats((IMaterialStats)new ArrowShaftMaterialStats(9.0f, 26));
            materialCorruption.addStats((IMaterialStats)new ProjectileMaterialStats());
        }
    }
}

