/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.celestial;

import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.EnumAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import net.minecraft.world.biome.Biome;
import zollerngalaxy.biomes.ZGBiomes;
import zollerngalaxy.celestial.Galaxy;
import zollerngalaxy.celestial.GalaxyListZG;
import zollerngalaxy.celestial.ZGMoon;
import zollerngalaxy.celestial.ZGPlanet;
import zollerngalaxy.celestial.starsystems.ZGStar;
import zollerngalaxy.celestial.starsystems.ZGStarSystem;
import zollerngalaxy.celestial.teleporttypes.TeleportTypeBaseZG;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderAltum;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderAstros;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderAtheon;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderCaligro;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderCandora;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderCentotl;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderEden;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderExodus;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderKriffon;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderKronos;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderMaveth;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderMetztli;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderOasis;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderPerdita;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderPurgot;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderTlaloc;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderToci;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderVortex;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderXantheon;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderXathius;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderZollus;
import zollerngalaxy.core.enums.EnumBodyClass;
import zollerngalaxy.lib.helpers.ModHelperBase;
import zollerngalaxy.lib.helpers.ZGHelper;

public class ZGPlanets {
    protected boolean enableExtremeMode = ConfigManagerZG.enableExtremeMode;
    protected static boolean enableExtraGalaxies = ConfigManagerZG.enableExtraPlanetsCompat && ModHelperBase.useExtraPlanets;
    private static int totalSystems = 0;
    private static int totalPlanets = 0;
    private static int totalMoons = 0;
    private static float PSIOS_X = -2.0f + ConfigManagerZG.psiosXOffset;
    private static float PSIOS_Y = 0.5f + ConfigManagerZG.psiosYOffset;
    private static float PSIOS_Z = 0.0f + ConfigManagerZG.psiosZOffset;
    private static float PRAEDYTH_X = -1.2f + ConfigManagerZG.praedythXOffset;
    private static float PRAEDYTH_Y = 1.6f + ConfigManagerZG.praedythYOffset;
    private static float PRAEDYTH_Z = 0.0f + ConfigManagerZG.praedythZOffset;
    private static float SOL2_X = 1.2f + ConfigManagerZG.sol2XOffset;
    private static float SOL2_Y = -1.2f + ConfigManagerZG.sol2YOffset;
    private static float SOL2_Z = 0.0f + ConfigManagerZG.sol2ZOffset;
    private static float PANTHEON_X = 2.5f + ConfigManagerZG.pantheonXOffset;
    private static float PANTHEON_Y = 0.8f + ConfigManagerZG.pantheonYOffset;
    private static float PANTHEON_Z = 0.0f + ConfigManagerZG.pantheonZOffset;
    private static float OLYMPUS_X = (float)((enableExtraGalaxies ? 0.0 : 1.8) + (double)ConfigManagerZG.olympusXOffset);
    private static float OLYMPUS_Y = (float)((enableExtraGalaxies ? 0.0 : 2.1) + (double)ConfigManagerZG.olympusYOffset);
    private static float OLYMPUS_Z = 0.0f + ConfigManagerZG.olympusZOffset;
    private static float ASGARD_X = -0.2f + ConfigManagerZG.asgardXOffset;
    private static float ASGARD_Y = -1.6f + ConfigManagerZG.asgardYOffset;
    private static float ASGARD_Z = 0.0f + ConfigManagerZG.asgardZOffset;
    private static float VEGA_X = 0.5f + ConfigManagerZG.vegaXOffset;
    private static float VEGA_Y = 2.2f + ConfigManagerZG.vegaYOffset;
    private static float VEGA_Z = 0.0f + ConfigManagerZG.vegaZOffset;
    private static float NOVA_X = (float)((enableExtraGalaxies ? 0.0 : -1.6) + (double)ConfigManagerZG.novaXOffset);
    private static float NOVA_Y = (float)((enableExtraGalaxies ? 0.0 : 2.0) + (double)ConfigManagerZG.novaYOffset);
    private static float NOVA_Z = 0.0f + ConfigManagerZG.novaZOffset;
    private static boolean hideUnusedStarSystems = ConfigManagerZG.hideUnusedStarSystems;
    public static Galaxy gxMilkyWay = GalaxyListZG.MILKY_WAY;
    public static Galaxy gxEissentam = GalaxyListZG.EISSENTAM;
    public static Galaxy gxEuclid = GalaxyListZG.EUCLID;
    public static ZGStarSystem systemPsios = new ZGStarSystem("psion6");
    public static ZGStarSystem systemPraedyth = new ZGStarSystem("praedyth");
    public static ZGStarSystem systemSol2 = new ZGStarSystem("sol2");
    public static ZGStarSystem systemPantheon = new ZGStarSystem("pantheon");
    public static ZGStarSystem systemOlympus = new ZGStarSystem("olympus");
    public static ZGStarSystem systemAsgard = new ZGStarSystem("asgard");
    public static ZGStarSystem systemVega = new ZGStarSystem("vega");
    public static ZGStarSystem systemNova = new ZGStarSystem("nova");
    public static ZGStar starPsios = new ZGStar("psion6");
    public static ZGStar starPraedyth = new ZGStar("praedyth");
    public static ZGStar starSol2 = new ZGStar("sol2");
    public static ZGStar starPantheon = new ZGStar("pantheon");
    public static ZGStar starOlympus = new ZGStar("olympus");
    public static ZGStar starAsgard = new ZGStar("asgard", "asgard_star");
    public static ZGStar starVega = new ZGStar("vega");
    public static ZGStar starNova = new ZGStar("nova");
    public static ZGPlanet planetZollus = new ZGPlanet("zollus");
    public static ZGPlanet planetKriffon = new ZGPlanet("kriffus");
    public static ZGPlanet planetPurgot = new ZGPlanet("purgot");
    public static ZGPlanet planetEden = new ZGPlanet("eden");
    public static ZGMoon moonAstros = new ZGMoon("astros");
    public static ZGPlanet planetXathius = new ZGPlanet("xathius");
    public static ZGPlanet planetOasis = new ZGPlanet("oasis");
    public static ZGPlanet planetXantheon = new ZGPlanet("xantheon");
    public static ZGPlanet planetCandora = new ZGPlanet("candora");
    public static ZGPlanet planetAtheon = new ZGPlanet("atheon");
    public static ZGPlanet planetPerdita = new ZGPlanet("perdita");
    public static ZGPlanet planetAltum = new ZGPlanet("altum");
    public static ZGPlanet planetCaligro = new ZGPlanet("caligro");
    public static ZGPlanet planetExodus = new ZGPlanet("exodus");
    public static ZGPlanet planetVortex = new ZGPlanet("vortex");
    public static ZGPlanet planetMetztli = new ZGPlanet("metztli");
    public static ZGPlanet planetCentotl = new ZGPlanet("centotl");
    public static ZGPlanet planetToci = new ZGPlanet("toci");
    public static ZGPlanet planetTlaloc = new ZGPlanet("tlaloc");
    public static ZGPlanet planetAres = new ZGPlanet("ares");
    public static ZGPlanet planetPrometheus = new ZGPlanet("prometheus");
    public static ZGPlanet planetIcarus = new ZGPlanet("icarus");
    public static ZGPlanet planetKronos = new ZGPlanet("kronos");
    public static ZGPlanet planetMaveth = new ZGPlanet("maveth");
    public static ZGPlanet planetAsgard = new ZGPlanet("asgard");
    public static ZGPlanet planetReach = new ZGPlanet("reach");
    public static ZGPlanet planetRequiem = new ZGPlanet("requiem");
    public static ZGPlanet planetMeridian = new ZGPlanet("meridian");
    public static ZGPlanet planetSomnium = new ZGPlanet("somnium");
    public static ZGPlanet planetPrimor = new ZGPlanet("primor");

    public static void init() {
        ZGPlanets.initStarSystems();
        ZGPlanets.initPlanets();
        ZGPlanets.initMoons();
        ZGPlanets.registerSystems();
        ZGPlanets.registerTeleportTypes();
    }

    public static void initStarSystems() {
        systemPsios.setMapPosition(new Vector3((double)PSIOS_X, (double)PSIOS_Y, (double)PSIOS_Z));
        systemPsios.setMainStar(starPsios);
        starPsios.setParentSolarSystem(systemPsios);
        ++totalSystems;
        systemPraedyth.setMapPosition(new Vector3((double)PRAEDYTH_X, (double)PRAEDYTH_Y, (double)PRAEDYTH_Z));
        starPraedyth.setParentSolarSystem(systemPraedyth);
        systemPraedyth.setMainStar(starPraedyth);
        ++totalSystems;
        systemSol2.setMapPosition(new Vector3((double)SOL2_X, (double)SOL2_Y, (double)SOL2_Z));
        starSol2.setParentSolarSystem(systemSol2);
        systemSol2.setMainStar(starSol2);
        ++totalSystems;
        systemPantheon.setMapPosition(new Vector3((double)PANTHEON_X, (double)PANTHEON_Y, (double)PANTHEON_Z));
        starPantheon.setParentSolarSystem(systemPantheon);
        systemPantheon.setMainStar(starPantheon);
        ++totalSystems;
        systemOlympus.setMapPosition(new Vector3((double)OLYMPUS_X, (double)OLYMPUS_Y, (double)OLYMPUS_Z));
        if (enableExtraGalaxies) {
            systemOlympus.setGalaxy(gxEissentam);
        }
        starOlympus.setParentSolarSystem(systemOlympus);
        systemOlympus.setMainStar(starOlympus);
        ++totalSystems;
        systemAsgard.setMapPosition(new Vector3((double)ASGARD_X, (double)ASGARD_Y, (double)ASGARD_Z));
        if (enableExtraGalaxies) {
            systemAsgard.setGalaxy(gxEissentam);
        }
        starAsgard.setParentSolarSystem(systemAsgard);
        systemAsgard.setMainStar(starAsgard);
        ++totalSystems;
        systemVega.setMapPosition(new Vector3((double)VEGA_X, (double)VEGA_Y, (double)VEGA_Z));
        if (enableExtraGalaxies) {
            systemVega.setGalaxy(gxEissentam);
        }
        starVega.setParentSolarSystem(systemVega);
        systemVega.setMainStar(starVega);
        ++totalSystems;
        systemNova.setMapPosition(new Vector3((double)NOVA_X, (double)NOVA_Y, (double)NOVA_Z));
        if (enableExtraGalaxies) {
            systemNova.setGalaxy(gxEuclid);
        }
        starNova.setParentSolarSystem(systemNova);
        systemNova.setMainStar(starNova);
        ZGHelper.Log("Loaded a total of " + ++totalSystems + " new star systems.");
    }

    public static void initPlanets() {
        planetZollus.setDimensionInfo(ConfigManagerZG.planetZollusDimensionId, WorldProviderZollus.class);
        planetZollus.setParentSolarSystem(systemPsios);
        planetZollus.setPhaseShift(2.0f);
        planetZollus.setDistanceFromCenter(2.0f);
        planetZollus.setBodyClass(EnumBodyClass.L);
        planetZollus.setRelativeOrbitTime(32.2f);
        planetZollus.setTierRequired(ConfigManagerZG.planetZollusTier);
        if (ConfigManagerZG.planetUnreachableZollus) {
            planetZollus.setDisableRockets();
        }
        planetZollus.setBodyTemperature(-92.6f);
        planetZollus.setBodyToxicity(0.4f);
        planetZollus.setBodyRadiation(0.5f);
        planetZollus.setWindLevel(6.7f);
        planetZollus.setDensity(0.1f);
        planetZollus.setHasRain(false);
        planetZollus.setBodyGasses(EnumAtmosphericGas.NITROGEN, EnumAtmosphericGas.HELIUM);
        planetZollus.setAtmosphere();
        planetZollus.setBodyIcon("zollus");
        planetZollus.setBiomeInfo(new Biome[]{ZGBiomes.ZOLLUS, ZGBiomes.ZOLLUS_OCEAN});
        ++totalPlanets;
        planetKriffon.setDimensionInfo(ConfigManagerZG.planetKriffonDimensionId, WorldProviderKriffon.class);
        planetKriffon.setParentSolarSystem(systemPsios);
        planetKriffon.setPhaseShift(0.0f);
        planetKriffon.setBodyClass(EnumBodyClass.Y);
        planetKriffon.setRelativeOrbitTime(0.3f);
        planetKriffon.setDistanceFromCenter(0.5f);
        planetKriffon.setTierRequired(ConfigManagerZG.planetKriffonTier);
        if (ConfigManagerZG.planetUnreachableAll || ConfigManagerZG.planetUnreachableKriffon) {
            planetKriffon.setDisableRockets();
        }
        planetKriffon.setBodyTemperature(107.4f);
        planetKriffon.setBodyToxicity(14.1f);
        planetKriffon.setBodyRadiation(16.8f);
        planetKriffon.setWindLevel(0.1f);
        planetKriffon.setDensity(3.0f);
        planetKriffon.setHasRain(false);
        planetKriffon.setBodyGasses(EnumAtmosphericGas.ARGON, EnumAtmosphericGas.METHANE, EnumAtmosphericGas.OXYGEN);
        planetKriffon.setAtmosphere();
        planetKriffon.setBodyIcon("kriffus");
        planetKriffon.setBiomeInfo(new Biome[]{ZGBiomes.KRIFFON, ZGBiomes.KRIFFON_LAVA_OCEAN});
        ++totalPlanets;
        planetPurgot.setParentSolarSystem(systemPsios);
        planetPurgot.setBodyClass(EnumBodyClass.NINE);
        planetPurgot.setPhaseShift(1.5f);
        planetPurgot.setRelativeOrbitTime(10.0f);
        planetPurgot.setDistanceFromCenter(1.5f);
        planetPurgot.setTierRequired(ConfigManagerZG.planetPurgotTier);
        if (ConfigManagerZG.planetUnreachableAll || ConfigManagerZG.planetUnreachablePurgot) {
            planetPurgot.setDisableRockets();
        }
        planetPurgot.setBodyTemperature(-54.5f);
        planetPurgot.setBodyToxicity(15.2f);
        planetPurgot.setBodyRadiation(2.2f);
        planetPurgot.setWindLevel(5.7f);
        planetPurgot.setDensity(0.3f);
        planetPurgot.setHasRain(false);
        planetPurgot.setBodyGasses(EnumAtmosphericGas.OXYGEN, EnumAtmosphericGas.WATER, EnumAtmosphericGas.NITROGEN, EnumAtmosphericGas.ARGON);
        planetPurgot.setBodyIcon("purgot");
        planetPurgot.setAtmosphere();
        planetPurgot.setBiomeInfo(new Biome[]{ZGBiomes.PURGOT_BASE, ZGBiomes.PURGOT_LIMBO});
        planetPurgot.addChecklistKeys(new String[]{"equipOxygenSuit"});
        planetPurgot.setDimensionInfo(ConfigManagerZG.planetPurgotDimensionId, WorldProviderPurgot.class);
        ++totalPlanets;
        planetEden.setDimensionInfo(ConfigManagerZG.planetEdenDimensionId, WorldProviderEden.class);
        planetEden.setParentSolarSystem(systemPsios);
        planetEden.setPhaseShift(1.0f);
        planetEden.setBodyClass(EnumBodyClass.M);
        planetEden.setRelativeOrbitTime(8.0f);
        planetEden.setDistanceFromCenter(1.0f);
        planetEden.setTierRequired(ConfigManagerZG.planetEdenTier);
        if (ConfigManagerZG.planetUnreachableAll || ConfigManagerZG.planetUnreachableEden) {
            planetEden.setDisableRockets();
        }
        planetEden.setBodyTemperature(95.42f);
        planetEden.setBodyToxicity(0.0f);
        planetEden.setBodyRadiation(0.0f);
        planetEden.setBreathable(true);
        planetEden.setWindLevel(0.8f);
        planetEden.setDensity(1.0f);
        planetEden.setHasRain(true);
        planetEden.setBodyGasses(EnumAtmosphericGas.NITROGEN, EnumAtmosphericGas.OXYGEN, EnumAtmosphericGas.ARGON, EnumAtmosphericGas.WATER, EnumAtmosphericGas.CO2);
        planetEden.setAtmosphere();
        planetEden.setBodyIcon("eden");
        planetEden.setBiomeInfo(new Biome[]{ZGBiomes.EDEN_GREEN_LANDS, ZGBiomes.EDEN_BLOOD_DESERT, ZGBiomes.EDEN_ROCK_MOUNTAINS, ZGBiomes.EDEN_TERRAN_VALLEY, ZGBiomes.EDEN_SNOWY_PLAINS, ZGBiomes.EDEN_GOLDEN_MEADOW, ZGBiomes.EDEN_SWAMPLANDS, ZGBiomes.EDENWOOD_FOREST, ZGBiomes.EDEN_PARADISE_WOODS, ZGBiomes.EDEN_FLOWER_GARDEN, ZGBiomes.EDEN_CRATERS, ZGBiomes.EDEN_SHROOM_HILLS, ZGBiomes.EDEN_OCEAN});
        ++totalPlanets;
        planetXathius.setDimensionInfo(ConfigManagerZG.planetXathiusDimensionId, WorldProviderXathius.class);
        planetXathius.setParentSolarSystem(systemPraedyth);
        planetXathius.setBodyClass(EnumBodyClass.NINE);
        planetXathius.setRelativeOrbitTime(2.5f);
        planetXathius.setDistanceFromCenter(1.4f);
        planetXathius.setTierRequired(ConfigManagerZG.planetXathiusTier);
        if (ConfigManagerZG.planetUnreachableAll || ConfigManagerZG.planetUnreachableXathius) {
            planetXathius.setDisableRockets();
        }
        planetXathius.setBodyTemperature(82.4f);
        planetXathius.setBodyToxicity(2.5f);
        planetXathius.setBodyRadiation(16.5f);
        planetXathius.setWindLevel(3.2f);
        planetXathius.setDensity(1.1f);
        planetXathius.setHasRain(true);
        planetXathius.setBodyGasses(EnumAtmosphericGas.OXYGEN, EnumAtmosphericGas.WATER, EnumAtmosphericGas.NITROGEN, EnumAtmosphericGas.ARGON);
        planetXathius.setAtmosphere();
        planetXathius.setBodyIcon("xathius");
        planetXathius.setBiomeInfo(new Biome[]{ZGBiomes.XATHIUS_ABSTRACT_PLAINS, ZGBiomes.XATHIUS_OCEAN, ZGBiomes.XATHIUS_BLUELANDS, ZGBiomes.XATHIUS_MOUNTAINS});
        ++totalPlanets;
        planetOasis.setDimensionInfo(ConfigManagerZG.planetOasisDimensionId, WorldProviderOasis.class);
        planetOasis.setParentSolarSystem(systemPraedyth);
        planetOasis.setBodyClass(EnumBodyClass.R);
        planetOasis.setRelativeOrbitTime(6.2f);
        planetOasis.setDistanceFromCenter(1.8f);
        planetOasis.setTierRequired(ConfigManagerZG.planetOasisTier);
        if (ConfigManagerZG.planetUnreachableAll || ConfigManagerZG.planetUnreachableOasis) {
            planetOasis.setDisableRockets();
        }
        planetOasis.setBodyTemperature(84.26f);
        planetOasis.setBodyToxicity(0.5f);
        planetOasis.setBodyRadiation(4.0f);
        planetOasis.setBreathable(true);
        planetOasis.setWindLevel(1.9f);
        planetOasis.setDensity(1.6f);
        planetOasis.setHasRain(true);
        planetOasis.setBodyGasses(EnumAtmosphericGas.OXYGEN, EnumAtmosphericGas.WATER);
        planetOasis.setAtmosphere();
        planetOasis.setBodyIcon("oasis");
        planetOasis.setBiomeInfo(new Biome[]{ZGBiomes.OASIS_PLAINS, ZGBiomes.OASIS_RED_OCEAN, ZGBiomes.OASIS_BEACH, ZGBiomes.OASIS_REDLANDS, ZGBiomes.OASIS_MUDSWAMP, ZGBiomes.OASIS_DESERT});
        ++totalPlanets;
        planetXantheon.setDimensionInfo(ConfigManagerZG.planetXantheonDimensionId, WorldProviderXantheon.class);
        planetXantheon.setParentSolarSystem(systemPraedyth);
        planetXantheon.setBodyClass(EnumBodyClass.CONSTRUCTED);
        planetXantheon.setRelativeOrbitTime(20.2f);
        planetXantheon.setDistanceFromCenter(2.5f);
        planetXantheon.setTierRequired(ConfigManagerZG.planetXantheonTier);
        if (ConfigManagerZG.planetUnreachableAll || ConfigManagerZG.planetUnreachableXantheon) {
            planetXantheon.setDisableRockets();
        }
        planetXantheon.setBodyTemperature(-31.2f);
        planetXantheon.setBodyToxicity(5.2f);
        planetXantheon.setBodyRadiation(46.3f);
        planetXantheon.setBreathable(false);
        planetXantheon.setWindLevel(0.0f);
        planetXantheon.setDensity(20.6f);
        planetXantheon.setHasRain(false);
        planetXantheon.setBodyGasses(EnumAtmosphericGas.CO2, EnumAtmosphericGas.ARGON, EnumAtmosphericGas.HELIUM);
        planetXantheon.setAtmosphere();
        planetXantheon.setBodyIcon("xantheon");
        planetXantheon.setBiomeInfo(new Biome[]{ZGBiomes.XANTHEON});
        ++totalPlanets;
        planetCandora.setDimensionInfo(ConfigManagerZG.planetCandoraDimensionId, WorldProviderCandora.class);
        planetCandora.setParentSolarSystem(systemPraedyth);
        planetCandora.setBodyClass(EnumBodyClass.EXOTIC);
        planetCandora.setRelativeOrbitTime(10.5f);
        planetCandora.setDistanceFromCenter(2.1f);
        planetCandora.setTierRequired(ConfigManagerZG.planetCandoraTier);
        if (ConfigManagerZG.planetUnreachableAll || ConfigManagerZG.planetUnreachableCandora) {
            planetCandora.setDisableRockets();
        }
        planetCandora.setBodyTemperature(67.5f);
        planetCandora.setBodyToxicity(0.0f);
        planetCandora.setBodyRadiation(0.0f);
        planetCandora.setBreathable(true);
        planetCandora.setWindLevel(0.0f);
        planetCandora.setDensity(0.1f);
        planetCandora.setHasRain(false);
        planetCandora.setBodyGasses(EnumAtmosphericGas.OXYGEN, EnumAtmosphericGas.CO2, EnumAtmosphericGas.WATER, EnumAtmosphericGas.HELIUM);
        planetCandora.setAtmosphere();
        planetCandora.setBodyIcon("candora");
        planetCandora.setBiomeInfo(new Biome[]{ZGBiomes.CANDY_MOUNTAIN, ZGBiomes.CANDY_OCEAN, ZGBiomes.CANDY_JOLLY_MELON_PLAINS, ZGBiomes.CANDY_BLUEBERRY_HILLS, ZGBiomes.CANDY_COOKIE_LANDS});
        ++totalPlanets;
        planetAtheon.setDimensionInfo(ConfigManagerZG.planetAtheonDimensionId, WorldProviderAtheon.class);
        planetAtheon.setParentSolarSystem(systemPraedyth);
        planetAtheon.setBodyClass(EnumBodyClass.CONSTRUCTED);
        planetAtheon.setRelativeOrbitTime(0.6f);
        planetAtheon.setDistanceFromCenter(0.4f);
        planetAtheon.setTierRequired(ConfigManagerZG.planetAtheonTier);
        if (ConfigManagerZG.planetUnreachableAll || ConfigManagerZG.planetUnreachableAtheon) {
            planetAtheon.setDisableRockets();
        }
        planetAtheon.setBodyTemperature(57.2f);
        planetAtheon.setBodyToxicity(0.0f);
        planetAtheon.setBodyRadiation(96.7f);
        planetAtheon.setBreathable(false);
        planetAtheon.setWindLevel(0.0f);
        planetAtheon.setDensity(40.2f);
        planetAtheon.setHasRain(false);
        planetAtheon.setBodyGasses(EnumAtmosphericGas.CO2, EnumAtmosphericGas.ARGON, EnumAtmosphericGas.HELIUM, EnumAtmosphericGas.METHANE);
        planetAtheon.setAtmosphere();
        planetAtheon.setBodyIcon("atheon");
        planetAtheon.setBiomeInfo(new Biome[]{ZGBiomes.ATHEON_GOLDLANDS, ZGBiomes.ATHEON_LAVA_LAKES});
        ++totalPlanets;
        planetPerdita.setDimensionInfo(ConfigManagerZG.planetPerditaDimensionId, WorldProviderPerdita.class);
        planetPerdita.setParentSolarSystem(systemSol2);
        planetPerdita.setBodyClass(EnumBodyClass.DESERT);
        planetPerdita.setRelativeOrbitTime(1.2f);
        planetPerdita.setDistanceFromCenter(0.8f);
        planetPerdita.setTierRequired(ConfigManagerZG.planetPerditaTier);
        if (ConfigManagerZG.planetUnreachableAll || ConfigManagerZG.planetUnreachablePerdita) {
            planetPerdita.setDisableRockets();
        }
        planetPerdita.setBodyTemperature(195.8f);
        planetPerdita.setBodyToxicity(1.2f);
        planetPerdita.setBodyRadiation(3.5f);
        planetPerdita.setBreathable(true);
        planetPerdita.setWindLevel(16.16f);
        planetPerdita.setDensity(20.4f);
        planetPerdita.setHasRain(false);
        planetPerdita.setBodyGasses(EnumAtmosphericGas.OXYGEN, EnumAtmosphericGas.CO2, EnumAtmosphericGas.NITROGEN, EnumAtmosphericGas.WATER);
        planetPerdita.setAtmosphere();
        planetPerdita.setBodyIcon("perdita");
        planetPerdita.setBiomeInfo(new Biome[]{ZGBiomes.PERDITA_DESERT, ZGBiomes.PERDITA_HALLOWS, ZGBiomes.PERDITA_OASIS, ZGBiomes.PERDITA_FUELTONIUM_OCEAN, ZGBiomes.PERDITA_LOST_MOUNTAINS});
        ++totalPlanets;
        planetAltum.setDimensionInfo(ConfigManagerZG.planetAltumDimensionId, WorldProviderAltum.class);
        planetAltum.setParentSolarSystem(systemSol2);
        planetAltum.setBodyClass(EnumBodyClass.OCEAN);
        planetAltum.setRelativeOrbitTime(3.6f);
        planetAltum.setDistanceFromCenter(1.0f);
        planetAltum.setTierRequired(ConfigManagerZG.planetAltumTier);
        if (ConfigManagerZG.planetUnreachableAll || ConfigManagerZG.planetUnreachableAltum) {
            planetAltum.setDisableRockets();
        }
        planetAltum.setBodyRadiation(0.6f);
        planetAltum.setBodyToxicity(0.2f);
        planetAltum.setBreathable(true);
        planetAltum.setWindLevel(20.42f);
        planetAltum.setDensity(0.3f);
        planetAltum.setHasRain(true);
        planetAltum.setBodyGasses(EnumAtmosphericGas.OXYGEN, EnumAtmosphericGas.CO2, EnumAtmosphericGas.NITROGEN, EnumAtmosphericGas.WATER, EnumAtmosphericGas.HYDROGEN);
        planetAltum.setAtmosphere();
        planetAltum.setBodyIcon("altum");
        planetAltum.setBiomeInfo(new Biome[]{ZGBiomes.ALTUM_ROCKY_ISLES, ZGBiomes.ALTUM_SANCTUM_BEACH, ZGBiomes.ALTUM_OCEAN, ZGBiomes.ALTUM_ROCKY_SHORE});
        ++totalPlanets;
        planetCaligro.setDimensionInfo(ConfigManagerZG.planetCaligroDimensionId, WorldProviderCaligro.class);
        planetCaligro.setParentSolarSystem(systemSol2);
        planetCaligro.setBodyClass(EnumBodyClass.DARK);
        planetCaligro.setRelativeOrbitTime(140.18f);
        planetCaligro.setDistanceFromCenter(2.0f);
        planetCaligro.setTierRequired(ConfigManagerZG.planetCaligroTier);
        if (ConfigManagerZG.planetUnreachableAll || ConfigManagerZG.planetUnreachableCaligro) {
            planetCaligro.setDisableRockets();
        }
        planetCaligro.setBodyTemperature(-165.62f);
        planetCaligro.setBodyToxicity(55.24f);
        planetCaligro.setBodyRadiation(32.21f);
        planetCaligro.setWindLevel(60.58f);
        planetCaligro.setDensity(100.32f);
        planetCaligro.setHasRain(false);
        planetCaligro.setBodyGasses(EnumAtmosphericGas.OXYGEN, EnumAtmosphericGas.WATER, EnumAtmosphericGas.NITROGEN, EnumAtmosphericGas.ARGON, EnumAtmosphericGas.METHANE, EnumAtmosphericGas.HYDROGEN);
        planetCaligro.setBodyIcon("caligro");
        planetCaligro.setAtmosphere();
        planetCaligro.setBiomeInfo(new Biome[]{ZGBiomes.CALIGRO_UPSIDE_DOWN, ZGBiomes.CALIGRO_CREEPLANDS, ZGBiomes.CALIGRO_ROCKY_VEINS, ZGBiomes.CALIGRO_WITHERLANDS, ZGBiomes.CALIGRO_CORRUPTED_MESA});
        ++totalPlanets;
        planetExodus.setDimensionInfo(ConfigManagerZG.planetExodusDimensionId, WorldProviderExodus.class);
        planetExodus.setParentSolarSystem(systemSol2);
        planetExodus.setBodyClass(EnumBodyClass.M);
        planetExodus.setRelativeOrbitTime(4.5f);
        planetExodus.setDistanceFromCenter(3.0f);
        planetExodus.setTierRequired(ConfigManagerZG.planetExodusTier);
        if (ConfigManagerZG.planetUnreachableAll || ConfigManagerZG.planetUnreachableExodus) {
            planetExodus.setDisableRockets();
        }
        planetExodus.setBodyTemperature(76.15f);
        planetExodus.setBodyToxicity(0.0f);
        planetExodus.setBodyRadiation(0.0f);
        planetExodus.setWindLevel(125.67f);
        planetExodus.setDensity(1.0f);
        planetExodus.setHasRain(true);
        planetExodus.setBodyGasses(EnumAtmosphericGas.OXYGEN, EnumAtmosphericGas.CO2, EnumAtmosphericGas.NITROGEN, EnumAtmosphericGas.WATER, EnumAtmosphericGas.HYDROGEN);
        planetExodus.setBodyIcon("exodus");
        planetExodus.setAtmosphere();
        planetExodus.setBiomeInfo(new Biome[]{ZGBiomes.EXODUS_AZURE_PLAINS, ZGBiomes.EXODUS_ROCKY_HILLS, ZGBiomes.EXODUS_OCEAN, ZGBiomes.EXODUS_FOREST, ZGBiomes.EXODUS_BLACK_MESA});
        ++totalPlanets;
        planetVortex.setDimensionInfo(ConfigManagerZG.planetVortexDimensionId, WorldProviderVortex.class);
        planetVortex.setParentSolarSystem(systemPantheon);
        planetVortex.setBodyClass(EnumBodyClass.STORMY);
        planetVortex.setRelativeOrbitTime(4.8f);
        planetVortex.setDistanceFromCenter(3.0f);
        planetVortex.setTierRequired(ConfigManagerZG.planetVortexTier);
        if (ConfigManagerZG.planetUnreachableAll || ConfigManagerZG.planetUnreachableVortex) {
            planetVortex.setDisableRockets();
        }
        planetVortex.setBodyTemperature(76.15f);
        planetVortex.setBodyToxicity(0.0f);
        planetVortex.setBodyRadiation(0.0f);
        planetVortex.setWindLevel(125.67f);
        planetVortex.setDensity(1.0f);
        planetVortex.setHasRain(true);
        planetVortex.setBodyGasses(EnumAtmosphericGas.HELIUM, EnumAtmosphericGas.NITROGEN);
        planetVortex.setBodyIcon("vortex");
        planetVortex.setAtmosphere();
        planetVortex.setBiomeInfo(new Biome[]{ZGBiomes.VORTEX_BASE, ZGBiomes.VORTEX_MOUNTAINS, ZGBiomes.VORTEX_CHARGIUM_SEA});
        ++totalPlanets;
        planetMetztli.setDimensionInfo(ConfigManagerZG.planetMetztliDimensionId, WorldProviderMetztli.class);
        planetMetztli.setParentSolarSystem(systemPantheon);
        planetMetztli.setBodyClass(EnumBodyClass.M);
        planetMetztli.setRelativeOrbitTime(8.0f);
        planetMetztli.setDistanceFromCenter(4.0f);
        planetMetztli.setTierRequired(ConfigManagerZG.planetMetztliTier);
        if (ConfigManagerZG.planetUnreachableAll || ConfigManagerZG.planetUnreachableMetztli) {
            planetMetztli.setDisableRockets();
        }
        planetMetztli.setBodyTemperature(86.05f);
        planetMetztli.setDensity(10.0f);
        planetMetztli.setHasRain(true);
        planetMetztli.setBodyToxicity(5.2f);
        planetMetztli.setBodyRadiation(8.0f);
        planetMetztli.setWindLevel(25.64f);
        planetMetztli.setBodyGasses(EnumAtmosphericGas.NITROGEN, EnumAtmosphericGas.OXYGEN, EnumAtmosphericGas.ARGON, EnumAtmosphericGas.WATER);
        planetMetztli.setBodyIcon("metztli");
        planetMetztli.setAtmosphere();
        planetMetztli.setBiomeInfo(new Biome[]{ZGBiomes.METZTLI_HARRAN_PLAINS, ZGBiomes.METZTLI_HARRAN_DUNES, ZGBiomes.METZTLI_HARRAN_OCEAN, ZGBiomes.METZTLI_HARRAN_SWAMP, ZGBiomes.METZTLI_HARRAN_TUNDRA, ZGBiomes.METZTLI_HARRAN_SHROOMS, ZGBiomes.METZTLI_HARRAN_CLAY_MESA, ZGBiomes.METZTLI_HARRAN_MARSH, ZGBiomes.METZTLI_HARRAN_FOREST, ZGBiomes.METZTLI_HARRAN_RED_DESERT, ZGBiomes.METZTLI_HARRAN_HILLS, ZGBiomes.METZTLI_HARRAN_CHERRY_FOREST, ZGBiomes.METZTLI_HARRAN_FRUIT_FOREST});
        ++totalPlanets;
        planetCentotl.setDimensionInfo(ConfigManagerZG.planetCentotlDimensionId, WorldProviderCentotl.class);
        planetCentotl.setParentSolarSystem(systemPantheon);
        planetCentotl.setBodyClass(EnumBodyClass.ABANDONED);
        planetCentotl.setRelativeOrbitTime(25.0f);
        planetCentotl.setDistanceFromCenter(2.0f);
        planetCentotl.setTierRequired(ConfigManagerZG.planetCentotlDimensionId);
        if (ConfigManagerZG.planetUnreachableAll || ConfigManagerZG.planetUnreachableCentotl) {
            planetCentotl.setDisableRockets();
        }
        planetCentotl.setBodyTemperature(96.59f);
        planetCentotl.setDensity(20.0f);
        planetCentotl.setHasRain(false);
        planetCentotl.setBodyToxicity(35.67f);
        planetCentotl.setBodyRadiation(0.0f);
        planetCentotl.setWindLevel(0.0f);
        planetCentotl.setBodyGasses(EnumAtmosphericGas.OXYGEN, EnumAtmosphericGas.ARGON, EnumAtmosphericGas.METHANE, EnumAtmosphericGas.NITROGEN, EnumAtmosphericGas.HELIUM, EnumAtmosphericGas.WATER);
        planetCentotl.setBodyIcon("centotl");
        planetCentotl.setAtmosphere();
        planetCentotl.setBiomeInfo(new Biome[]{ZGBiomes.CENTOTL_BASE, ZGBiomes.CENTOTL_ROCKY_MOUNTAINS, ZGBiomes.CENTOTL_ENGINEERING_PLAINS, ZGBiomes.CENTOTL_CONSTRUCTS});
        ++totalPlanets;
        planetToci.setDimensionInfo(ConfigManagerZG.planetTociDimensionId, WorldProviderToci.class);
        planetToci.setParentSolarSystem(systemPantheon);
        planetToci.setBodyClass(EnumBodyClass.DESERT);
        planetToci.setRelativeOrbitTime(3.5f);
        planetToci.setDistanceFromCenter(1.0f);
        planetToci.setTierRequired(ConfigManagerZG.planetTociDimensionId);
        if (ConfigManagerZG.planetUnreachableToci || ConfigManagerZG.planetUnreachableAll) {
            planetToci.setDisableRockets();
        }
        planetToci.setBodyTemperature(128.42f);
        planetToci.setDensity(0.1f);
        planetToci.setHasRain(false);
        planetToci.setBodyToxicity(0.01f);
        planetToci.setBodyRadiation(0.01f);
        planetToci.setWindLevel(5.0f);
        planetToci.setBodyGasses(EnumAtmosphericGas.OXYGEN, EnumAtmosphericGas.CO2, EnumAtmosphericGas.NITROGEN, EnumAtmosphericGas.WATER);
        planetToci.setBreathable(true);
        planetToci.setAtmosphere();
        planetToci.setBiomeInfo(new Biome[]{ZGBiomes.TOCI_BASE, ZGBiomes.TOCI_DESERT, ZGBiomes.TOCI_STAR_DESERT, ZGBiomes.TOCI_VALLEY, ZGBiomes.TOCI_MOUNTAINS});
        planetToci.setBodyIcon("toci");
        ++totalPlanets;
        planetTlaloc.setDimensionInfo(ConfigManagerZG.planetTlalocDimensionId, WorldProviderTlaloc.class);
        planetTlaloc.setParentSolarSystem(systemPantheon);
        planetTlaloc.setBodyClass(EnumBodyClass.CONSTRUCTED);
        planetTlaloc.setDistanceFromCenter(1.5f);
        planetTlaloc.setRelativeOrbitTime(5.0f);
        planetTlaloc.setTierRequired(ConfigManagerZG.planetTlalocTier);
        if (ConfigManagerZG.planetUnreachableTlaloc || ConfigManagerZG.planetUnreachableAll) {
            planetTlaloc.setDisableRockets();
        }
        planetTlaloc.setBodyTemperature(25.62f);
        planetTlaloc.setDensity(10.0f);
        planetTlaloc.setWindLevel(0.0f);
        planetTlaloc.setBodyGasses(EnumAtmosphericGas.ARGON, EnumAtmosphericGas.HELIUM, EnumAtmosphericGas.NITROGEN, EnumAtmosphericGas.METHANE);
        planetTlaloc.setBreathable(false);
        planetTlaloc.setAtmosphere();
        planetTlaloc.setBiomeInfo(new Biome[]{ZGBiomes.TLALOC_BASE, ZGBiomes.TLALOC_CONSTRUCTS, ZGBiomes.TLALOC_CHROME_FOREST, ZGBiomes.TLALOC_GOLDEN_CONSTRUCTS});
        planetTlaloc.setBodyIcon("tlaloc");
        ++totalPlanets;
        planetKronos.setDimensionInfo(ConfigManagerZG.planetKronosDimensionId, WorldProviderKronos.class);
        planetKronos.setParentSolarSystem(systemOlympus);
        planetKronos.setBodyClass(EnumBodyClass.Y);
        planetKronos.setDistanceFromCenter(2.5f);
        planetKronos.setRelativeOrbitTime(24.46f);
        planetKronos.setTierRequired(ConfigManagerZG.planetKronosTier);
        if (ConfigManagerZG.planetUnreachableKronos || ConfigManagerZG.planetUnreachableAll) {
            planetKronos.setDisableRockets();
        }
        planetKronos.setBodyTemperature(260.0f);
        planetKronos.setDensity(10.0f);
        planetKronos.setWindLevel(0.0f);
        planetKronos.setBodyGasses(EnumAtmosphericGas.NITROGEN, EnumAtmosphericGas.OXYGEN, EnumAtmosphericGas.ARGON, EnumAtmosphericGas.WATER, EnumAtmosphericGas.METHANE);
        planetKronos.setBreathable(true);
        planetKronos.setHasRain(false);
        planetKronos.setAtmosphere();
        planetKronos.setBiomeInfo(new Biome[]{ZGBiomes.KRONOS_BASE, ZGBiomes.KRONOS_SOUL_DESERT, ZGBiomes.KRONOS_BLACK_MOUNTAIN, ZGBiomes.KRONOS_DEATH_VALLEY, ZGBiomes.KRONOS_BLAZING_HILLS, ZGBiomes.KRONOS_LAVA_OCEAN, ZGBiomes.KRONOS_MAGMA_SLIMELANDS});
        planetKronos.setBodyIcon("kronos");
        ++totalPlanets;
        planetAres.setParentSolarSystem(systemOlympus);
        planetAres.setDistanceFromCenter(2.0f);
        planetAres.setRelativeOrbitTime(24.46f);
        planetAres.setBodyIcon("ares");
        planetPrometheus.setParentSolarSystem(systemOlympus);
        planetPrometheus.setDistanceFromCenter(3.0f);
        planetPrometheus.setRelativeOrbitTime(36.76f);
        planetPrometheus.setBodyIcon("prometheus");
        planetIcarus.setParentSolarSystem(systemOlympus);
        planetIcarus.setDistanceFromCenter(0.5f);
        planetIcarus.setRelativeOrbitTime(1.5f);
        planetIcarus.setBodyIcon("icarus");
        planetMaveth.setDimensionInfo(ConfigManagerZG.planetMavethDimensionId, WorldProviderMaveth.class);
        planetMaveth.setParentSolarSystem(systemAsgard);
        planetMaveth.setBodyClass(EnumBodyClass.ABANDONED);
        planetMaveth.setRelativeOrbitTime(50000.0f);
        planetMaveth.setDistanceFromCenter(1.0f);
        planetMaveth.setRelativeOrbitTime(256.0f);
        planetMaveth.setDistanceFromCenter(1.5f);
        planetMaveth.setTierRequired(ConfigManagerZG.planetMavethTier);
        if (ConfigManagerZG.planetUnreachableMaveth || ConfigManagerZG.planetUnreachableAll) {
            planetMaveth.setDisableRockets();
        }
        planetMaveth.setBodyTemperature(-86.24f);
        planetMaveth.setDensity(10.0f);
        planetMaveth.setWindLevel(20.45f);
        planetMaveth.setBodyGasses(EnumAtmosphericGas.NITROGEN, EnumAtmosphericGas.OXYGEN, EnumAtmosphericGas.ARGON, EnumAtmosphericGas.WATER, EnumAtmosphericGas.METHANE);
        planetMaveth.setBreathable(true);
        planetMaveth.setHasRain(false);
        planetMaveth.setAtmosphere();
        planetMaveth.setBodyIcon("maveth");
        planetMaveth.setBiomeInfo(new Biome[]{ZGBiomes.MAVETH_BASE});
        ++totalPlanets;
        planetAsgard.setParentSolarSystem(systemAsgard);
        planetAsgard.setDistanceFromCenter(0.5f);
        planetAsgard.setRelativeOrbitTime(4.3f);
        planetAsgard.setBodyIcon("asgard");
        planetReach.setParentSolarSystem(systemVega);
        planetReach.setDistanceFromCenter(1.0f);
        planetReach.setRelativeOrbitTime(2.0f);
        planetReach.setBodyIcon("reach");
        planetRequiem.setParentSolarSystem(systemVega);
        planetRequiem.setDistanceFromCenter(1.5f);
        planetRequiem.setRelativeOrbitTime(4.0f);
        planetRequiem.setBodyIcon("requiem");
        planetMeridian.setParentSolarSystem(systemVega);
        planetMeridian.setDistanceFromCenter(2.0f);
        planetMeridian.setRelativeOrbitTime(3.5f);
        planetMeridian.setBodyIcon("meridian");
        planetSomnium.setParentSolarSystem(systemNova);
        planetSomnium.setDistanceFromCenter(0.5f);
        planetSomnium.setRelativeOrbitTime(1.5f);
        planetSomnium.setBodyIcon("somnium");
        planetPrimor.setParentSolarSystem(systemNova);
        planetPrimor.setDistanceFromCenter(1.0f);
        planetPrimor.setRelativeOrbitTime(2.0f);
        planetPrimor.setBodyIcon("primor");
        ZGHelper.Log("Loaded a total of " + totalPlanets + " new planets.");
    }

    public static void initMoons() {
        moonAstros.setDimensionInfo(ConfigManagerZG.moonAstrosDimensionId, WorldProviderAstros.class);
        moonAstros.setParentPlanet(planetEden);
        moonAstros.setMoonClass(EnumBodyClass.L);
        moonAstros.setRelativeOrbitTime(100.0f);
        moonAstros.setPhaseShift(1.0f);
        moonAstros.setRelativeSize(1.0f);
        moonAstros.setDistanceFromCenter(13.0f);
        moonAstros.setTierRequired(planetEden.getTierRequirement());
        if (ConfigManagerZG.planetUnreachableAll || ConfigManagerZG.planetUnreachableEden) {
            moonAstros.setDisableRockets();
        }
        moonAstros.setMoonTemperature(26.54f);
        moonAstros.setDensity(10.0f);
        moonAstros.setHasRain(false);
        moonAstros.setMoonToxicity(0.0f);
        moonAstros.setMoonRadiation(0.0f);
        moonAstros.setWindLevel(16.51f);
        moonAstros.setMoonGasses(EnumAtmosphericGas.NITROGEN, EnumAtmosphericGas.ARGON, EnumAtmosphericGas.HELIUM);
        moonAstros.setMoonIcon("astros");
        moonAstros.setAtmosphere();
        moonAstros.setBiomeInfo(new Biome[]{ZGBiomes.ASTROS_BASE, ZGBiomes.ASTROS_ROCKIES, ZGBiomes.ASTROS_GLACIERS});
        ZGHelper.Log("Loaded a total of " + ++totalMoons + " new moons.");
    }

    public static void registerSystems() {
        GalaxyRegistry.registerSolarSystem((SolarSystem)systemPsios);
        GalaxyRegistry.registerSolarSystem((SolarSystem)systemPraedyth);
        GalaxyRegistry.registerSolarSystem((SolarSystem)systemSol2);
        GalaxyRegistry.registerSolarSystem((SolarSystem)systemPantheon);
        GalaxyRegistry.registerSolarSystem((SolarSystem)systemOlympus);
        GalaxyRegistry.registerSolarSystem((SolarSystem)systemAsgard);
        GalaxyRegistry.registerSolarSystem((SolarSystem)systemVega);
        GalaxyRegistry.registerSolarSystem((SolarSystem)systemNova);
        if (!hideUnusedStarSystems) {
            // empty if block
        }
        ZGPlanets.registerPlanets();
    }

    public static void registerPlanets() {
        GalaxyRegistry.registerPlanet((Planet)planetZollus);
        GalaxyRegistry.registerPlanet((Planet)planetEden);
        GalaxyRegistry.registerPlanet((Planet)planetKriffon);
        GalaxyRegistry.registerPlanet((Planet)planetPurgot);
        GalaxyRegistry.registerPlanet((Planet)planetXathius);
        GalaxyRegistry.registerPlanet((Planet)planetOasis);
        GalaxyRegistry.registerPlanet((Planet)planetXantheon);
        GalaxyRegistry.registerPlanet((Planet)planetCandora);
        GalaxyRegistry.registerPlanet((Planet)planetAtheon);
        GalaxyRegistry.registerPlanet((Planet)planetPerdita);
        GalaxyRegistry.registerPlanet((Planet)planetAltum);
        GalaxyRegistry.registerPlanet((Planet)planetCaligro);
        GalaxyRegistry.registerPlanet((Planet)planetExodus);
        GalaxyRegistry.registerPlanet((Planet)planetVortex);
        GalaxyRegistry.registerPlanet((Planet)planetMetztli);
        GalaxyRegistry.registerPlanet((Planet)planetCentotl);
        GalaxyRegistry.registerPlanet((Planet)planetToci);
        GalaxyRegistry.registerPlanet((Planet)planetTlaloc);
        GalaxyRegistry.registerPlanet((Planet)planetKronos);
        GalaxyRegistry.registerPlanet((Planet)planetAres);
        GalaxyRegistry.registerPlanet((Planet)planetPrometheus);
        GalaxyRegistry.registerPlanet((Planet)planetIcarus);
        GalaxyRegistry.registerPlanet((Planet)planetMaveth);
        GalaxyRegistry.registerPlanet((Planet)planetAsgard);
        GalaxyRegistry.registerPlanet((Planet)planetReach);
        GalaxyRegistry.registerPlanet((Planet)planetMaveth);
        GalaxyRegistry.registerPlanet((Planet)planetRequiem);
        GalaxyRegistry.registerPlanet((Planet)planetMeridian);
        GalaxyRegistry.registerPlanet((Planet)planetSomnium);
        GalaxyRegistry.registerPlanet((Planet)planetPrimor);
        ZGPlanets.registerMoons();
    }

    public static void registerMoons() {
        GalaxyRegistry.registerMoon((Moon)moonAstros);
    }

    public static void registerTeleportTypes() {
        GalacticraftRegistry.registerTeleportType(WorldProviderZollus.class, (ITeleportType)new TeleportTypeBaseZG());
        GalacticraftRegistry.registerTeleportType(WorldProviderKriffon.class, (ITeleportType)new TeleportTypeBaseZG());
        GalacticraftRegistry.registerTeleportType(WorldProviderPurgot.class, (ITeleportType)new TeleportTypeBaseZG());
        GalacticraftRegistry.registerTeleportType(WorldProviderEden.class, (ITeleportType)new TeleportTypeBaseZG());
        GalacticraftRegistry.registerTeleportType(WorldProviderAstros.class, (ITeleportType)new TeleportTypeBaseZG());
        GalacticraftRegistry.registerTeleportType(WorldProviderXathius.class, (ITeleportType)new TeleportTypeBaseZG());
        GalacticraftRegistry.registerTeleportType(WorldProviderOasis.class, (ITeleportType)new TeleportTypeBaseZG());
        GalacticraftRegistry.registerTeleportType(WorldProviderXantheon.class, (ITeleportType)new TeleportTypeBaseZG());
        GalacticraftRegistry.registerTeleportType(WorldProviderCandora.class, (ITeleportType)new TeleportTypeBaseZG());
        GalacticraftRegistry.registerTeleportType(WorldProviderAtheon.class, (ITeleportType)new TeleportTypeBaseZG());
        GalacticraftRegistry.registerTeleportType(WorldProviderPerdita.class, (ITeleportType)new TeleportTypeBaseZG());
        GalacticraftRegistry.registerTeleportType(WorldProviderAltum.class, (ITeleportType)new TeleportTypeBaseZG());
        GalacticraftRegistry.registerTeleportType(WorldProviderCaligro.class, (ITeleportType)new TeleportTypeBaseZG());
        GalacticraftRegistry.registerTeleportType(WorldProviderExodus.class, (ITeleportType)new TeleportTypeBaseZG());
        GalacticraftRegistry.registerTeleportType(WorldProviderVortex.class, (ITeleportType)new TeleportTypeBaseZG());
        GalacticraftRegistry.registerTeleportType(WorldProviderMetztli.class, (ITeleportType)new TeleportTypeBaseZG());
        GalacticraftRegistry.registerTeleportType(WorldProviderCentotl.class, (ITeleportType)new TeleportTypeBaseZG());
        GalacticraftRegistry.registerTeleportType(WorldProviderToci.class, (ITeleportType)new TeleportTypeBaseZG());
        GalacticraftRegistry.registerTeleportType(WorldProviderTlaloc.class, (ITeleportType)new TeleportTypeBaseZG());
        GalacticraftRegistry.registerTeleportType(WorldProviderKronos.class, (ITeleportType)new TeleportTypeBaseZG());
    }
}

