/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.celestial;

import java.util.ArrayList;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.world.AtmosphereInfo;
import micdoodle8.mods.galacticraft.api.world.EnumAtmosphericGas;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import zollerngalaxy.biomes.BiomeSpace;
import zollerngalaxy.celestial.IZollernBody;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderPlanetZG;
import zollerngalaxy.core.enums.EnumBodyClass;
import zollerngalaxy.lib.helpers.ZGHelper;

public class ZGPlanetaryBody
extends Planet
implements IZollernBody {
    private EnumBodyClass bodyClass;
    private Star bodyStar;
    private float baseTemp;
    private float baseRadiation;
    private float baseToxicity;
    private float windLevel;
    private float density;
    private boolean breathable;
    private boolean rains;
    private AtmosphereInfo atmosphere;
    private ArrayList<EnumAtmosphericGas> bodyGasses = new ArrayList();
    private WorldProviderPlanetZG spaceProvider = null;
    protected boolean enableExtremeMode = ConfigManagerZG.enableExtremeMode;
    private String bodyName;

    public ZGPlanetaryBody(String bodyNameIn) {
        super(bodyNameIn);
        this.bodyName = bodyNameIn;
        this.setRingColorRGB(0.1f, 0.9f, 0.6f);
        this.setPhaseShift(0.0f);
        this.setRelativeSize(1.0f);
        this.addChecklistKeys(new String[]{"thermal_padding", "equip_oxygen_suit", "equip_parachute"});
    }

    public ZGPlanetaryBody setBodyStar(Star systemStar) {
        this.bodyStar = systemStar;
        return this;
    }

    public ZGPlanetaryBody setBodyClass(EnumBodyClass pClass) {
        this.bodyClass = pClass;
        return this;
    }

    public IZollernBody setBodyTemperature(float bodyTemp) {
        this.baseTemp = bodyTemp;
        return this;
    }

    public IZollernBody setBodyRadiation(float bodyRad) {
        this.baseRadiation = bodyRad;
        return this;
    }

    public IZollernBody setBodyToxicity(float bodyTox) {
        this.baseToxicity = bodyTox;
        return this;
    }

    public IZollernBody setBreathable(boolean canBreathe) {
        this.breathable = canBreathe;
        return this;
    }

    public IZollernBody setHasRain(boolean hasRain) {
        this.rains = hasRain;
        return this;
    }

    public IZollernBody setWindLevel(float windLvl) {
        this.windLevel = windLvl;
        return this;
    }

    public IZollernBody setDensity(float denseLvl) {
        this.density = denseLvl;
        return this;
    }

    public IZollernBody setAtmosphere() {
        this.atmosphere = new AtmosphereInfo(Boolean.valueOf(this.getIsBreathable()), this.getHasRain(), this.getIsCorrosive(), this.getBodyTemperature(), this.getWindLevel(), this.getAtmosphericDensity());
        return this;
    }

    public IZollernBody setBodyGasses(EnumAtmosphericGas ... gasses) {
        for (EnumAtmosphericGas gas : gasses) {
            if (gas == null) continue;
            this.atmosphereComponent(gas);
            this.bodyGasses.add(gas);
        }
        return this;
    }

    public IZollernBody setDisableRockets(boolean disableRockets, int bodyTier) {
        if (disableRockets) {
            this.setTierRequired(-1);
        } else {
            this.setTierRequired(bodyTier);
        }
        return this;
    }

    public IZollernBody setDisableRockets() {
        this.setTierRequired(-1);
        return this;
    }

    public IZollernBody setDistanceFromCenter(float par1, float par2) {
        this.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(par1, par2));
        return this;
    }

    public IZollernBody setDistanceFromCenter(float par1) {
        this.setDistanceFromCenter(par1, par1);
        return this;
    }

    public IZollernBody setBodyIcon(String bodyTexture) {
        this.setBodyIcon(new ResourceLocation("zollerngalaxy:textures/gui/" + bodyTexture + ".png"));
        return this;
    }

    public IZollernBody setSpaceProvider(WorldProviderPlanetZG provider) {
        this.spaceProvider = provider;
        return this;
    }

    public WorldProviderPlanetZG getSpaceProvider() {
        return this.spaceProvider;
    }

    public Star getBodyStar() {
        return this.bodyStar;
    }

    @Override
    public float getRadiationLevel() {
        return this.baseRadiation;
    }

    @Override
    public float getToxicLevel() {
        return this.baseToxicity;
    }

    @Override
    public EnumBodyClass getBodyClass() {
        return this.bodyClass;
    }

    @Override
    public String getGasses() {
        String gasList = "";
        ArrayList<EnumAtmosphericGas> bodyAtmosphere = this.bodyGasses;
        int ch = 0;
        for (EnumAtmosphericGas bodyGas : bodyAtmosphere) {
            gasList = gasList + ZGHelper.capitalizeFirstLetter(bodyGas.toString().substring(0, 3).toLowerCase());
            if (++ch >= bodyAtmosphere.size()) continue;
            gasList = gasList + ", ";
        }
        bodyAtmosphere = null;
        return gasList;
    }

    @Override
    public boolean getIsHotBody() {
        return this.baseTemp >= 115.0f;
    }

    @Override
    public boolean getIsColdBody() {
        return this.baseTemp <= -25.0f;
    }

    public boolean getIsRadioactiveBody() {
        return this.baseRadiation >= 10.0f;
    }

    public boolean getIsToxicBody() {
        return this.baseToxicity >= 15.0f;
    }

    @Override
    public boolean getIsBreathable() {
        return this.breathable;
    }

    @Override
    public boolean getHasRain() {
        return this.rains;
    }

    @Override
    public float getWindLevel() {
        return this.windLevel;
    }

    @Override
    public float getAtmosphericDensity() {
        return this.density;
    }

    @Override
    public boolean getIsCorrosive() {
        return this.getIsToxicBody() || this.getIsRadioactiveBody();
    }

    @Override
    public float getBodyTemperature() {
        float bodyTemp = this.baseTemp;
        return bodyTemp;
    }

    @Override
    public float getBodyTemperature(World world, BlockPos pos) {
        float bodyTemp = this.baseTemp;
        float maxTemp = bodyTemp * 4.0f;
        float minTemp = bodyTemp / 4.0f;
        Biome biome = world.getBiomeForCoordsBody(pos);
        if (biome instanceof BiomeSpace) {
            WorldProviderPlanetZG spaceProvider = (WorldProviderPlanetZG)world.field_73011_w;
            boolean isDaytime = spaceProvider.isDaytime();
            BiomeSpace spaceBiome = (BiomeSpace)biome;
            float biomeTemp = spaceBiome.getBiomeTemp();
            boolean isHotBiome = spaceBiome.getIsHotBiome();
            boolean isColdBiome = spaceBiome.getIsColdBiome();
            Random rand = new Random();
            if (rand.nextInt(100) <= 32) {
                bodyTemp = isHotBiome ? (float)((double)bodyTemp + (double)biomeTemp * 1.5) : (isColdBiome ? (float)((double)bodyTemp - (double)biomeTemp * 1.5) : (isDaytime ? (bodyTemp += biomeTemp) : (bodyTemp -= biomeTemp)));
                if (bodyTemp > maxTemp) {
                    bodyTemp = maxTemp;
                } else if (bodyTemp < minTemp) {
                    bodyTemp = minTemp;
                }
            }
        }
        return bodyTemp;
    }
}

