/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.celestial;

import java.util.ArrayList;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.world.AtmosphereInfo;
import micdoodle8.mods.galacticraft.api.world.EnumAtmosphericGas;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import zollerngalaxy.biomes.BiomeSpace;
import zollerngalaxy.celestial.IZollernBody;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderMoonZG;
import zollerngalaxy.core.enums.EnumBodyClass;
import zollerngalaxy.lib.helpers.ZGHelper;

public class ZGMoon
extends Moon
implements IZollernBody {
    private EnumBodyClass bodyClass;
    private Star bodyStar;
    private float baseTemp;
    private float baseRadiation;
    private float baseToxicity;
    private float windLevel;
    private float density;
    private boolean breathable;
    private boolean rains;
    private AtmosphereInfo atmosphere;
    private ArrayList<EnumAtmosphericGas> bodyGasses = new ArrayList();
    private WorldProviderMoonZG spaceProvider = null;
    protected boolean enableExtremeMode = ConfigManagerZG.enableExtremeMode;

    public ZGMoon(String moonName) {
        super(moonName);
        this.setPhaseShift((float)Math.PI);
        this.setRelativeSize(1.0f);
        this.addChecklistKeys(new String[]{"thermal_padding", "equip_oxygen_suit", "equip_parachute"});
    }

    public CelestialBody setRelativeDistanceFromCenter(float scaledDistance) {
        this.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(scaledDistance, scaledDistance));
        return this;
    }

    public CelestialBody setRelativeDistanceFromCenter(float scaledDistance1, float scaledDistance2) {
        this.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(scaledDistance1, scaledDistance2));
        return this;
    }

    public ZGMoon setMoonStar(Star systemStar) {
        this.bodyStar = systemStar;
        return this;
    }

    public ZGMoon setMoonClass(EnumBodyClass pClass) {
        this.bodyClass = pClass;
        return this;
    }

    public ZGMoon setMoonTemperature(float bodyTemp) {
        this.baseTemp = bodyTemp;
        return this;
    }

    public ZGMoon setMoonRadiation(float bodyRad) {
        this.baseRadiation = bodyRad;
        return this;
    }

    public ZGMoon setMoonToxicity(float bodyTox) {
        this.baseToxicity = bodyTox;
        return this;
    }

    public ZGMoon setBreathable(boolean canBreathe) {
        this.breathable = canBreathe;
        return this;
    }

    public ZGMoon setHasRain(boolean hasRain) {
        this.rains = hasRain;
        return this;
    }

    public ZGMoon setWindLevel(float windLvl) {
        this.windLevel = windLvl;
        return this;
    }

    public ZGMoon setDensity(float denseLvl) {
        this.density = denseLvl;
        return this;
    }

    public ZGMoon setAtmosphere() {
        this.atmosphere = new AtmosphereInfo(Boolean.valueOf(this.getIsBreathable()), this.getHasRain(), this.getIsCorrosive(), this.getBodyTemperature(), this.getWindLevel(), this.getAtmosphericDensity());
        return this;
    }

    public ZGMoon setMoonGasses(EnumAtmosphericGas ... gasses) {
        for (EnumAtmosphericGas gas : gasses) {
            if (gas == null) continue;
            this.atmosphereComponent(gas);
            this.bodyGasses.add(gas);
        }
        return this;
    }

    public ZGMoon setDisableRockets(boolean disableRockets, int bodyTier) {
        if (disableRockets) {
            this.setTierRequired(-1);
        } else {
            this.setTierRequired(bodyTier);
        }
        return this;
    }

    public ZGMoon setDisableRockets() {
        this.setTierRequired(-1);
        return this;
    }

    public ZGMoon setDistanceFromCenter(float par1, float par2) {
        this.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(par1, par2));
        return this;
    }

    public ZGMoon setDistanceFromCenter(float par1) {
        this.setDistanceFromCenter(par1, par1);
        return this;
    }

    public ZGMoon setMoonIcon(String bodyTexture) {
        this.setBodyIcon(new ResourceLocation("zollerngalaxy:textures/gui/" + bodyTexture + ".png"));
        return this;
    }

    public ZGMoon setSpaceProvider(WorldProviderMoonZG provider) {
        this.spaceProvider = provider;
        return this;
    }

    public WorldProviderMoonZG getSpaceProvider() {
        return this.spaceProvider;
    }

    public Star getMoonStar() {
        return this.bodyStar;
    }

    @Override
    public float getRadiationLevel() {
        return this.baseRadiation;
    }

    @Override
    public float getToxicLevel() {
        return this.baseToxicity;
    }

    @Override
    public EnumBodyClass getBodyClass() {
        return this.bodyClass;
    }

    @Override
    public String getGasses() {
        String gasList = "";
        ArrayList<EnumAtmosphericGas> bodyAtmosphere = this.bodyGasses;
        int ch = 0;
        for (EnumAtmosphericGas bodyGas : bodyAtmosphere) {
            gasList = gasList + ZGHelper.capitalizeFirstLetter(bodyGas.toString().substring(0, 3).toLowerCase());
            if (++ch >= bodyAtmosphere.size()) continue;
            gasList = gasList + ", ";
        }
        bodyAtmosphere = null;
        return gasList;
    }

    @Override
    public boolean getIsHotBody() {
        return this.baseTemp >= 115.0f;
    }

    @Override
    public boolean getIsColdBody() {
        return this.baseTemp <= -25.0f;
    }

    public boolean getIsRadioactiveMoon() {
        return this.baseRadiation >= 10.0f;
    }

    public boolean getIsToxicMoon() {
        return this.baseToxicity >= 15.0f;
    }

    @Override
    public boolean getIsBreathable() {
        return this.breathable;
    }

    @Override
    public boolean getHasRain() {
        return this.rains;
    }

    @Override
    public float getWindLevel() {
        return this.windLevel;
    }

    @Override
    public float getAtmosphericDensity() {
        return this.density;
    }

    @Override
    public boolean getIsCorrosive() {
        return this.getIsToxicMoon() || this.getIsRadioactiveMoon();
    }

    @Override
    public float getBodyTemperature() {
        float bodyTemp = this.baseTemp;
        return bodyTemp;
    }

    @Override
    public float getBodyTemperature(World world, BlockPos pos) {
        float bodyTemp = this.baseTemp;
        int multiplier = 4;
        float maxTemp = bodyTemp * (float)multiplier;
        float minTemp = bodyTemp / (float)multiplier;
        Biome biome = world.getBiomeForCoordsBody(pos);
        if (biome instanceof BiomeSpace) {
            WorldProviderMoonZG spaceProvider = (WorldProviderMoonZG)world.field_73011_w;
            boolean isDaytime = spaceProvider.isDaytime();
            BiomeSpace spaceBiome = (BiomeSpace)biome;
            float biomeTemp = spaceBiome.getBiomeTemp();
            boolean isHotBiome = spaceBiome.getIsHotBiome();
            boolean isColdBiome = spaceBiome.getIsColdBiome();
            Random rand = new Random();
            if (rand.nextInt(100) <= 46) {
                bodyTemp = isHotBiome ? (float)((double)bodyTemp + (double)biomeTemp * 1.5) : (isColdBiome ? (float)((double)bodyTemp - (double)biomeTemp * 1.5) : (isDaytime ? (bodyTemp += biomeTemp) : (bodyTemp -= biomeTemp)));
                if (bodyTemp > maxTemp) {
                    bodyTemp = maxTemp;
                } else if (bodyTemp < minTemp) {
                    bodyTemp = minTemp;
                }
            }
        }
        return bodyTemp;
    }
}

