/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.blocks.perdita;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zollerngalaxy.blocks.ZGBlockBase;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.blocks.ZGSand;
import zollerngalaxy.core.enums.EnumBlockType;
import zollerngalaxy.items.ZGItems;
import zollerngalaxy.lib.helpers.ZGHelper;

public class LostCactus
extends ZGBlockBase
implements IPlantable {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)15);
    protected static final AxisAlignedBB CACTUS_COLLISION_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.9375, 0.9375);
    protected static final AxisAlignedBB CACTUS_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375);

    public LostCactus() {
        super("perdcactus", 1.4f);
        this.setMaterial(Material.field_151570_A);
        this.setBlockType(EnumBlockType.CACTUS);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
        this.func_149675_a(true);
        this.setShouldJSONIgnore(true);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.func_175697_a(pos, 1)) {
            return;
        }
        BlockPos blockpos = pos.func_177984_a();
        if (worldIn.func_175623_d(blockpos)) {
            int i = 1;
            while (worldIn.func_180495_p(pos.func_177979_c(i)).func_177230_c() == this) {
                ++i;
            }
            if (i < 3) {
                int j = (Integer)state.func_177229_b((IProperty)AGE);
                if (ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)blockpos, (IBlockState)state, (boolean)true)) {
                    if (j == 15) {
                        worldIn.func_175656_a(blockpos, this.func_176223_P());
                        IBlockState iblockstate = state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0));
                        worldIn.func_180501_a(pos, iblockstate, 4);
                        iblockstate.func_189546_a(worldIn, blockpos, (Block)this, pos);
                    } else {
                        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(j + 1)), 4);
                    }
                    ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
                }
            }
        }
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return CACTUS_COLLISION_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return CACTUS_AABB.func_186670_a(pos);
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        BlockPos pos2 = pos.func_177977_b();
        IBlockState state = worldIn.func_180495_p(pos2);
        Block block = state.func_177230_c();
        return block instanceof ZGSand || block instanceof LostCactus;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!LostCactus.canBlockStay(worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public static boolean canBlockStay(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos.func_177977_b());
        return state.func_177230_c() == ZGBlocks.perdSand;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        entityIn.func_70097_a(DamageSource.field_76367_g, 2.5f);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Desert;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return this.func_176223_P();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        int randInt = ZGHelper.rngInt(1, 10);
        if (randInt <= 3) {
            int dropNum = ZGHelper.rngInt(1, 3);
            for (int i = 0; i < dropNum; ++i) {
                ZGHelper.dropItem(ZGItems.perdBerry, worldIn, pos);
            }
        }
    }

    @Override
    public boolean shouldJSONIgnore() {
        return true;
    }
}

