/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.blocks.fluids;

import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import zollerngalaxy.blocks.fluids.ZGFluidBase;
import zollerngalaxy.blocks.materials.MaterialSpaceMilk;
import zollerngalaxy.core.ZollernGalaxyCore;
import zollerngalaxy.lib.helpers.ZGHelper;
import zollerngalaxy.proxy.IProxy;

public class ZGFluids {
    private static int totalFluids = 0;
    private static IProxy proxy = ZollernGalaxyCore.proxy;
    public static Fluid fluidChargium;
    public static ZGFluidBase blockChargiumFluid;
    public static Fluid fluidWhiteLava;
    public static ZGFluidBase blockWhiteLavaFluid;
    public static Fluid fluidFueltonium;
    public static ZGFluidBase blockFueltoniumFluid;
    public static Fluid fluidChocolate;
    public static ZGFluidBase blockChocolateFluid;
    public static Fluid fluidRadium;
    public static ZGFluidBase blockRadiumFluid;
    public static Fluid fluidSpaceMilk;
    public static ZGFluidBase blockSpaceMilk;
    public static Fluid fluidRadite;
    public static ZGFluidBase blockFluidRadite;

    public static void init() {
        ZGHelper.Log("Beginning Fluid Registry...");
        ZGFluids.registerFluids();
        ZGFluids.registerFluidBlocks();
        ZGFluids.addBuckets();
        ZGFluids.refreshReferences();
        ZGHelper.Log("Loaded a total of " + totalFluids + " new fluids.");
    }

    private static void registerFluids() {
        fluidChargium = new Fluid("chargium", new ResourceLocation("zollerngalaxy", "blocks/chargiumfluid"), new ResourceLocation("zollerngalaxy", "blocks/chargiumfluid"));
        fluidWhiteLava = new Fluid("whitelava", new ResourceLocation("zollerngalaxy", "blocks/whitelava"), new ResourceLocation("zollerngalaxy", "blocks/whitelava"));
        fluidFueltonium = new Fluid("fueltonium", new ResourceLocation("zollerngalaxy", "blocks/fueltonium"), new ResourceLocation("zollerngalaxy", "blocks/fueltonium"));
        fluidChocolate = new Fluid("chocolatemelted", new ResourceLocation("zollerngalaxy", "blocks/chocolatemelted"), new ResourceLocation("zollerngalaxy", "blocks/chocolatemelted"));
        fluidRadium = new Fluid("radium", new ResourceLocation("zollerngalaxy", "blocks/radiumfluid"), new ResourceLocation("zollerngalaxy", "blocks/radiumfluid"));
        fluidSpaceMilk = new Fluid("spacemilk", new ResourceLocation("zollerngalaxy", "blocks/spacemilk"), new ResourceLocation("zollerngalaxy", "blocks/spacemilk"));
        fluidRadite = new Fluid("raditefluid", new ResourceLocation("zollerngalaxy", "blocks/raditefluid"), new ResourceLocation("zollerngalaxy", "blocks/raditefluid"));
        ZGFluids.registerFluid(fluidChargium);
        ZGFluids.registerFluid(fluidWhiteLava);
        ZGFluids.registerFluid(fluidFueltonium);
        ZGFluids.registerFluid(fluidChocolate);
        ZGFluids.registerFluid(fluidRadium);
        ZGFluids.registerFluid(fluidSpaceMilk);
        ZGFluids.registerFluid(fluidRadite);
    }

    private static void registerFluidBlocks() {
        blockChargiumFluid = (ZGFluidBase)new ZGFluidBase("chargium", fluidChargium, Material.field_151587_i, MapColor.field_151674_s).setQuantaPerBlock(3).func_149715_a(1.0f);
        blockWhiteLavaFluid = (ZGFluidBase)((ZGFluidBase)new ZGFluidBase("whitelava", fluidWhiteLava, Material.field_151587_i, MapColor.field_193561_M).setQuantaPerBlock(6).func_149715_a(1.0f)).setTemperature(5000);
        blockFueltoniumFluid = (ZGFluidBase)((ZGFluidBase)new ZGFluidBase("fueltonium", fluidFueltonium, Material.field_151587_i, MapColor.field_151651_C).setQuantaPerBlock(10).func_149715_a(1.0f)).setTemperature(10000);
        blockChocolateFluid = (ZGFluidBase)new ZGFluidBase("chocolatemelted", fluidChocolate, Material.field_151586_h, MapColor.field_151650_B).setQuantaPerBlock(9).func_149715_a(0.5f);
        blockRadiumFluid = (ZGFluidBase)new ZGFluidBase("radium", fluidRadium, Material.field_151586_h, MapColor.field_151673_t).setQuantaPerBlock(6).func_149715_a(1.0f);
        blockSpaceMilk = (ZGFluidBase)new ZGFluidBase("spaceMilk", fluidSpaceMilk, (Material)new MaterialSpaceMilk(), MapColor.field_151671_v).setQuantaPerBlock(8).func_149715_a(0.6f);
        blockFluidRadite = (ZGFluidBase)new ZGFluidBase("raditefluid", fluidRadite, Material.field_151587_i, MapColor.field_151645_D).setQuantaPerBlock(4).func_149715_a(1.0f);
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)blockChargiumFluid);
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)blockWhiteLavaFluid);
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)blockFueltoniumFluid);
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)blockChocolateFluid);
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)blockRadiumFluid);
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)blockSpaceMilk);
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)blockFluidRadite);
        proxy.addIModelRegister(blockChargiumFluid);
        proxy.addIModelRegister(blockWhiteLavaFluid);
        proxy.addIModelRegister(blockFueltoniumFluid);
        proxy.addIModelRegister(blockChocolateFluid);
        proxy.addIModelRegister(blockRadiumFluid);
        proxy.addIModelRegister(blockSpaceMilk);
        proxy.addIModelRegister(blockFluidRadite);
    }

    public static void addBuckets() {
        FluidRegistry.addBucketForFluid((Fluid)fluidChargium);
        FluidRegistry.addBucketForFluid((Fluid)fluidWhiteLava);
        FluidRegistry.addBucketForFluid((Fluid)fluidFueltonium);
        FluidRegistry.addBucketForFluid((Fluid)fluidChocolate);
        FluidRegistry.addBucketForFluid((Fluid)fluidRadium);
        FluidRegistry.addBucketForFluid((Fluid)fluidSpaceMilk);
        FluidRegistry.addBucketForFluid((Fluid)fluidRadite);
    }

    public static void refreshReferences() {
        fluidChargium = FluidRegistry.getFluid((String)"chargium");
        fluidWhiteLava = FluidRegistry.getFluid((String)"whitelava");
        fluidFueltonium = FluidRegistry.getFluid((String)"fueltonium");
        fluidChocolate = FluidRegistry.getFluid((String)"chocolatemelted");
        fluidRadium = FluidRegistry.getFluid((String)"radium");
        fluidSpaceMilk = FluidRegistry.getFluid((String)"spacemilk");
        fluidRadite = FluidRegistry.getFluid((String)"raditefluid");
    }

    protected static void registerFluid(Fluid fluid) {
        FluidRegistry.registerFluid((Fluid)fluid);
        ++totalFluids;
    }
}

