/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.blocks.eden;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import zollerngalaxy.blocks.ZGBlockDirt;
import zollerngalaxy.blocks.ZGBlockFlower;
import zollerngalaxy.blocks.ZGBlockGrass;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.lib.helpers.ZGHelper;
import zollerngalaxy.lib.helpers.json.JSONFactory;

public class EdenFlower
extends ZGBlockFlower {
    private String COLOR;
    private static String blockName = "edenflower";

    public EdenFlower(String flowerColor) {
        super(blockName + "_" + flowerColor);
        this.setColor(flowerColor);
        this.setupFlower();
    }

    public EdenFlower() {
        super(blockName);
        this.setColor("");
        this.setupFlower();
    }

    private void setupFlower() {
        this.setMaterial(Material.field_151582_l);
        this.func_149675_a(true);
        String flowerName = this.getColor() == "" ? blockName : blockName + "_" + this.getColor();
        JSONFactory.registerFlowerBlock(flowerName);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
    }

    @Override
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
    }

    @Override
    public int func_149738_a(World worldIn) {
        return 20;
    }

    @Override
    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
        String clr = this.getColor();
        Block blockX = worldIn.func_180495_p(pos.func_177982_a(1, 0, 0)).func_177230_c();
        Block blockNX = worldIn.func_180495_p(pos.func_177982_a(-1, 0, 0)).func_177230_c();
        Block blockZ = worldIn.func_180495_p(pos.func_177982_a(0, 0, 1)).func_177230_c();
        Block blockNZ = worldIn.func_180495_p(pos.func_177982_a(0, 0, -1)).func_177230_c();
        if (blockX instanceof EdenFlower) {
            EdenFlower flowerX = (EdenFlower)blockX;
            this.mateFlowers(worldIn, pos, clr, flowerX.getColor());
        }
        if (blockNX instanceof EdenFlower) {
            EdenFlower flowerNX = (EdenFlower)blockNX;
            this.mateFlowers(worldIn, pos, clr, flowerNX.getColor());
        }
        if (blockZ instanceof EdenFlower) {
            EdenFlower flowerZ = (EdenFlower)blockZ;
            this.mateFlowers(worldIn, pos, clr, flowerZ.getColor());
        }
        if (blockNZ instanceof EdenFlower) {
            EdenFlower flowerNZ = (EdenFlower)blockNZ;
            this.mateFlowers(worldIn, pos, clr, flowerNZ.getColor());
        }
    }

    private void mateFlowers(World worldIn, BlockPos pos, String clr1, String clr2) {
        if (clr1 == "" || clr2 == "") {
            return;
        }
        EdenFlower flower = null;
        if (this.checkColors("red", "white", clr1, clr2)) {
            flower = (EdenFlower)ZGBlocks.edenFlowerPink;
        } else if (this.checkColors("red", "blue", clr1, clr2)) {
            flower = (EdenFlower)ZGBlocks.edenFlowerPurple;
        } else if (this.checkColors("green", "blue", clr1, clr2)) {
            flower = (EdenFlower)ZGBlocks.edenFlowerYellow;
        } else if (this.checkColors("red", "red", clr1, clr2)) {
            flower = (EdenFlower)ZGBlocks.edenFlowerBlack;
        } else if (this.checkColors("red", "yellow", clr1, clr2)) {
            flower = (EdenFlower)ZGBlocks.edenFlowerOrange;
        } else if (this.checkColors("blue", "white", clr1, clr2)) {
            flower = (EdenFlower)ZGBlocks.edenFlowerCyan;
        } else if (this.checkColors("black", "black", clr1, clr2)) {
            flower = (EdenFlower)ZGBlocks.edenFlowerRed;
        }
        if (flower != null) {
            IBlockState flowerState = flower.func_176223_P();
            BlockPos posX1 = pos.func_177982_a(1, 0, 0);
            BlockPos posX2 = pos.func_177982_a(-1, 0, 0);
            BlockPos posZ1 = pos.func_177982_a(0, 0, 1);
            BlockPos posZ2 = pos.func_177982_a(0, 0, -1);
            BlockPos posXZ1 = pos.func_177982_a(1, 0, 1);
            BlockPos posXZ2 = pos.func_177982_a(-1, 0, -1);
            Block posBlockX1 = worldIn.func_180495_p(posX1).func_177230_c();
            Block posBlockX2 = worldIn.func_180495_p(posX2).func_177230_c();
            Block posBlockZ1 = worldIn.func_180495_p(posZ1).func_177230_c();
            Block posBlockZ2 = worldIn.func_180495_p(posZ2).func_177230_c();
            Block posBlockXZ1 = worldIn.func_180495_p(posXZ1).func_177230_c();
            Block posBlockXZ2 = worldIn.func_180495_p(posXZ2).func_177230_c();
            if (ZGHelper.getRNGChance(5, 10)) {
                this.plantFlower(worldIn, posX1, posBlockX1, flowerState);
            }
            if (ZGHelper.getRNGChance(5, 10)) {
                this.plantFlower(worldIn, posX2, posBlockX2, flowerState);
            }
            if (ZGHelper.getRNGChance(5, 10)) {
                this.plantFlower(worldIn, posZ1, posBlockZ1, flowerState);
            }
            if (ZGHelper.getRNGChance(5, 10)) {
                this.plantFlower(worldIn, posZ2, posBlockZ2, flowerState);
            }
            if (ZGHelper.getRNGChance(5, 10)) {
                this.plantFlower(worldIn, posXZ1, posBlockXZ1, flowerState);
            }
            if (ZGHelper.getRNGChance(5, 10)) {
                this.plantFlower(worldIn, posXZ2, posBlockXZ2, flowerState);
            }
        }
    }

    private void plantFlower(World worldIn, BlockPos pos, Block block, IBlockState flowerState) {
        if (block == Blocks.field_150350_a && this.canBlockStay(worldIn, pos, flowerState)) {
            worldIn.func_175656_a(pos, flowerState);
        }
    }

    private boolean checkColors(String clrSearch1, String clrSearch2, String clr1, String clr2) {
        return clr1 == clrSearch1 && clr2 == clrSearch2 || clr2 == clrSearch1 && clr1 == clrSearch2;
    }

    @Override
    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        BlockPos posD = pos.func_177977_b();
        IBlockState stateD = world.func_180495_p(posD);
        Block blockD = stateD.func_177230_c();
        return blockD instanceof ZGBlockGrass || blockD instanceof ZGBlockDirt;
    }

    public Block setColor(String clr) {
        this.COLOR = clr;
        return this;
    }

    public String getColor() {
        return this.COLOR;
    }
}

