/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.blocks.caligro;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import zollerngalaxy.blocks.ZGBlockEgg;
import zollerngalaxy.events.ZGSoundEvents;
import zollerngalaxy.mobs.entities.EntitySpiderling;

public class BlockSpiderEgg
extends ZGBlockEgg {
    protected int ticksEggExisted = 0;

    public BlockSpiderEgg() {
        super("spider_egg");
    }

    @Override
    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
        this.playHeartbeatSound(worldIn, pos);
    }

    @Override
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
        this.playHeartbeatSound(worldIn, pos);
        this.ticksEggExisted += 10;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.checkFall(worldIn, pos);
        int par2 = pos.func_177958_n();
        int par3 = pos.func_177956_o();
        int par4 = pos.func_177952_p();
        BlockPos soundPos = new BlockPos((double)par2 + 1.5, (double)par3 + 1.5, (double)par4 + 1.5);
        if (this.ticksEggExisted >= 500) {
            this.playHeartbeatSound(worldIn, soundPos);
            this.hatchSpider(worldIn, par2, par3, par4);
            this.ticksEggExisted = 0;
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 0);
        }
        this.ticksEggExisted += 10;
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
        this.playHeartbeatSound(worldIn, pos);
        return true;
    }

    public void hatchSpider(World par1World, int par2x, int par3y, int par4z) {
        int randInt = new Random().nextInt(4);
        randInt = randInt == 0 ? 1 : randInt;
        for (int i = 0; i < randInt; ++i) {
            if (par1World.field_72995_K) continue;
            EntitySpiderling spiderling = new EntitySpiderling(par1World);
            spiderling.func_70012_b(par2x + i, par3y + i, par4z + i, 0.0f, 0.0f);
            par1World.func_72838_d((Entity)spiderling);
        }
    }

    @Override
    public void hatchEgg(World par1World, BlockPos pos) {
        int posX = pos.func_177958_n();
        int posY = pos.func_177956_o();
        int posZ = pos.func_177952_p();
        this.hatchSpider(par1World, posX, posY, posZ);
    }

    private void playHeartbeatSound(World worldIn, BlockPos pos) {
        float soundPitch = worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f;
        SoundEvent soundEvent = ZGSoundEvents.SPIDERLING_EGG_HEARTBEAT;
        worldIn.func_184133_a(null, pos, soundEvent, SoundCategory.AMBIENT, 1.5f, soundPitch);
    }
}

