/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.blocks.caligro;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import zollerngalaxy.blocks.ZGBlockBase;
import zollerngalaxy.core.ZollernGalaxyCore;
import zollerngalaxy.core.enums.EnumBlockType;
import zollerngalaxy.items.ZGItems;
import zollerngalaxy.lib.helpers.ZGHelper;
import zollerngalaxy.mobs.entities.boss.EntityShadowAlien;
import zollerngalaxy.proxy.IProxy;
import zollerngalaxy.util.ZGUtils;

public class BlockShadowBossSpawner
extends ZGBlockBase {
    protected Item unlockItem = ZGItems.shadeKey;
    protected String unlockMsg = ZGUtils.translate("tooltips.shadekey");
    private IProxy proxy;

    public BlockShadowBossSpawner() {
        super("shadowspawner", 10.0f);
        ZollernGalaxyCore.instance();
        this.proxy = ZollernGalaxyCore.proxy;
        this.func_149722_s();
        this.setMaterial(Material.field_151573_f);
        this.func_149672_a(SoundType.field_185858_k);
        this.setBlockType(EnumBlockType.SPAWNER);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
        EnumHand currentHand = playerIn.func_184600_cs();
        if (currentHand != null) {
            ItemStack heldItemStack = playerIn.func_184586_b(currentHand);
            Item heldItem = heldItemStack.func_77973_b();
            if (heldItemStack != null && heldItem == ZGItems.shadeKey) {
                InventoryPlayer playerInventory = playerIn.field_71071_by;
                if (playerInventory.func_70431_c(new ItemStack(ZGItems.shadeKey)) && !playerIn.field_71075_bZ.field_75098_d) {
                    int invSlot = playerInventory.func_184429_b(new ItemStack(ZGItems.shadeKey));
                    playerInventory.func_174925_a(ZGItems.shadeKey, -1, 1, null);
                }
                this.spawnMob(worldIn, playerIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            } else {
                this.proxy.sendChatMessage(playerIn, this.unlockMsg);
            }
        } else {
            this.proxy.sendChatMessage(playerIn, this.unlockMsg);
        }
        return true;
    }

    public void spawnMob(World worldIn, EntityPlayer playerIn, double x, double y, double z) {
        if (!worldIn.field_72995_K) {
            if (worldIn.func_175659_aa() != EnumDifficulty.PEACEFUL) {
                EntityShadowAlien shadowBoss = new EntityShadowAlien(worldIn);
                ZGHelper.spawnEntity((Entity)shadowBoss, worldIn, x, y, z);
                this.proxy.sendChatMessage(playerIn, ZGUtils.translate("tooltips.beastawoken"));
                worldIn.func_175656_a(new BlockPos(x, y, z), Blocks.field_150350_a.func_176223_P());
            } else {
                this.proxy.sendChatMessage(playerIn, ZGUtils.translate("tooltips.mobnotpeaceful"));
            }
        }
    }

    public Item getUnlockItem() {
        return this.unlockItem;
    }

    public Block setUnlockItem(Item itemIn) {
        this.unlockItem = itemIn;
        return this;
    }
}

