/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import zollerngalaxy.blocks.ZGBlockOre;
import zollerngalaxy.items.ZGItems;
import zollerngalaxy.lib.helpers.ZGHelper;

public class ZGOreGem
extends ZGBlockOre {
    protected int minDropped;
    protected int maxDropped;
    protected Item itemToDrop;
    protected int droppedMetadata;
    protected boolean itemHasMetadata;

    public ZGOreGem(String blockName, float hardResist, Item gemItem) {
        super(blockName, hardResist);
        this.minDropped = this.enableExtremeMode ? 4 : 2;
        this.maxDropped = this.enableExtremeMode ? 8 : 4;
        this.itemToDrop = ZGItems.sapphire;
        this.droppedMetadata = 0;
        this.itemHasMetadata = false;
        this.itemToDrop = gemItem;
        this.setDroppedItemHasMetadata(this.itemHasMetadata);
    }

    public Block setDropMeta(int droppedMeta, boolean hasMeta) {
        this.itemHasMetadata = hasMeta;
        if (this.itemHasMetadata) {
            this.droppedMetadata = droppedMeta;
        }
        return this;
    }

    public Block setDroppedItemHasMetadata(boolean hasMetadata) {
        this.itemHasMetadata = hasMetadata;
        return this;
    }

    public boolean getDroppedItemHasMetadata() {
        return this.itemHasMetadata;
    }

    public Block setDroppedMetadata(int md) {
        this.droppedMetadata = md;
        return this;
    }

    public int getDroppedMetadata() {
        return this.droppedMetadata;
    }

    public Item func_180660_a(IBlockState par1BlockState, Random rand, int fortune) {
        return this.itemToDrop;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        int j = ZGHelper.rngInt(this.getMinDropped(), this.getMaxDropped());
        for (int k = 0; k < j; ++k) {
            drops.add((Object)new ItemStack(this.itemToDrop, 1, this.droppedMetadata));
        }
    }

    public Block setMinMaxDropped(int minD, int maxD) {
        this.setMinDropped(minD);
        this.setMaxDropped(maxD);
        return this;
    }

    public Block setMaxDropped(int md) {
        this.maxDropped = md;
        return this;
    }

    public Block setMinDropped(int md) {
        this.minDropped = md;
        return this;
    }

    public int getMinDropped() {
        return this.minDropped;
    }

    public int getMaxDropped() {
        return this.maxDropped;
    }

    public int func_149745_a(Random rand) {
        int numDropped = 1;
        int extMod = this.enableExtremeMode ? 1 : 0;
        switch (this.getBlockTier()) {
            default: {
                numDropped = ZGHelper.rngInt(1, 1);
                break;
            }
            case ONE: {
                numDropped = ZGHelper.rngInt(this.minDropped + extMod, this.maxDropped + extMod);
                break;
            }
            case TWO: {
                numDropped = ZGHelper.rngInt(this.maxDropped + extMod, this.maxDropped + 2 + extMod);
                break;
            }
            case THREE: {
                numDropped = ZGHelper.rngInt(this.maxDropped + 2 + extMod, this.maxDropped + 3 + extMod);
                break;
            }
            case FOUR: {
                numDropped = ZGHelper.rngInt(this.maxDropped + 4 + extMod, this.maxDropped + 5 + extMod);
            }
        }
        return numDropped;
    }

    public int func_149679_a(int fortune, Random random) {
        if (fortune > 0 && Item.func_150898_a((Block)this) != this.func_180660_a((IBlockState)this.func_176194_O().func_177619_a().iterator().next(), random, fortune)) {
            int i = random.nextInt(fortune + 2) - 1;
            if (i < 0) {
                i = 1;
            }
            return this.func_149745_a(random) * i;
        }
        return this.func_149745_a(random);
    }

    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        int extMod = this.enableExtremeMode ? 2 : 0;
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        return MathHelper.func_76136_a((Random)rand, (int)(3 + extMod), (int)(7 + extMod));
    }
}

