/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.terraingen.TerrainGen;
import zollerngalaxy.blocks.ZGBlockDirt;
import zollerngalaxy.blocks.ZGBlockFlower;
import zollerngalaxy.blocks.ZGBlockGrass;
import zollerngalaxy.core.ZollernGalaxyCore;
import zollerngalaxy.core.enums.EnumBlockType;
import zollerngalaxy.lib.helpers.json.JSONFactory;

public class ZGBlockSapling
extends ZGBlockFlower
implements IGrowable,
IPlantable {
    public static final PropertyInteger STAGE = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)1);
    protected static double val1;
    protected static double val2;
    protected static double val3;
    protected static double val4;
    protected static double val5;
    protected static final AxisAlignedBB SAPLING_AABB;
    protected WorldGenerator treeGen;

    public ZGBlockSapling(String blockName, WorldGenerator genTree) {
        super(blockName);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
        this.setMaterial(Material.field_151582_l);
        this.setBlockType(EnumBlockType.SAPLING);
        this.func_149675_a(true);
        this.treeGen = genTree;
        if (ZollernGalaxyCore.instance().isInDevMode()) {
            JSONFactory.registerSapling(blockName);
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STAGE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf((meta & 8) >> 3));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        return i |= (Integer)state.func_177229_b((IProperty)STAGE) << 3;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SAPLING_AABB;
    }

    @Override
    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            super.func_180650_b(worldIn, pos, state, rand);
            this.checkAndDropBlock(worldIn, pos, state);
            if (!worldIn.func_175697_a(pos, 1)) {
                return;
            }
            if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
                this.grow(worldIn, pos, state, rand);
            }
        }
    }

    public void grow(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if ((Integer)state.func_177229_b((IProperty)STAGE) == 0) {
            worldIn.func_180501_a(pos, state.func_177231_a((IProperty)STAGE), 4);
        } else {
            this.generateTree(worldIn, pos, state, rand);
        }
    }

    public boolean isSoil(Block soilBlock) {
        return soilBlock instanceof ZGBlockGrass || soilBlock instanceof ZGBlockDirt;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        Block soilBlock = soil.func_177230_c();
        return this.isSoil(soilBlock);
    }

    @Override
    protected void checkAndDropBlock(World world, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(world, pos, state)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        this.checkAndDropBlock(world, pos, state);
    }

    @Override
    public boolean canBlockStay(World worldIn, BlockPos pos, IBlockState state) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        Block soilBlock = soil.func_177230_c();
        return this.isSoil(soilBlock);
    }

    public void generateTree(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!TerrainGen.saplingGrowTree((World)worldIn, (Random)rand, (BlockPos)pos)) {
            return;
        }
        WorldGenerator worldgenerator = this.treeGen;
        int i = 0;
        int j = 0;
        boolean flag = true;
        IBlockState iblockstate2 = Blocks.field_150350_a.func_176223_P();
        if (flag) {
            worldIn.func_180501_a(pos.func_177982_a(i, 0, j), iblockstate2, 4);
            worldIn.func_180501_a(pos.func_177982_a(i + 1, 0, j), iblockstate2, 4);
            worldIn.func_180501_a(pos.func_177982_a(i, 0, j + 1), iblockstate2, 4);
            worldIn.func_180501_a(pos.func_177982_a(i + 1, 0, j + 1), iblockstate2, 4);
        } else {
            worldIn.func_180501_a(pos, iblockstate2, 4);
        }
        if (!worldgenerator.func_180709_b(worldIn, rand, pos.func_177982_a(i, 0, j))) {
            if (flag) {
                worldIn.func_180501_a(pos.func_177982_a(i, 0, j), state, 4);
                worldIn.func_180501_a(pos.func_177982_a(i + 1, 0, j), state, 4);
                worldIn.func_180501_a(pos.func_177982_a(i, 0, j + 1), state, 4);
                worldIn.func_180501_a(pos.func_177982_a(i + 1, 0, j + 1), state, 4);
            } else {
                worldIn.func_180501_a(pos, state, 4);
            }
        }
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return (double)worldIn.field_73012_v.nextFloat() < 0.45;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        this.grow(worldIn, pos, state, rand);
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Plains;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_176223_P();
        }
        return state;
    }

    static {
        val2 = val1 = 0.09999999403953552;
        val4 = val3 = (double)0.9f;
        val5 = 0.8f;
        SAPLING_AABB = new AxisAlignedBB(val1, 0.0, val2, val3, val5, val4);
    }
}

