/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.blocks;

import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zollerngalaxy.blocks.ZGBlockBase;
import zollerngalaxy.core.ZollernGalaxyCore;
import zollerngalaxy.core.enums.EnumBlockType;
import zollerngalaxy.lib.helpers.json.JSONFactory;

public class ZGBlockLeaves
extends ZGBlockBase
implements IShearable {
    protected boolean CHECK_DECAY = false;
    protected boolean DECAYABLE = true;
    protected boolean leavesFancy;
    protected Block droppedSapling;
    protected Item droppedFruit = null;
    int[] surroundings;

    public ZGBlockLeaves(String blockName, float hardResist, Block sapling) {
        super(blockName, hardResist);
        this.setMaterial(Material.field_151584_j);
        this.setSound(SoundType.field_185850_c);
        this.setBlockType(EnumBlockType.LEAVES);
        this.func_149675_a(true);
        this.func_149713_g(1);
        this.droppedSapling = sapling;
        this.setShouldJSONIgnore(true);
        if (ZollernGalaxyCore.instance().isInDevMode()) {
            JSONFactory.registerLeaves(blockName);
        }
    }

    public ZGBlockLeaves(String blockName, Block sapling) {
        this(blockName, 0.4f, sapling);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        int i1;
        int l;
        boolean i = true;
        int j = 2;
        int k = pos.func_177958_n();
        if (worldIn.func_175707_a(new BlockPos(k - 2, (l = pos.func_177956_o()) - 2, (i1 = pos.func_177952_p()) - 2), new BlockPos(k + 2, l + 2, i1 + 2))) {
            for (int j1 = -1; j1 <= 1; ++j1) {
                for (int k1 = -1; k1 <= 1; ++k1) {
                    for (int l1 = -1; l1 <= 1; ++l1) {
                        BlockPos blockpos = pos.func_177982_a(j1, k1, l1);
                        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
                        if (!iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)worldIn, blockpos)) continue;
                        iblockstate.func_177230_c().beginLeavesDecay(iblockstate, worldIn, blockpos);
                    }
                }
            }
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            this.CHECK_DECAY = true;
            if (this.CHECK_DECAY && this.DECAYABLE) {
                int l2;
                int i = 4;
                int j = 5;
                int k = pos.func_177958_n();
                int l = pos.func_177956_o();
                int i1 = pos.func_177952_p();
                int j1 = 32;
                int k1 = 1024;
                int l1 = 16;
                if (this.surroundings == null) {
                    this.surroundings = new int[32768];
                }
                if (!worldIn.func_175697_a(pos, 1)) {
                    return;
                }
                if (worldIn.func_175697_a(pos, 6)) {
                    BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                    for (int i2 = -4; i2 <= 4; ++i2) {
                        for (int j2 = -4; j2 <= 4; ++j2) {
                            for (int k2 = -4; k2 <= 4; ++k2) {
                                IBlockState iblockstate = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(k + i2, l + j2, i1 + k2));
                                Block block = iblockstate.func_177230_c();
                                if (!block.canSustainLeaves(iblockstate, (IBlockAccess)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(k + i2, l + j2, i1 + k2))) {
                                    if (block.isLeaves(iblockstate, (IBlockAccess)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(k + i2, l + j2, i1 + k2))) {
                                        this.surroundings[(i2 + 16) * 1024 + (j2 + 16) * 32 + k2 + 16] = -2;
                                        continue;
                                    }
                                    this.surroundings[(i2 + 16) * 1024 + (j2 + 16) * 32 + k2 + 16] = -1;
                                    continue;
                                }
                                this.surroundings[(i2 + 16) * 1024 + (j2 + 16) * 32 + k2 + 16] = 0;
                            }
                        }
                    }
                    for (int i3 = 1; i3 <= 4; ++i3) {
                        for (int j3 = -4; j3 <= 4; ++j3) {
                            for (int k3 = -4; k3 <= 4; ++k3) {
                                for (int l3 = -4; l3 <= 4; ++l3) {
                                    if (this.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + l3 + 16] != i3 - 1) continue;
                                    if (this.surroundings[(j3 + 16 - 1) * 1024 + (k3 + 16) * 32 + l3 + 16] == -2) {
                                        this.surroundings[(j3 + 16 - 1) * 1024 + (k3 + 16) * 32 + l3 + 16] = i3;
                                    }
                                    if (this.surroundings[(j3 + 16 + 1) * 1024 + (k3 + 16) * 32 + l3 + 16] == -2) {
                                        this.surroundings[(j3 + 16 + 1) * 1024 + (k3 + 16) * 32 + l3 + 16] = i3;
                                    }
                                    if (this.surroundings[(j3 + 16) * 1024 + (k3 + 16 - 1) * 32 + l3 + 16] == -2) {
                                        this.surroundings[(j3 + 16) * 1024 + (k3 + 16 - 1) * 32 + l3 + 16] = i3;
                                    }
                                    if (this.surroundings[(j3 + 16) * 1024 + (k3 + 16 + 1) * 32 + l3 + 16] == -2) {
                                        this.surroundings[(j3 + 16) * 1024 + (k3 + 16 + 1) * 32 + l3 + 16] = i3;
                                    }
                                    if (this.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + (l3 + 16 - 1)] == -2) {
                                        this.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + (l3 + 16 - 1)] = i3;
                                    }
                                    if (this.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + l3 + 16 + 1] != -2) continue;
                                    this.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + l3 + 16 + 1] = i3;
                                }
                            }
                        }
                    }
                }
                if ((l2 = this.surroundings[16912]) >= 0) {
                    worldIn.func_180501_a(pos, state, 4);
                } else {
                    this.destroy(worldIn, pos);
                }
            }
            this.CHECK_DECAY = false;
        }
    }

    private void destroy(World worldIn, BlockPos pos) {
        this.func_176226_b(worldIn, pos, worldIn.func_180495_p(pos), 0);
        worldIn.func_175698_g(pos);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (worldIn.func_175727_C(pos.func_177984_a()) && !worldIn.func_180495_p(pos.func_177977_b()).func_185896_q() && rand.nextInt(15) == 1) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (double)pos.func_177956_o() - 0.05;
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            worldIn.func_175688_a(EnumParticleTypes.DRIP_WATER, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public int func_149745_a(Random random) {
        return random.nextInt(20) == 0 ? 1 : 0;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this.droppedSapling);
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        super.func_180653_a(worldIn, pos, state, chance, fortune);
    }

    protected void dropFruit(World worldIn, BlockPos pos, IBlockState state, int chance) {
    }

    protected int getSaplingDropChance(IBlockState state) {
        return 60;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void setGraphicsLevel(boolean fancy) {
        this.leavesFancy = fancy;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public boolean isLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public void beginLeavesDecay(IBlockState state, World world, BlockPos pos) {
        if (!this.CHECK_DECAY) {
            world.func_180501_a(pos, state, 4);
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemStack drop;
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        int chance = this.getSaplingDropChance(state);
        if (fortune > 0 && (chance -= 2 << fortune) < 10) {
            chance = 10;
        }
        if (rand.nextInt(chance) == 0 && !(drop = new ItemStack(this.func_180660_a(state, rand, fortune), 1, this.func_180651_a(state))).func_190926_b()) {
            drops.add((Object)drop);
        }
        chance = 200;
        if (fortune > 0 && (chance -= 10 << fortune) < 40) {
            chance = 40;
        }
        this.captureDrops(true);
        if (world instanceof World) {
            this.dropFruit((World)world, pos, state, chance);
        }
        drops.addAll((Collection)this.captureDrops(false));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return !this.leavesFancy && blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() == this ? false : super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return null;
    }

    @Override
    public boolean shouldJSONIgnore() {
        return true;
    }
}

