/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zollerngalaxy.blocks.ZGBlockBase;
import zollerngalaxy.core.enums.EnumHarvestLevelZG;
import zollerngalaxy.core.enums.EnumHarvestToolZG;

public class ZGBlockFalling
extends ZGBlockBase {
    public static boolean fallInstantly;

    public ZGBlockFalling(String blockName, float hardResist) {
        super(blockName, hardResist);
        this.setMaterial(Material.field_151595_p);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            this.checkFallable(worldIn, pos);
        }
    }

    private void checkFallable(World worldIn, BlockPos pos) {
        if ((worldIn.func_175623_d(pos.func_177977_b()) || ZGBlockFalling.canFallThrough(worldIn.func_180495_p(pos.func_177977_b()))) && pos.func_177956_o() >= 0) {
            int i = 32;
            if (!fallInstantly && worldIn.func_175707_a(pos.func_177982_a(-32, -32, -32), pos.func_177982_a(32, 32, 32))) {
                if (!worldIn.field_72995_K) {
                    EntityFallingBlock entityfallingblock = new EntityFallingBlock(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, worldIn.func_180495_p(pos));
                    this.onStartFalling(entityfallingblock);
                    worldIn.func_72838_d((Entity)entityfallingblock);
                }
            } else {
                IBlockState state = worldIn.func_180495_p(pos);
                worldIn.func_175698_g(pos);
                BlockPos blockpos = pos.func_177977_b();
                while ((worldIn.func_175623_d(blockpos) || ZGBlockFalling.canFallThrough(worldIn.func_180495_p(blockpos))) && blockpos.func_177956_o() > 0) {
                    blockpos = blockpos.func_177977_b();
                }
                if (blockpos.func_177956_o() > 0) {
                    worldIn.func_175656_a(blockpos.func_177984_a(), state);
                }
            }
        }
    }

    protected void onStartFalling(EntityFallingBlock fallingEntity) {
    }

    @Override
    public int func_149738_a(World worldIn) {
        return 2;
    }

    public static boolean canFallThrough(IBlockState state) {
        Block block = state.func_177230_c();
        Material material = state.func_185904_a();
        return block == Blocks.field_150480_ab || material == Material.field_151579_a || material == Material.field_151586_h || material == Material.field_151587_i;
    }

    public void onEndFalling(World worldIn, BlockPos pos) {
    }

    public void onBroken(World p_190974_1_, BlockPos p_190974_2_) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        BlockPos blockpos;
        if (rand.nextInt(16) == 0 && ZGBlockFalling.canFallThrough(worldIn.func_180495_p(blockpos = pos.func_177977_b()))) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (double)pos.func_177956_o() - 0.05;
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            worldIn.func_175688_a(EnumParticleTypes.FALLING_DUST, d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)stateIn)});
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getDustColor(IBlockState p_189876_1_) {
        return -16777216;
    }

    @Override
    public int getHarvestLevel(IBlockState state) {
        return EnumHarvestLevelZG.IRON.getHarvestLevel();
    }

    @Override
    public String getHarvestTool(IBlockState state) {
        return EnumHarvestToolZG.SHOVEL.getHarvestTool();
    }
}

