/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.blocks;

import java.util.Random;
import micdoodle8.mods.galacticraft.api.block.ITerraformableBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zollerngalaxy.blocks.IJSONBlock;
import zollerngalaxy.blocks.ISingleZGBlockRender;
import zollerngalaxy.blocks.caligro.corrupted.ICorruptBlock;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.enums.EnumBlockType;
import zollerngalaxy.core.enums.EnumHarvestLevelZG;
import zollerngalaxy.core.enums.EnumHarvestToolZG;
import zollerngalaxy.creativetabs.ZGTabs;
import zollerngalaxy.items.ZGItems;
import zollerngalaxy.lib.helpers.ZGHelper;
import zollerngalaxy.lib.helpers.json.JSONFactory;
import zollerngalaxy.potions.ZGPotions;
import zollerngalaxy.util.ZGDamageSrc;

public class ZGBlockBase
extends Block
implements ISingleZGBlockRender,
IJSONBlock,
ITerraformableBlock {
    protected static Material blockMaterial = Material.field_151576_e;
    protected static SoundType blockSound = SoundType.field_185851_d;
    protected EnumBlockType blockType = EnumBlockType.NORMAL;
    protected boolean enableExtremeMode = ConfigManagerZG.enableExtremeMode;
    protected boolean enableExplosiveOres = ConfigManagerZG.enableExplosiveOres;
    protected boolean enablePotionEffectOres = ConfigManagerZG.enablePotionEffectOres;
    protected boolean chainReactionEnabled = ConfigManagerZG.shouldExplosiveBlocksExplodeOtherBlocks;
    protected boolean isExplosive = false;
    protected int explosionWeight = this.enableExtremeMode ? 20 : 40;
    protected boolean hasPotionEffect = false;
    protected Potion blockPotionEffect;
    protected boolean shouldAlwaysBurn = false;
    protected boolean isHotFloorBlock = false;
    protected boolean hasInfo = false;
    protected boolean shouldJSONIgnore = false;
    protected boolean isSolidColor = true;
    protected boolean hasParticles = false;
    protected EnumParticleTypes particleType = EnumParticleTypes.SMOKE_NORMAL;
    protected String[] blockInfo;
    protected static String name;
    protected int harvestLvl = EnumHarvestLevelZG.DIAMOND.getHarvestLevel();
    protected Random rand = new Random();

    public ZGBlockBase(String blockName, float hardResist) {
        super(Material.field_151576_e);
        float f = this.enableExtremeMode ? 2.0f : 1.0f;
        name = blockName;
        this.setBlockName(this, blockName);
        this.setHardResist(hardResist *= f);
        this.func_149672_a(blockSound);
        this.setBlockType(this.blockType);
        this.func_149675_a(true);
        this.field_149785_s = false;
        if (!this.shouldJSONIgnore()) {
            JSONFactory.registerBlock(blockName);
        }
    }

    public ZGBlockBase(String blockName) {
        this(blockName, 2.6f);
    }

    public void setBlockName(Block block, String blockName) {
        block.func_149663_c(blockName);
    }

    public Block setSound(SoundType bSound) {
        this.field_149762_H = bSound;
        return this;
    }

    public SoundType getSound() {
        return blockSound;
    }

    public boolean hasInfo() {
        return this.hasInfo;
    }

    public String[] getInfo() {
        return this.blockInfo;
    }

    public Block setInfo(String ... info) {
        this.blockInfo = info;
        return this;
    }

    public Block setHardResist(float hard, float resist) {
        this.func_149711_c(hard);
        this.func_149752_b(resist);
        return this;
    }

    public Block setHardResist(float hardResist) {
        this.func_149711_c(hardResist);
        this.func_149752_b(hardResist);
        return this;
    }

    public Block setIsHotBlock(boolean par1HotBlock) {
        this.isHotFloorBlock = par1HotBlock;
        return this;
    }

    public boolean getIsHotBlock() {
        return this.isHotFloorBlock;
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        if (!entityIn.func_70045_F() && entityIn instanceof EntityLivingBase && !EnchantmentHelper.func_189869_j((EntityLivingBase)((EntityLivingBase)entityIn)) && this.getIsHotBlock()) {
            entityIn.func_70097_a(DamageSource.field_190095_e, this.enableExtremeMode ? 8.2f : 4.5f);
        }
        if (entityIn instanceof EntityPlayer) {
            ICorruptBlock corruptBlock;
            EntityPlayer player = (EntityPlayer)entityIn;
            if (!player.field_71075_bZ.field_75098_d && this instanceof ICorruptBlock && (corruptBlock = (ICorruptBlock)((Object)this)).canCorrupt()) {
                ZGDamageSrc corruption = ZGDamageSrc.deathCorruption;
                if (!player.func_70644_a(ZGPotions.antiCorruption)) {
                    Item blueprintItem = ZGItems.blueprintCorruption;
                    ZGHelper.performBlueprintCheck(this.rand, blueprintItem, player, corruption);
                }
            }
        }
        super.func_176199_a(worldIn, pos, entityIn);
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        return this.getShouldAlwaysBurn() && side == EnumFacing.UP;
    }

    public Block setShouldAlwaysBurn(boolean shouldBurn) {
        this.shouldAlwaysBurn = shouldBurn;
        return this;
    }

    public boolean getShouldAlwaysBurn() {
        return this.shouldAlwaysBurn;
    }

    public Block setExplosionChance(int par1ExplosionChance) {
        if (this.enableExplosiveOres) {
            this.explosionWeight = par1ExplosionChance;
        }
        return this;
    }

    public int getExplosionChance() {
        if (this.enableExplosiveOres) {
            int scaleBy = this.enableExtremeMode ? 10 : 0;
            int expWeight = this.explosionWeight - scaleBy;
            expWeight = expWeight < 0 ? 1 : expWeight;
            return expWeight;
        }
        return 0;
    }

    public Block setShouldExplode(boolean shouldExplode, int explodeChance) {
        if (this.enableExplosiveOres) {
            this.setShouldExplode(shouldExplode);
            this.setExplosionChance(explodeChance);
        }
        return this;
    }

    public Block setShouldExplode(boolean shouldExplode) {
        this.isExplosive = shouldExplode && this.enableExplosiveOres;
        return this;
    }

    public boolean getShouldExplode() {
        return this.isExplosive && this.enableExplosiveOres;
    }

    public Block setShouldGivePotionEffect(boolean shouldGivePotionEffect, Potion potionEffect) {
        if (this.enablePotionEffectOres) {
            this.hasPotionEffect = shouldGivePotionEffect;
            this.blockPotionEffect = potionEffect;
        }
        return this;
    }

    public boolean getShouldGivePotionEffect() {
        return this.hasPotionEffect && this.enablePotionEffectOres;
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            if (this.getShouldExplode() && this.rand.nextInt(100) <= this.getExplosionChance() && this.enableExplosiveOres) {
                float explosionStrength = this.enableExtremeMode ? 6.0f : 2.5f;
                worldIn.func_72876_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), explosionStrength, true);
            }
            if (this.getShouldGivePotionEffect() && this.enablePotionEffectOres) {
                EntityPlayer player;
                boolean determineCondition;
                boolean bl = this.enableExtremeMode ? this.rand.nextInt(5) <= 2 : (determineCondition = this.rand.nextInt(10) <= 5);
                if (determineCondition && (player = worldIn.func_184137_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 2.5, false)) != null && this.blockPotionEffect != null) {
                    int duration = this.enableExtremeMode ? 400 : 200;
                    player.func_70690_d(new PotionEffect(this.blockPotionEffect, duration));
                }
            }
        }
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        if (!worldIn.field_72995_K && this.getShouldExplode() && this.chainReactionEnabled && this.enableExplosiveOres) {
            int chainReactionChance;
            int n = chainReactionChance = this.enableExtremeMode ? 4 : 8;
            if (this.rand.nextInt(this.getExplosionChance()) <= 8) {
                float explosionStrength = this.enableExtremeMode ? 8.4f : 3.2f;
                worldIn.func_72876_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), explosionStrength, true);
            }
        }
    }

    public Block setBlockHarvestLevel(String toolClass, int level) {
        this.harvestLvl = level;
        this.setHarvestLevel(toolClass, level, this.func_176223_P());
        return this;
    }

    public Block setMaterial(Material material) {
        blockMaterial = material;
        return this;
    }

    public Block setTransparent() {
        this.setIsOpaque(false);
        return this;
    }

    public Block setIsOpaque(boolean isSolidColorIn) {
        this.isSolidColor = isSolidColorIn;
        return this;
    }

    public Material func_149688_o(IBlockState block) {
        return blockMaterial;
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_149708_J() {
        return ZGTabs.zgBlocksTab;
    }

    @Override
    public String getName() {
        return name.toLowerCase();
    }

    @Override
    public boolean shouldJSONIgnore() {
        return false;
    }

    public Block setShouldJSONIgnore(boolean ignore) {
        this.shouldJSONIgnore = ignore;
        return this;
    }

    public Block setBlockType(EnumBlockType bType) {
        this.blockType = bType;
        return this;
    }

    public EnumBlockType getBlockType() {
        return this.blockType;
    }

    public Block setSlipperiness(float slipRate) {
        this.field_149765_K = slipRate;
        return this;
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return true;
    }

    public boolean func_149703_v() {
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    public int getHarvestLevel(IBlockState state) {
        return this.harvestLvl;
    }

    public String getHarvestTool(IBlockState state) {
        return EnumHarvestToolZG.PICKAXE.getHarvestTool();
    }

    public boolean isTerraformable(World world, BlockPos pos) {
        return true;
    }

    public Block setHasParticles(boolean hasParticlesIn) {
        this.hasParticles = hasParticlesIn;
        return this;
    }

    public Block setHasParticles(boolean hasParticlesIn, EnumParticleTypes particleTypeIn) {
        this.setHasParticles(hasParticlesIn);
        this.particleType = particleTypeIn;
        return this;
    }

    public boolean getHasParticles() {
        return this.hasParticles;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (this.getHasParticles()) {
            this.spawnParticles(worldIn, pos);
        }
    }

    public int func_149738_a(World worldIn) {
        return 30;
    }

    private void spawnParticles(World worldIn, BlockPos pos) {
        if (this.getHasParticles()) {
            Random random = worldIn.field_73012_v;
            double d0 = 0.0625;
            for (int i = 0; i < 6; ++i) {
                double d1 = (float)pos.func_177958_n() + random.nextFloat();
                double d2 = (float)pos.func_177956_o() + random.nextFloat();
                double d3 = (float)pos.func_177952_p() + random.nextFloat();
                if (i == 0 && !worldIn.func_180495_p(pos.func_177984_a()).func_185914_p()) {
                    d2 = (double)pos.func_177956_o() + 0.0625 + 1.0;
                }
                if (i == 1 && !worldIn.func_180495_p(pos.func_177977_b()).func_185914_p()) {
                    d2 = (double)pos.func_177956_o() - 0.0625;
                }
                if (i == 2 && !worldIn.func_180495_p(pos.func_177968_d()).func_185914_p()) {
                    d3 = (double)pos.func_177952_p() + 0.0625 + 1.0;
                }
                if (i == 3 && !worldIn.func_180495_p(pos.func_177978_c()).func_185914_p()) {
                    d3 = (double)pos.func_177952_p() - 0.0625;
                }
                if (i == 4 && !worldIn.func_180495_p(pos.func_177974_f()).func_185914_p()) {
                    d1 = (double)pos.func_177958_n() + 0.0625 + 1.0;
                }
                if (i == 5 && !worldIn.func_180495_p(pos.func_177976_e()).func_185914_p()) {
                    d1 = (double)pos.func_177958_n() - 0.0625;
                }
                if (!(d1 < (double)pos.func_177958_n() || d1 > (double)(pos.func_177958_n() + 1) || d2 < 0.0 || d2 > (double)(pos.func_177956_o() + 1) || d3 < (double)pos.func_177952_p()) && !(d3 > (double)(pos.func_177952_p() + 1))) continue;
                worldIn.func_175688_a(EnumParticleTypes.REDSTONE, d1, d2, d3, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }
}

