/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zollerngalaxy.blocks.ZGBlockBase;
import zollerngalaxy.core.ZollernGalaxyCore;
import zollerngalaxy.core.enums.EnumBlockType;
import zollerngalaxy.items.ZGItems;
import zollerngalaxy.lib.helpers.CommonZGRegisterHelper;
import zollerngalaxy.proxy.IProxy;
import zollerngalaxy.util.LoreBook;
import zollerngalaxy.util.ZGLore;
import zollerngalaxy.util.ZGUtils;

public class LoreBlock
extends ZGBlockBase {
    private IProxy proxy = ZollernGalaxyCore.proxy;

    public LoreBlock() {
        super("loreblock");
        this.func_149722_s();
        this.setBlockType(EnumBlockType.SPACE);
        this.func_149715_a(1.0f);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            if (playerIn.func_184586_b(hand).func_77973_b() == ZGItems.OMNITOOL) {
                try {
                    LoreBook loreBook = ZGLore.getRandomLoreBook();
                    int bookID = loreBook.getBookID();
                    ItemStack book = new ItemStack(Items.field_151164_bB);
                    NBTTagCompound nbt = new NBTTagCompound();
                    NBTTagList bookPages = new NBTTagList();
                    book.func_77983_a("author", (NBTBase)new NBTTagString("Zollern Wolf"));
                    book.func_77983_a("title", (NBTBase)new NBTTagString("Lore Book #" + bookID + ": " + loreBook.getTitle()));
                    List<String> pages = loreBook.getPages();
                    pages.forEach(page -> {
                        TextComponentString cmp = new TextComponentString(page);
                        String strPage = ITextComponent.Serializer.func_150696_a((ITextComponent)cmp);
                        NBTTagString strNBT = new NBTTagString(strPage);
                        bookPages.func_74742_a((NBTBase)strNBT);
                    });
                    NBTTagCompound cmp = book.func_77978_p();
                    cmp.func_74782_a("pages", (NBTBase)bookPages);
                    String txtFormat = TextFormatting.GOLD + "" + TextFormatting.BOLD;
                    playerIn.func_191521_c(book);
                    worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                    this.proxy.sendChatMessage(playerIn, txtFormat + ZGUtils.translate("tooltips.loreblock6"));
                    this.proxy.sendChatMessage(playerIn, txtFormat + ZGUtils.translate("tooltips.loreblock7") + " " + loreBook.getTitle());
                }
                catch (IllegalArgumentException ex) {
                    this.proxy.sendChatMessage(playerIn, TextFormatting.GRAY + ZGUtils.translate("tooltips.loreblock5"));
                }
            } else {
                this.proxy.sendChatMessage(playerIn, TextFormatting.AQUA + ZGUtils.translate("tooltips.loreblock4"));
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        if (CommonZGRegisterHelper.isControlKeyDown() || CommonZGRegisterHelper.isShiftKeyDown()) {
            tooltip.add(ZGUtils.translate("tooltips.loreblock"));
            tooltip.add(ZGUtils.translate("tooltips.loreblock2"));
            tooltip.add(ZGUtils.translate("tooltips.loreblock3"));
        } else {
            tooltip.add(ZGUtils.translate("tooltips.holdshift"));
        }
    }

    @Override
    public boolean shouldJSONIgnore() {
        return false;
    }
}

