/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zollerngalaxy.blocks.ZGBlockMetal;
import zollerngalaxy.blocks.fluids.ZGFluidBase;

public class BlockIngotStack
extends ZGBlockMetal {
    protected static final AxisAlignedBB INGOT_STACK_AABB = new AxisAlignedBB(0.0525, 0.0, 0.0525, 0.8575, 0.6, 0.8575);
    protected Item droppedItem = null;
    private final BlockIngotStack instance = this;

    public BlockIngotStack(String blockName, Item ingotIn) {
        super("ingotstack_" + blockName);
        this.droppedItem = ingotIn;
        this.setHardResist(6.0f, 10.0f);
        this.setMaterial(Material.field_151573_f);
        this.setShouldJSONIgnore(true);
    }

    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        Block block = world.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p())).func_177230_c();
        return block != Blocks.field_150350_a && block != this.instance && !(block instanceof ZGFluidBase);
    }

    public Item getDroppedItem() {
        return this.droppedItem;
    }

    public Block setDroppedItem(Item droppedItemIn) {
        this.droppedItem = droppedItemIn;
        return this;
    }

    public Item func_180660_a(IBlockState par1BlockState, Random rand, int fortune) {
        return this.droppedItem;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        int j = 7;
        for (int k = 0; k < j; ++k) {
            drops.add((Object)new ItemStack(this.droppedItem, 1, 0));
        }
    }

    public int func_149745_a(Random rand) {
        return 7;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return INGOT_STACK_AABB;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public boolean shouldJSONIgnore() {
        return true;
    }
}

