/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.biomes.metztli;

import java.util.Random;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBlockBlob;
import net.minecraft.world.gen.feature.WorldGenIcePath;
import net.minecraft.world.gen.feature.WorldGenIceSpike;
import net.minecraft.world.gen.feature.WorldGenMegaPineTree;
import net.minecraft.world.gen.feature.WorldGenTaiga1;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zollerngalaxy.biomes.metztli.BiomeHarranBase;
import zollerngalaxy.core.enums.EnumBiomeTypeZG;

public class BiomeHarranTundra
extends BiomeHarranBase {
    private final boolean superIcy = true;
    private final WorldGenIceSpike iceSpike = new WorldGenIceSpike();
    private final WorldGenIcePath icePath = new WorldGenIcePath(4);
    private static final WorldGenTaiga1 PINE_GENERATOR = new WorldGenTaiga1();
    private static final WorldGenTaiga2 SPRUCE_GENERATOR = new WorldGenTaiga2(false);
    private static final WorldGenMegaPineTree MEGA_PINE_GENERATOR = new WorldGenMegaPineTree(false, false);
    private static final WorldGenMegaPineTree MEGA_SPRUCE_GENERATOR = new WorldGenMegaPineTree(false, true);
    private static final WorldGenBlockBlob FOREST_ROCK_GENERATOR = new WorldGenBlockBlob(Blocks.field_150341_Y, 0);
    private final Type type;

    public BiomeHarranTundra(Biome.BiomeProperties props, Type typeIn) {
        super("harran_tundra", props);
        this.type = typeIn;
        this.setupBiome(props);
    }

    private void setupBiome(Biome.BiomeProperties props) {
        this.setTempCategory(Biome.TempCategory.COLD);
        props.func_185398_c(0.4f);
        props.func_185400_d(0.5f);
        props.func_185410_a(-1.5f);
        props.func_185411_b();
        this.setEnableSnow(true);
        this.setTemp(-20.52f);
        this.setBiomeHeight(32);
        this.setBiomeType(EnumBiomeTypeZG.ICY);
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityWolf.class, 8, 4, 4));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityRabbit.class, 10, 2, 3));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityPolarBear.class, 1, 1, 2));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityStray.class, 80, 4, 4));
        this.field_76766_R = true;
        this.biomeDecor.field_76808_K = true;
        this.biomeDecor.generateTrees = true;
        this.biomeDecor.generateMushroomTrees = false;
        this.biomeDecor.generateTallGrass = true;
        this.biomeDecor.generateWaterLilies = false;
        this.biomeDecor.generateDeadBushes = true;
        this.biomeDecor.deadBushesPerChunk = 1;
        this.biomeDecor.waterLakesPerChunk = 0;
        this.biomeDecor.lavaLakesPerChunk = 2;
        this.biomeDecor.field_76832_z = 10;
        grassFoliageColor = 3410210;
        this.field_76759_H = 139;
        this.field_76752_A = Blocks.field_150433_aE.func_176223_P();
        this.field_76753_B = DIRT;
        this.stoneBlock = Blocks.field_150348_b;
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        int k;
        int j;
        int i;
        ((Object)((Object)this)).getClass();
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (ChunkPos)new ChunkPos(pos), (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.ICE)) {
            for (i = 0; i < 3; ++i) {
                j = rand.nextInt(16) + 8;
                k = rand.nextInt(16) + 8;
                this.iceSpike.func_180709_b(worldIn, rand, worldIn.func_175645_m(pos.func_177982_a(j, 0, k)));
            }
            for (int l = 0; l < 2; ++l) {
                int i1 = rand.nextInt(16) + 8;
                int j1 = rand.nextInt(16) + 8;
                this.icePath.func_180709_b(worldIn, rand, worldIn.func_175645_m(pos.func_177982_a(i1, 0, j1)));
            }
        }
        if ((this.type == Type.MEGA || this.type == Type.MEGA_SPRUCE) && TerrainGen.decorate((World)worldIn, (Random)rand, (ChunkPos)new ChunkPos(pos), (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.ROCK)) {
            i = rand.nextInt(3);
            for (j = 0; j < i; ++j) {
                k = rand.nextInt(16) + 8;
                int l = rand.nextInt(16) + 8;
                BlockPos blockpos = worldIn.func_175645_m(pos.func_177982_a(k, 0, l));
                FOREST_ROCK_GENERATOR.func_180709_b(worldIn, rand, blockpos);
            }
        }
        field_180280_ag.func_180710_a(BlockDoublePlant.EnumPlantType.FERN);
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (ChunkPos)new ChunkPos(pos), (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FLOWERS)) {
            for (int i1 = 0; i1 < 7; ++i1) {
                int j1 = rand.nextInt(16) + 8;
                int k1 = rand.nextInt(16) + 8;
                int l1 = rand.nextInt(worldIn.func_175645_m(pos.func_177982_a(j1, 0, k1)).func_177956_o() + 32);
                field_180280_ag.func_180709_b(worldIn, rand, pos.func_177982_a(j1, l1, k1));
            }
        }
        super.func_180624_a(worldIn, rand, pos);
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        if ((this.type == Type.MEGA || this.type == Type.MEGA_SPRUCE) && rand.nextInt(3) == 0) {
            return this.type != Type.MEGA_SPRUCE && rand.nextInt(13) != 0 ? MEGA_PINE_GENERATOR : MEGA_SPRUCE_GENERATOR;
        }
        return rand.nextInt(3) == 0 ? PINE_GENERATOR : SPRUCE_GENERATOR;
    }

    public WorldGenerator func_76730_b(Random rand) {
        return rand.nextInt(5) > 0 ? new WorldGenTallGrass(BlockTallGrass.EnumType.FERN) : new WorldGenTallGrass(BlockTallGrass.EnumType.GRASS);
    }

    public float func_76741_f() {
        return 0.07f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float p_76731_1_) {
        return 35327;
    }

    public static enum Type {
        NORMAL,
        MEGA,
        MEGA_SPRUCE;

    }
}

